/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.Script;
import com.intuit.karate.StringUtils;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.ScenarioContext;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.w3c.dom.Node;

public class ScriptValue {
    public static final ScriptValue NULL = new ScriptValue(null);
    public static final ScriptValue FALSE = new ScriptValue(false);
    public static final ScriptValue ZERO = new ScriptValue(0);
    private final Object value;
    private final Type type;
    private boolean listLike;
    private boolean mapLike;
    private final String source;

    public Object getValue() {
        return this.value;
    }

    public String getTypeAsShortString() {
        switch (this.type) {
            case NULL: {
                return "null";
            }
            case UNKNOWN: {
                return "?";
            }
            case PRIMITIVE: {
                return "num";
            }
            case STRING: {
                return "str";
            }
            case MAP: {
                return "map";
            }
            case LIST: {
                return "list";
            }
            case JSON: {
                return "json";
            }
            case XML: {
                return "xml";
            }
            case JS_FUNCTION: {
                return "js()";
            }
            case BYTE_ARRAY: {
                return "byte[]";
            }
            case INPUT_STREAM: {
                return "stream";
            }
            case FEATURE: {
                return "feature";
            }
            case JAVA_FUNCTION: {
                return "java()";
            }
        }
        return "???";
    }

    public boolean isNull() {
        return this.type == Type.NULL;
    }

    public boolean isString() {
        return this.type == Type.STRING;
    }

    public boolean isStringOrStream() {
        return this.isString() || this.isStream();
    }

    public boolean isXml() {
        return this.type == Type.XML;
    }

    public boolean isStream() {
        return this.type == Type.INPUT_STREAM;
    }

    public boolean isByteArray() {
        return this.type == Type.BYTE_ARRAY;
    }

    public boolean isFeature() {
        return this.type == Type.FEATURE;
    }

    public boolean isUnknown() {
        return this.type == Type.UNKNOWN;
    }

    public boolean isBooleanTrue() {
        return this.type == Type.PRIMITIVE && "true".equals(this.value.toString());
    }

    public boolean isPrimitive() {
        return this.type == Type.PRIMITIVE;
    }

    public Number getAsNumber() {
        return this.getValue(Number.class);
    }

    public boolean isNumber() {
        return this.type == Type.PRIMITIVE && Number.class.isAssignableFrom(this.value.getClass());
    }

    public boolean isFunction() {
        return this.type == Type.JS_FUNCTION;
    }

    public boolean isListLike() {
        return this.listLike;
    }

    public List getAsList() {
        switch (this.type) {
            case LIST: {
                return this.getValue(List.class);
            }
            case JSON: {
                DocumentContext doc = (DocumentContext)this.value;
                return (List)doc.json();
            }
        }
        throw new RuntimeException("cannot convert to list: " + this);
    }

    public boolean isJson() {
        return this.type == Type.JSON;
    }

    public boolean isJsonLike() {
        switch (this.type) {
            case MAP: 
            case LIST: 
            case JSON: {
                return true;
            }
        }
        return false;
    }

    public ScriptValue copy(boolean deep) {
        switch (this.type) {
            case NULL: 
            case UNKNOWN: 
            case PRIMITIVE: 
            case STRING: 
            case JS_FUNCTION: 
            case BYTE_ARRAY: 
            case INPUT_STREAM: 
            case FEATURE: 
            case JAVA_FUNCTION: {
                return this;
            }
            case XML: {
                String xml = XmlUtils.toString(this.getValue(Node.class));
                return new ScriptValue(XmlUtils.toXmlDoc(xml));
            }
            case JSON: {
                String json = this.getValue(DocumentContext.class).jsonString();
                return new ScriptValue(JsonPath.parse((String)json));
            }
            case MAP: {
                if (deep) {
                    Map mapSource = this.getValue(Map.class);
                    String strSource = JsonPath.parse((Object)mapSource).jsonString();
                    Map mapDest = (Map)JsonPath.parse((String)strSource).read("$", new Predicate[0]);
                    ScriptValue.retainRootKeyValuesWhichAreFunctions(mapSource, mapDest, false);
                    return new ScriptValue(mapDest);
                }
                return new ScriptValue(new LinkedHashMap(this.getValue(Map.class)));
            }
            case LIST: {
                if (deep) {
                    String strList = this.getAsJsonDocument().jsonString();
                    return new ScriptValue(JsonPath.parse((String)strList));
                }
                return new ScriptValue(new ArrayList(this.getValue(List.class)));
            }
        }
        return this;
    }

    public DocumentContext getAsJsonDocument() {
        switch (this.type) {
            case JSON: {
                return this.getValue(DocumentContext.class);
            }
            case MAP: {
                Map map = this.getValue(Map.class);
                return JsonPath.parse((Object)map);
            }
            case LIST: {
                List list = this.getValue(List.class);
                return JsonPath.parse((Object)list);
            }
        }
        throw new RuntimeException("cannot convert to json: " + this);
    }

    public boolean isMapLike() {
        return this.mapLike;
    }

    public Map<String, Object> getAsMap() {
        switch (this.type) {
            case MAP: {
                return this.getValue(Map.class);
            }
            case JSON: {
                DocumentContext json = this.getValue(DocumentContext.class);
                return (Map)json.read("$", new Predicate[0]);
            }
            case XML: {
                Node xml = this.getValue(Node.class);
                return (Map)XmlUtils.toObject(xml);
            }
        }
        throw new RuntimeException("cannot convert to map: " + this);
    }

    public ScriptValue invokeFunction(ScenarioContext context, Object callArg) {
        ScriptObjectMirror som = this.getValue(ScriptObjectMirror.class);
        return Script.evalJsFunctionCall(som, callArg, context);
    }

    public Map<String, Object> evalAsMap(ScenarioContext context) {
        if (this.isFunction()) {
            ScriptValue sv = this.invokeFunction(context, null);
            return sv.isMapLike() ? sv.getAsMap() : null;
        }
        return this.isMapLike() ? this.getAsMap() : null;
    }

    public String getAsPrettyString() {
        switch (this.type) {
            case NULL: {
                return "";
            }
            case XML: {
                Node node = this.getValue(Node.class);
                return XmlUtils.toString(node, true);
            }
            case JSON: {
                DocumentContext doc = this.getValue(DocumentContext.class);
                return JsonUtils.toPrettyJsonString(doc);
            }
            case LIST: {
                List list = this.getAsList();
                DocumentContext listDoc = JsonPath.parse((Object)list);
                return JsonUtils.toPrettyJsonString(listDoc);
            }
            case MAP: {
                Map<String, Object> map = this.getAsMap();
                DocumentContext mapDoc = JsonPath.parse(map);
                return JsonUtils.toPrettyJsonString(mapDoc);
            }
            case BYTE_ARRAY: {
                return "(..bytes..)";
            }
            case INPUT_STREAM: {
                return "(..stream..)";
            }
        }
        return this.value.toString();
    }

    public Object toLowerCase() {
        switch (this.type) {
            case JSON: {
                DocumentContext doc = this.getValue(DocumentContext.class);
                return JsonUtils.toJsonDoc(doc.jsonString().toLowerCase());
            }
            case XML: {
                Node node = this.getValue(Node.class);
                return XmlUtils.toXmlDoc(XmlUtils.toString(node).toLowerCase());
            }
            case LIST: {
                List list = this.getAsList();
                DocumentContext listDoc = JsonPath.parse((Object)list);
                return JsonUtils.toJsonDoc(listDoc.jsonString().toLowerCase()).read("$", new Predicate[0]);
            }
            case MAP: {
                DocumentContext mapDoc = JsonPath.parse(this.getAsMap());
                return JsonUtils.toJsonDoc(mapDoc.jsonString().toLowerCase()).read("$", new Predicate[0]);
            }
            case INPUT_STREAM: {
                return FileUtils.toString(this.getValue(InputStream.class)).toLowerCase();
            }
            case STRING: {
                return this.value.toString().toLowerCase();
            }
        }
        return this.value;
    }

    public int getAsInt() {
        if (this.isNumber()) {
            return this.getAsNumber().intValue();
        }
        return Integer.valueOf(this.getAsString());
    }

    public String getAsStringRemovingCyclicReferences() {
        switch (this.type) {
            case MAP: 
            case JSON: {
                Map map = JsonUtils.removeCyclicReferences(this.getAsMap());
                return JsonUtils.toJsonDoc(map).jsonString();
            }
        }
        return this.getAsString();
    }

    public String getAsString() {
        switch (this.type) {
            case NULL: {
                return null;
            }
            case JSON: {
                DocumentContext doc = this.getValue(DocumentContext.class);
                return doc.jsonString();
            }
            case XML: {
                Node node = this.getValue(Node.class);
                if (node.getTextContent() != null) {
                    return node.getTextContent();
                }
                return XmlUtils.toString(node);
            }
            case LIST: {
                List list = this.getAsList();
                DocumentContext listDoc = JsonPath.parse((Object)list);
                return listDoc.jsonString();
            }
            case MAP: {
                DocumentContext mapDoc = JsonPath.parse(this.getAsMap());
                return mapDoc.jsonString();
            }
            case JS_FUNCTION: {
                return this.value.toString().replace("\n", " ");
            }
            case BYTE_ARRAY: {
                return FileUtils.toString(this.getValue(byte[].class));
            }
            case INPUT_STREAM: {
                return FileUtils.toString(this.getValue(InputStream.class));
            }
        }
        return this.value.toString();
    }

    public byte[] getAsByteArray() {
        switch (this.type) {
            case NULL: {
                return null;
            }
            case INPUT_STREAM: {
                return FileUtils.toBytes(this.getValue(InputStream.class));
            }
            case BYTE_ARRAY: {
                return this.getValue(byte[].class);
            }
        }
        return this.getAsString().getBytes();
    }

    public InputStream getAsStream() {
        switch (this.type) {
            case NULL: {
                return null;
            }
            case INPUT_STREAM: {
                return this.getValue(InputStream.class);
            }
        }
        return new ByteArrayInputStream(this.getAsString().getBytes());
    }

    public Object getAfterConvertingFromJsonOrXmlIfNeeded() {
        switch (this.type) {
            case JSON: {
                DocumentContext json = this.getValue(DocumentContext.class);
                return json.read("$", new Predicate[0]);
            }
            case XML: {
                Node xml = this.getValue(Node.class);
                return XmlUtils.toObject(xml);
            }
        }
        return this.getValue();
    }

    public Type getType() {
        return this.type;
    }

    public <T> T getValue(Class<T> clazz) {
        if (this.value == null) {
            return null;
        }
        return (T)this.value;
    }

    public ScriptValue(Object value) {
        this(value, null);
    }

    private static void retainRootKeyValuesWhichAreFunctions(Map source, Map target, boolean overWriteAll) {
        source.forEach((k, v) -> {
            if (v instanceof ScriptObjectMirror) {
                ScriptObjectMirror child = (ScriptObjectMirror)v;
                if (child.isFunction()) {
                    target.put(k, child);
                }
            } else if (overWriteAll) {
                target.put(k, v);
            }
        });
    }

    public ScriptValue(Object value, String source) {
        ScriptObjectMirror som;
        if (value instanceof ScriptObjectMirror && !(som = (ScriptObjectMirror)value).isFunction() && (value = JsonUtils.toJsonDoc(value).read("$", new Predicate[0])) instanceof Map) {
            Map map = (Map)value;
            ScriptValue.retainRootKeyValuesWhichAreFunctions((Map)som, map, true);
        }
        this.value = value;
        this.source = source;
        if (value == null) {
            this.type = Type.NULL;
        } else if (value instanceof DocumentContext) {
            DocumentContext doc = (DocumentContext)value;
            this.listLike = doc.json() instanceof List;
            this.mapLike = !this.listLike;
            this.type = Type.JSON;
        } else if (value instanceof Node) {
            this.mapLike = true;
            this.type = Type.XML;
        } else if (value instanceof List) {
            this.listLike = true;
            this.type = Type.LIST;
        } else if (value instanceof ScriptObjectMirror) {
            this.type = Type.JS_FUNCTION;
        } else if (value instanceof Map) {
            this.mapLike = true;
            this.type = Type.MAP;
        } else {
            this.type = value instanceof String ? Type.STRING : (value instanceof byte[] ? Type.BYTE_ARRAY : (value instanceof InputStream ? Type.INPUT_STREAM : (Script.isPrimitive(value.getClass()) ? Type.PRIMITIVE : (value instanceof Feature ? Type.FEATURE : (value instanceof Function ? Type.JAVA_FUNCTION : Type.UNKNOWN)))));
        }
    }

    public String toPrettyString(String key) {
        StringBuilder sb = new StringBuilder();
        String description = key + " (" + this.getTypeAsShortString() + "): ";
        sb.append(description);
        String temp = null;
        try {
            temp = this.getAsPrettyString();
        }
        catch (Exception e) {
            e.printStackTrace();
            temp = e.getMessage();
        }
        if (temp != null && temp.indexOf(10) != -1) {
            String dashes = StringUtils.repeat('-', description.length() - 1);
            sb.append('\n').append(dashes).append('\n');
        }
        sb.append(temp).append('\n');
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[type: ").append((Object)this.type);
        sb.append(", value: ").append(this.value);
        if (this.source != null) {
            sb.append(", source: ").append(this.source);
        }
        sb.append("]");
        return sb.toString();
    }

    public static enum Type {
        NULL,
        UNKNOWN,
        PRIMITIVE,
        STRING,
        MAP,
        LIST,
        JSON,
        XML,
        JS_FUNCTION,
        BYTE_ARRAY,
        INPUT_STREAM,
        FEATURE,
        JAVA_FUNCTION;

    }
}

