/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.ScriptEvalContext;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.ScriptValueMap;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.core.ScriptBridge;
import com.intuit.karate.exception.KarateAbortException;
import com.intuit.karate.exception.KarateFailException;
import com.intuit.karate.exception.KarateFileNotFoundException;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class ScriptBindings
implements Bindings {
    public static final String KARATE = "karate";
    public static final String KARATE_ENV = "karate.env";
    public static final String KARATE_CONFIG_DIR = "karate.config.dir";
    private static final String KARATE_DASH_CONFIG = "karate-config";
    private static final String KARATE_DASH_BASE = "karate-base";
    private static final String DOT_JS = ".js";
    public static final String KARATE_CONFIG_JS = "karate-config.js";
    private static final String KARATE_BASE_JS = "karate-base.js";
    public static final String READ = "read";
    public static final String DRIVER = "driver";
    public static final String ROBOT = "robot";
    public static final String KEY = "Key";
    public static final String SUREFIRE_REPORTS = "surefire-reports";
    public static final String PATH_MATCHES = "pathMatches";
    public static final String METHOD_IS = "methodIs";
    public static final String TYPE_CONTAINS = "typeContains";
    public static final String ACCEPT_CONTAINS = "acceptContains";
    public static final String HEADER_CONTAINS = "headerContains";
    public static final String PARAM_VALUE = "paramValue";
    public static final String PARAM_EXISTS = "paramExists";
    public static final String PATH_PARAMS = "pathParams";
    public static final String PATH_MATCH_SCORES = "pathMatchScores";
    public static final String METHOD_MATCH = "methodMatch";
    public static final String HEADERS_MATCH_SCORE = "headersMatchScore";
    public static final String QUERY_MATCH_SCORE = "queryMatchScore";
    public static final String BODY_PATH = "bodyPath";
    public static final String SERVER_PORT = "serverPort";
    private static final ScriptEngine NASHORN = new ScriptEngineManager(null).getEngineByName("nashorn");
    public final ScriptBridge bridge;
    private final ScriptValueMap vars;
    public final Map<String, Object> adds;
    private static final String READ_INVOKE = "%s('%s%s')";
    private static final String READ_KARATE_CONFIG_DEFAULT = String.format("%s('%s%s')", "read", "classpath:", "karate-config.js");
    public static final String READ_KARATE_CONFIG_BASE = String.format("%s('%s%s')", "read", "classpath:", "karate-base.js");

    public ScriptBindings(ScenarioContext context) {
        this.vars = context.vars;
        this.adds = new HashMap<String, Object>(10);
        this.bridge = new ScriptBridge(context);
        this.adds.put(KARATE, this.bridge);
        this.adds.put(READ, context.read);
    }

    public static final String readKarateConfigForEnv(boolean isForDefault, String configDir, String env) {
        if (isForDefault) {
            if (configDir == null) {
                return READ_KARATE_CONFIG_DEFAULT;
            }
            File configFile = new File(configDir + "/" + KARATE_CONFIG_JS);
            if (configFile.exists()) {
                return String.format(READ_INVOKE, READ, "file:", configFile.getPath().replace('\\', '/'));
            }
            return READ_KARATE_CONFIG_DEFAULT;
        }
        if (configDir == null) {
            return String.format(READ_INVOKE, READ, "classpath:", "karate-config-" + env + DOT_JS);
        }
        File configFile = new File(configDir + "/" + KARATE_DASH_CONFIG + "-" + env + DOT_JS);
        return String.format(READ_INVOKE, READ, "file:", configFile.getPath().replace('\\', '/'));
    }

    public static ScriptValue evalInNashorn(String exp, ScenarioContext context, ScriptEvalContext evalContext) {
        if (context == null) {
            return ScriptBindings.eval(exp, null);
        }
        return context.bindings.updateBindingsAndEval(exp, evalContext);
    }

    private ScriptValue updateBindingsAndEval(String exp, ScriptEvalContext ec) {
        if (ec == null) {
            this.adds.remove("_");
            this.adds.remove("$");
            this.adds.remove("_$");
        } else {
            this.adds.put("_", ec.selfValue.getAfterConvertingFromJsonOrXmlIfNeeded());
            this.adds.put("$", new ScriptValue(ec.root).getAfterConvertingFromJsonOrXmlIfNeeded());
            this.adds.put("_$", new ScriptValue(ec.parent).getAfterConvertingFromJsonOrXmlIfNeeded());
        }
        return ScriptBindings.eval(exp, this);
    }

    public static ScriptValue eval(String exp, Bindings bindings) {
        try {
            Object o = bindings == null ? NASHORN.eval(exp) : NASHORN.eval(exp, bindings);
            return new ScriptValue(o);
        }
        catch (KarateAbortException | KarateFailException | KarateFileNotFoundException ke) {
            throw ke;
        }
        catch (Exception e) {
            String append = e.getMessage() == null ? exp : e.getMessage();
            throw new RuntimeException("evaluation (js) failed: " + exp + ", " + append, e);
        }
    }

    public static Bindings createBindings() {
        return NASHORN.createBindings();
    }

    public void putAdditionalVariable(String name, Object value) {
        this.adds.put(name, value);
    }

    @Override
    public Object get(Object key) {
        ScriptValue sv = (ScriptValue)this.vars.get(key);
        if (sv == null) {
            return this.adds.get(key);
        }
        return sv.getAfterConvertingFromJsonOrXmlIfNeeded();
    }

    @Override
    public Object put(String name, Object value) {
        return this.adds.put(name, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        this.adds.putAll(toMerge);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.vars.containsKey(key) || this.adds.containsKey(key);
    }

    @Override
    public int size() {
        return this.vars.size() + this.adds.size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>(this.vars.keySet());
        keys.addAll(this.adds.keySet());
        return keys;
    }

    @Override
    public Collection<Object> values() {
        return this.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashMap<String, Object> temp = new HashMap<String, Object>(this.size());
        temp.putAll(this.adds);
        this.vars.forEach((k, sv) -> {
            Object value = sv == null ? null : sv.getAfterConvertingFromJsonOrXmlIfNeeded();
            temp.put((String)k, value);
        });
        return temp.entrySet();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public void clear() {
        this.adds.clear();
    }

    @Override
    public Object remove(Object key) {
        return this.adds.remove(key);
    }
}

