/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.FileUtils;
import com.intuit.karate.core.ScenarioResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Results {
    private final int threadCount;
    private int featureCount;
    private int scenarioCount;
    private int failCount;
    private int skipCount;
    private double timeTakenMillis;
    private final long startTime;
    private long endTime;
    private Map<String, String> failedMap;
    private Throwable failureReason;
    private String reportDir;
    private final List<ScenarioResult> scenarioResults = new ArrayList<ScenarioResult>();

    public void printStats(int threadCount) {
        System.out.println("Karate version: " + FileUtils.getKarateVersion());
        System.out.println("======================================================");
        System.out.println(String.format("elapsed: %6.2f | threads: %4d | thread time: %.2f ", this.getElapsedTime() / 1000.0, threadCount, this.timeTakenMillis / 1000.0));
        System.out.println(String.format("features: %5d | ignored: %4d | efficiency: %.2f", this.featureCount, this.skipCount, this.getEfficiency()));
        System.out.println(String.format("scenarios: %4d | passed: %5d | failed: %d", this.scenarioCount, this.getPassCount(), this.failCount));
        System.out.println("======================================================");
        System.out.println(this.getErrorMessages());
        if (this.failureReason != null) {
            if (this.failCount == 0) {
                this.failCount = 1;
            }
            System.out.println("*** runner exception stack trace ***");
            this.failureReason.printStackTrace();
        }
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("version", FileUtils.getKarateVersion());
        map.put("threads", this.threadCount);
        map.put("features", this.featureCount);
        map.put("ignored", this.skipCount);
        map.put("scenarios", this.scenarioCount);
        map.put("failed", this.failCount);
        map.put("passed", this.getPassCount());
        map.put("elapsedTime", this.getElapsedTime());
        map.put("totalTime", this.getTimeTakenMillis());
        map.put("efficiency", this.getEfficiency());
        map.put("failures", this.failedMap);
        return map;
    }

    private Results(long startTime, int threadCount) {
        this.startTime = startTime;
        this.threadCount = threadCount;
    }

    public void addToFailedList(String name, String errorMessage) {
        if (this.failedMap == null) {
            this.failedMap = new LinkedHashMap<String, String>();
        }
        this.failedMap.put(name, errorMessage);
    }

    public static Results startTimer(int threadCount) {
        return new Results(System.currentTimeMillis(), threadCount);
    }

    public String getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(String reportDir) {
        this.reportDir = reportDir;
    }

    public void setFailureReason(Throwable failureReason) {
        this.failureReason = failureReason;
    }

    public Throwable getFailureReason() {
        return this.failureReason;
    }

    public void addToScenarioCount(int count) {
        this.scenarioCount += count;
    }

    public void incrementFeatureCount() {
        ++this.featureCount;
    }

    public void addToFailCount(int count) {
        this.failCount += count;
    }

    public void addToSkipCount(int count) {
        this.skipCount += count;
    }

    public void addToTimeTaken(double time) {
        this.timeTakenMillis += time;
    }

    public void stopTimer() {
        this.endTime = System.currentTimeMillis();
    }

    public void addScenarioResults(List<ScenarioResult> list) {
        this.scenarioResults.addAll(list);
    }

    public List<ScenarioResult> getScenarioResults() {
        return this.scenarioResults;
    }

    public String getErrorMessages() {
        StringBuilder sb = new StringBuilder();
        if (this.failedMap != null) {
            sb.append("failed features:\n");
            this.failedMap.forEach((k, v) -> sb.append((String)k).append(": ").append((String)v).append('\n'));
        }
        return sb.toString();
    }

    public double getElapsedTime() {
        return this.endTime - this.startTime;
    }

    public double getEfficiency() {
        return this.timeTakenMillis / (this.getElapsedTime() * (double)this.threadCount);
    }

    public int getPassCount() {
        return this.scenarioCount - this.failCount;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getFeatureCount() {
        return this.featureCount;
    }

    public int getScenarioCount() {
        return this.scenarioCount;
    }

    public int getFailCount() {
        return this.failCount;
    }

    public double getTimeTakenMillis() {
        return this.timeTakenMillis;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Map<String, String> getFailedMap() {
        return this.failedMap;
    }
}

