/*
 * Decompiled with CFR 0.152.
 */
package io.netty.karate.handler.codec.base64;

import io.netty.karate.buffer.ByteBuf;
import io.netty.karate.channel.ChannelHandler;
import io.netty.karate.channel.ChannelHandlerContext;
import io.netty.karate.handler.codec.MessageToMessageDecoder;
import io.netty.karate.handler.codec.base64.Base64;
import io.netty.karate.handler.codec.base64.Base64Dialect;
import java.util.List;

@ChannelHandler.Sharable
public class Base64Decoder
extends MessageToMessageDecoder<ByteBuf> {
    private final Base64Dialect dialect;

    public Base64Decoder() {
        this(Base64Dialect.STANDARD);
    }

    public Base64Decoder(Base64Dialect dialect) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        this.dialect = dialect;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        out.add(Base64.decode(msg, msg.readerIndex(), msg.readableBytes(), this.dialect));
    }
}

