/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.netty;

import com.intuit.karate.netty.FeatureServer;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangedWatcher {
    private static final Logger logger = LoggerFactory.getLogger(FileChangedWatcher.class);
    private final File file;
    private FeatureServer server;
    private final Integer port;
    private final boolean ssl;
    private final File cert;
    private final File key;

    public FileChangedWatcher(File mock, FeatureServer server, Integer port, boolean ssl, File cert, File key) {
        this.file = mock;
        this.server = server;
        this.port = port;
        this.ssl = ssl;
        this.cert = cert;
        this.key = key;
    }

    public void watch() throws InterruptedException, IOException {
        try {
            Path directoryPath = this.file.toPath().getParent();
            WatchService watchService = FileSystems.getDefault().newWatchService();
            directoryPath.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            while (true) {
                WatchKey wk = watchService.take();
                for (WatchEvent<?> event : wk.pollEvents()) {
                    Path fileChangedPath = (Path)event.context();
                    if (!fileChangedPath.endsWith(this.file.getName())) continue;
                    this.onModified();
                }
                wk.reset();
            }
        }
        catch (Exception e) {
            logger.error("exception when handling change of mock file: {}", (Object)e.getMessage());
            return;
        }
    }

    public void onModified() {
        if (this.server != null) {
            this.server.stop();
            this.server = FeatureServer.start(this.file, this.port, this.ssl, this.cert, this.key, null);
        }
    }
}

