/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.ScriptValue;
import com.intuit.karate.http.Cookie;
import com.intuit.karate.http.MultiPartItem;
import com.intuit.karate.http.MultiValuedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HttpRequestBuilder {
    private String url;
    private List<String> paths;
    private MultiValuedMap headers;
    private MultiValuedMap params;
    private Map<String, Cookie> cookies;
    private MultiValuedMap formFields;
    private List<MultiPartItem> multiPartItems;
    private ScriptValue body;
    private String method;
    private String soapAction;
    private String retryUntil;

    public HttpRequestBuilder copy() {
        HttpRequestBuilder out = new HttpRequestBuilder();
        out.url = this.url;
        if (this.paths != null) {
            out.paths = new ArrayList<String>(this.paths);
        }
        if (this.headers != null) {
            out.headers = new MultiValuedMap(this.headers);
        }
        if (this.params != null) {
            out.params = new MultiValuedMap(this.params);
        }
        if (this.cookies != null) {
            out.cookies = new LinkedHashMap<String, Cookie>(this.cookies);
        }
        if (this.formFields != null) {
            out.formFields = new MultiValuedMap(this.formFields);
        }
        if (this.multiPartItems != null) {
            out.multiPartItems = new ArrayList<MultiPartItem>(this.multiPartItems);
        }
        if (this.body != null) {
            out.body = this.body.copy(true);
        }
        out.method = this.method;
        out.soapAction = this.soapAction;
        out.retryUntil = this.retryUntil;
        return out;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    private static String getFirst(MultiValuedMap map, String name) {
        if (map == null) {
            return null;
        }
        Object temp = map.getFirst(name);
        return temp == null ? null : temp.toString();
    }

    public String getHeader(String name) {
        return HttpRequestBuilder.getFirst(this.headers, name);
    }

    public String getParam(String name) {
        return HttpRequestBuilder.getFirst(this.params, name);
    }

    public String getUrlAndPath() {
        String temp = this.url;
        if (this.paths == null) {
            if (!temp.endsWith("/")) {
                temp = temp + "/";
            }
            return temp;
        }
        for (String path : this.paths) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!temp.endsWith("/")) {
                temp = temp + "/";
            }
            temp = temp + path;
        }
        return temp;
    }

    public void addPath(String path) {
        if (path == null) {
            return;
        }
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.add(path);
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void removeHeader(String name) {
        if (this.headers == null) {
            return;
        }
        this.headers.remove(name);
    }

    public void removeHeaderIgnoreCase(String name) {
        if (this.headers == null || name == null) {
            return;
        }
        List<String> list = this.headers.keySet().stream().filter(k -> name.equalsIgnoreCase((String)k)).collect(Collectors.toList());
        list.forEach(k -> {
            List cfr_ignored_0 = (List)this.headers.remove(k);
        });
    }

    public void setHeaders(MultiValuedMap headers) {
        this.headers = headers;
    }

    public void setHeader(String name, Object value) {
        if (value instanceof List) {
            this.setHeader(name, (List)value);
        } else if (value != null) {
            this.setHeader(name, value.toString());
        } else {
            if (this.headers == null) {
                this.headers = new MultiValuedMap();
            }
            this.headers.put(name, null);
        }
    }

    public void setHeader(String name, String value) {
        this.setHeader(name, Collections.singletonList(value));
    }

    public void setHeader(String name, List<String> values) {
        if (this.headers == null) {
            this.headers = new MultiValuedMap();
        }
        this.headers.put(name, values);
    }

    public MultiValuedMap getHeaders() {
        return this.headers;
    }

    public void removeParam(String name) {
        if (this.params == null) {
            return;
        }
        this.params.remove(name);
    }

    public void setParam(String name, String value) {
        this.setParam(name, Collections.singletonList(value));
    }

    public void setParam(String name, List<String> values) {
        if (this.params == null) {
            this.params = new MultiValuedMap();
        }
        this.params.put(name, values);
    }

    public MultiValuedMap getParams() {
        return this.params;
    }

    public void removeCookie(String name) {
        if (this.cookies == null) {
            return;
        }
        this.cookies.remove(name);
    }

    public void setCookie(Cookie cookie) {
        if (this.cookies == null) {
            this.cookies = new LinkedHashMap<String, Cookie>();
        }
        this.cookies.put(cookie.getName(), cookie);
    }

    public Map<String, Cookie> getCookies() {
        return this.cookies;
    }

    public void setCookies(Map<String, Cookie> cookies) {
        this.cookies = cookies;
    }

    public void removeFormField(String name) {
        if (this.formFields == null) {
            return;
        }
        this.formFields.remove(name);
    }

    public void setFormField(String name, String value) {
        this.setFormField(name, Collections.singletonList(value));
    }

    public void setFormField(String name, List<String> values) {
        if (this.formFields == null) {
            this.formFields = new MultiValuedMap();
        }
        this.formFields.put(name, values);
    }

    public MultiValuedMap getFormFields() {
        return this.formFields;
    }

    public void addMultiPartItem(String name, ScriptValue value) {
        MultiPartItem item = new MultiPartItem(name, value);
        if (value.isStream()) {
            item.setFilename(name);
        }
        this.addMultiPartItem(item);
    }

    public void addMultiPartItem(MultiPartItem item) {
        if (this.multiPartItems == null) {
            this.multiPartItems = new ArrayList<MultiPartItem>();
        }
        this.multiPartItems.add(item);
    }

    public List<MultiPartItem> getMultiPartItems() {
        return this.multiPartItems;
    }

    public ScriptValue getBody() {
        return this.body;
    }

    public void setBody(ScriptValue body) {
        this.body = body;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public String getContentType() {
        if (this.headers == null) {
            return null;
        }
        Object contentType = this.headers.getFirst("Content-Type");
        if (contentType == null) {
            return null;
        }
        return contentType.toString();
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public boolean isRetry() {
        return this.retryUntil != null;
    }

    public String getRetryUntil() {
        return this.retryUntil;
    }

    public void setRetryUntil(String retryUntil) {
        this.retryUntil = retryUntil;
    }
}

