/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.driver.Driver;
import com.intuit.karate.driver.Mouse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DriverMouse
implements Mouse {
    private final Driver driver;
    private Integer duration;
    private final List<Map<String, Object>> actions = new ArrayList<Map<String, Object>>();

    public DriverMouse(Driver driver) {
        this.driver = driver;
    }

    private Map<String, Object> moveAction(int x, int y) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "pointerMove");
        map.put("x", x);
        map.put("y", y);
        if (this.duration != null) {
            map.put("duration", this.duration);
        }
        return map;
    }

    @Override
    public DriverMouse duration(Integer duration) {
        this.duration = duration;
        return this;
    }

    @Override
    public DriverMouse move(String locator) {
        Map<String, Object> map = this.driver.position(locator);
        Number x = (Number)map.get("x");
        Number y = (Number)map.get("y");
        return this.move(x, y);
    }

    @Override
    public DriverMouse move(Number x, Number y) {
        x = x == null ? (Number)0 : (Number)x;
        y = y == null ? (Number)0 : (Number)y;
        Map<String, Object> action = this.moveAction(x.intValue(), y.intValue());
        this.actions.add(action);
        return this;
    }

    @Override
    public DriverMouse down() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "pointerDown");
        map.put("button", 0);
        this.actions.add(map);
        return this;
    }

    @Override
    public DriverMouse up() {
        HashMap<String, Object> up = new HashMap<String, Object>();
        up.put("type", "pointerUp");
        up.put("button", 0);
        this.actions.add(up);
        return this.go();
    }

    @Override
    public DriverMouse submit() {
        this.driver.submit();
        return this;
    }

    @Override
    public DriverMouse click() {
        return this.down().up();
    }

    @Override
    public DriverMouse go() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "pointer");
        map.put("id", "1");
        map.put("actions", this.actions);
        this.driver.actions(Collections.singletonList(map));
        this.actions.clear();
        return this;
    }
}

