/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.driver.DriverElement;
import com.intuit.karate.driver.DriverMouse;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.Element;
import com.intuit.karate.driver.ElementFinder;
import com.intuit.karate.driver.Finder;
import com.intuit.karate.driver.Keys;
import com.intuit.karate.driver.Mouse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Driver {
    public void activate();

    public void refresh();

    public void reload();

    public void back();

    public void forward();

    public void maximize();

    public void minimize();

    public void fullscreen();

    public void close();

    public void quit();

    public void switchPage(String var1);

    public void switchFrame(int var1);

    public void switchFrame(String var1);

    public String getUrl();

    public void setUrl(String var1);

    public Map<String, Object> getDimensions();

    public void setDimensions(Map<String, Object> var1);

    public String getTitle();

    public List<String> getPages();

    public String getDialog();

    public byte[] screenshot(boolean var1);

    default public byte[] screenshot() {
        return this.screenshot(true);
    }

    public Map<String, Object> cookie(String var1);

    public void cookie(Map<String, Object> var1);

    public void deleteCookie(String var1);

    public void clearCookies();

    public List<Map> getCookies();

    public void dialog(boolean var1);

    public void dialog(boolean var1, String var2);

    public Object script(String var1);

    public boolean waitUntil(String var1);

    public Driver submit();

    default public Driver retry() {
        return this.retry(null, null);
    }

    default public Driver retry(int count) {
        return this.retry(count, null);
    }

    default public Driver retry(Integer count, Integer interval) {
        this.getOptions().enableRetry(count, interval);
        return this;
    }

    default public Driver delay(int millis) {
        this.getOptions().sleep(millis);
        return this;
    }

    public Element focus(String var1);

    public Element clear(String var1);

    public Element click(String var1);

    public Element input(String var1, String var2);

    default public Element input(String locator, String[] values) {
        return this.input(locator, values, 0);
    }

    default public Element input(String locator, String[] values, int delay) {
        Element element = DriverElement.locatorUnknown(this, locator);
        for (String value : values) {
            if (delay > 0) {
                this.delay(delay);
            }
            element = this.input(locator, value);
        }
        return element;
    }

    public Element select(String var1, String var2);

    public Element select(String var1, int var2);

    public Element value(String var1, String var2);

    default public Element waitFor(String locator) {
        return this.getOptions().waitForAny(this, locator);
    }

    default public String waitForUrl(String expected) {
        return this.getOptions().waitForUrl(this, expected);
    }

    default public Element waitForText(String locator, String expected) {
        return this.waitUntil(locator, "_.textContent.includes('" + expected + "')");
    }

    default public Element waitForEnabled(String locator) {
        return this.waitUntil(locator, "!_.disabled");
    }

    default public List<Element> waitForResultCount(String locator, int count) {
        return (List)this.waitUntil(() -> {
            List<Element> list = this.locateAll(locator);
            return list.size() == count ? list : null;
        });
    }

    default public List waitForResultCount(String locator, int count, String expression) {
        return (List)this.waitUntil(() -> {
            List list = this.scriptAll(locator, expression);
            return list.size() == count ? list : null;
        });
    }

    default public Element waitForAny(String locator1, String locator2) {
        return this.getOptions().waitForAny(this, locator1, locator2);
    }

    default public Element waitForAny(String[] locators) {
        return this.getOptions().waitForAny(this, locators);
    }

    default public Element waitUntil(String locator, String expression) {
        return this.getOptions().waitUntil(this, locator, expression);
    }

    default public Object waitUntil(Supplier<Object> condition) {
        return this.getOptions().retry(() -> condition.get(), o -> o != null, "waitUntil (function)");
    }

    default public Element locate(String locator) {
        return DriverElement.locatorUnknown(this, locator);
    }

    default public List<Element> locateAll(String locator) {
        return this.getOptions().findAll(this, locator);
    }

    default public Element scroll(String locator) {
        this.script(locator, "function(e){ var d = window.getComputedStyle(e).display; while(d == 'none'){ e = e.parentElement; d = window.getComputedStyle(e).display } e.scrollIntoView({block: 'center'}) }");
        return DriverElement.locatorExists(this, locator);
    }

    default public Element highlight(String locator) {
        this.script(this.getOptions().highlight(locator));
        return DriverElement.locatorExists(this, locator);
    }

    default public void highlightAll(String locator) {
        this.script(this.getOptions().highlightAll(locator));
    }

    default public Finder rightOf(String locator) {
        return new ElementFinder(this, locator, ElementFinder.Type.RIGHT);
    }

    default public Finder leftOf(String locator) {
        return new ElementFinder(this, locator, ElementFinder.Type.LEFT);
    }

    default public Finder above(String locator) {
        return new ElementFinder(this, locator, ElementFinder.Type.ABOVE);
    }

    default public Finder below(String locator) {
        return new ElementFinder(this, locator, ElementFinder.Type.BELOW);
    }

    default public Finder near(String locator) {
        return new ElementFinder(this, locator, ElementFinder.Type.NEAR);
    }

    default public Mouse mouse() {
        return new DriverMouse(this);
    }

    default public Mouse mouse(String locator) {
        return new DriverMouse(this).move(locator);
    }

    default public Mouse mouse(int x, int y) {
        return new DriverMouse(this).move(x, y);
    }

    default public Keys keys() {
        return new Keys(this);
    }

    public void actions(List<Map<String, Object>> var1);

    public String html(String var1);

    public String text(String var1);

    public String value(String var1);

    public String attribute(String var1, String var2);

    public String property(String var1, String var2);

    public boolean enabled(String var1);

    default public Element exists(String locator) {
        return this.getOptions().exists(this, locator);
    }

    public Map<String, Object> position(String var1);

    public byte[] screenshot(String var1, boolean var2);

    default public byte[] screenshot(String locator) {
        return this.screenshot(locator, true);
    }

    default public Object script(String locator, String expression) {
        String js = this.getOptions().scriptSelector(locator, expression);
        return this.script(js);
    }

    default public List scriptAll(String locator, String expression) {
        String js = this.getOptions().scriptAllSelector(locator, expression);
        return (List)this.script(js);
    }

    default public List scriptAll(String locator, String expression, Predicate predicate) {
        List before = this.scriptAll(locator, expression);
        ArrayList after = new ArrayList(before.size());
        for (Object o : before) {
            if (!predicate.test(o)) continue;
            after.add(o);
        }
        return after;
    }

    public DriverOptions getOptions();

    public Object elementId(String var1);

    public List elementIds(String var1);
}

