/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.debug;

import com.intuit.karate.Runner;
import com.intuit.karate.RunnerOptions;
import com.intuit.karate.StepActions;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Engine;
import com.intuit.karate.core.ExecutionHook;
import com.intuit.karate.core.ExecutionHookFactory;
import com.intuit.karate.core.FeatureParser;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.core.Step;
import com.intuit.karate.debug.DapMessage;
import com.intuit.karate.debug.DapServer;
import com.intuit.karate.debug.DebugThread;
import com.intuit.karate.debug.SourceBreakpoints;
import com.intuit.karate.debug.StackFrame;
import io.netty.karate.buffer.Unpooled;
import io.netty.karate.channel.Channel;
import io.netty.karate.channel.ChannelHandlerContext;
import io.netty.karate.channel.SimpleChannelInboundHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DapServerHandler
extends SimpleChannelInboundHandler<DapMessage>
implements ExecutionHookFactory {
    private static final Logger logger = LoggerFactory.getLogger(DapServerHandler.class);
    private final DapServer server;
    private Channel channel;
    private int nextSeq;
    private long nextFrameId;
    private long focusedFrameId;
    private Thread runnerThread;
    private final Map<String, SourceBreakpoints> BREAKPOINTS = new ConcurrentHashMap<String, SourceBreakpoints>();
    protected final Map<Long, DebugThread> THREADS = new ConcurrentHashMap<Long, DebugThread>();
    protected final Map<Long, ScenarioContext> FRAMES = new ConcurrentHashMap<Long, ScenarioContext>();
    private boolean singleFeature;
    private String launchCommand;
    private static final String TEST_CLASSES = "/test-classes/";
    private static final String CLASSES_TEST = "/classes/java/test/";

    public DapServerHandler(DapServer server) {
        this.server = server;
    }

    private static int findPos(String path) {
        int pos = path.indexOf(TEST_CLASSES);
        if (pos != -1) {
            return pos + TEST_CLASSES.length();
        }
        pos = path.indexOf(CLASSES_TEST);
        if (pos != -1) {
            return pos + CLASSES_TEST.length();
        }
        return -1;
    }

    private SourceBreakpoints lookup(String pathEnd) {
        for (Map.Entry<String, SourceBreakpoints> entry : this.BREAKPOINTS.entrySet()) {
            if (!entry.getKey().endsWith(pathEnd)) continue;
            return entry.getValue();
        }
        return null;
    }

    protected boolean isBreakpoint(Step step, int line) {
        String path = step.getFeature().getPath().toString();
        int pos = DapServerHandler.findPos(path);
        SourceBreakpoints sb = pos != -1 ? this.lookup(path.substring(pos)) : this.BREAKPOINTS.get(path);
        if (sb == null) {
            return false;
        }
        return sb.isBreakpoint(line);
    }

    private DebugThread thread(Number threadId) {
        if (threadId == null) {
            return null;
        }
        return this.THREADS.get(threadId.longValue());
    }

    private List<Map<String, Object>> frames(Number threadId) {
        if (threadId == null) {
            return Collections.EMPTY_LIST;
        }
        DebugThread thread = this.THREADS.get(threadId.longValue());
        if (thread == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Long> frameIds = new ArrayList<Long>(thread.stack);
        Collections.reverse(frameIds);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(frameIds.size());
        for (Long frameId : frameIds) {
            ScenarioContext context = this.FRAMES.get(frameId);
            list.add(new StackFrame(frameId, context).toMap());
        }
        return list;
    }

    private List<Map<String, Object>> variables(Number frameId) {
        if (frameId == null) {
            return Collections.EMPTY_LIST;
        }
        this.focusedFrameId = frameId.longValue();
        ScenarioContext context = this.FRAMES.get(frameId.longValue());
        if (context == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        context.vars.forEach((k, v) -> {
            if (v != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", k);
                try {
                    map.put("value", v.getAsString());
                }
                catch (Exception e) {
                    logger.warn("unable to convert to string: {} - {}", k, v);
                    map.put("value", "(unknown)");
                }
                map.put("type", v.getTypeAsShortString());
                map.put("variablesReference", 0);
                list.add(map);
            }
        });
        return list;
    }

    private DapMessage event(String name) {
        return DapMessage.event(++this.nextSeq, name);
    }

    private DapMessage response(DapMessage req) {
        return DapMessage.response(++this.nextSeq, req);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, DapMessage dm) throws Exception {
        switch (dm.type) {
            case REQUEST: {
                this.handleRequest(dm, ctx);
                break;
            }
            default: {
                logger.warn("ignoring message: {}", (Object)dm);
            }
        }
    }

    private void handleRequest(DapMessage req, ChannelHandlerContext ctx) {
        switch (req.command) {
            case "initialize": {
                ctx.write(this.response(req).body("supportsConfigurationDoneRequest", true).body("supportsRestartRequest", true).body("supportsStepBack", true));
                ctx.write(this.event("initialized"));
                ctx.write(this.event("output").body("output", "debug server listening on port: " + this.server.getPort() + "\n"));
                break;
            }
            case "setBreakpoints": {
                SourceBreakpoints sb = new SourceBreakpoints(req.getArguments());
                this.BREAKPOINTS.put(sb.path, sb);
                logger.trace("source breakpoints: {}", (Object)sb);
                ctx.write(this.response(req).body("breakpoints", sb.breakpoints));
                break;
            }
            case "launch": {
                this.launchCommand = StringUtils.trimToNull(req.getArgument("karateOptions", String.class));
                if (this.launchCommand == null) {
                    this.launchCommand = req.getArgument("feature", String.class);
                    this.singleFeature = true;
                    this.start();
                } else {
                    this.start();
                }
                ctx.write(this.response(req));
                break;
            }
            case "threads": {
                ArrayList list = new ArrayList(this.THREADS.size());
                this.THREADS.values().forEach(v -> {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("id", v.id);
                    map.put("name", v.name);
                    list.add(map);
                });
                ctx.write(this.response(req).body("threads", list));
                break;
            }
            case "stackTrace": {
                ctx.write(this.response(req).body("stackFrames", this.frames(req.getThreadId())));
                break;
            }
            case "configurationDone": {
                ctx.write(this.response(req));
                break;
            }
            case "scopes": {
                Number frameId = req.getArgument("frameId", Number.class);
                HashMap<String, Object> scope = new HashMap<String, Object>();
                scope.put("name", "In Scope");
                scope.put("variablesReference", frameId);
                scope.put("presentationHint", "locals");
                scope.put("expensive", false);
                ctx.write(this.response(req).body("scopes", Collections.singletonList(scope)));
                break;
            }
            case "variables": {
                Number variablesReference = req.getArgument("variablesReference", Number.class);
                ctx.write(this.response(req).body("variables", this.variables(variablesReference)));
                break;
            }
            case "next": {
                this.thread(req.getThreadId()).step().resume();
                ctx.write(this.response(req));
                break;
            }
            case "stepBack": 
            case "reverseContinue": {
                this.thread(req.getThreadId()).stepBack(true).resume();
                ctx.write(this.response(req));
                break;
            }
            case "stepIn": {
                this.thread(req.getThreadId()).stepIn().resume();
                ctx.write(this.response(req));
                break;
            }
            case "stepOut": {
                this.thread(req.getThreadId()).stepOut().resume();
                ctx.write(this.response(req));
                break;
            }
            case "continue": {
                this.thread(req.getThreadId()).clearStepModes().resume();
                ctx.write(this.response(req));
                break;
            }
            case "pause": {
                ctx.write(this.response(req));
                this.thread(req.getThreadId()).pause();
                break;
            }
            case "evaluate": {
                String result;
                String expression = req.getArgument("expression", String.class);
                Number evalFrameId = req.getArgument("frameId", Number.class);
                ScenarioContext evalContext = this.FRAMES.get(evalFrameId.longValue());
                Scenario evalScenario = evalContext.getExecutionUnit().scenario;
                Step evalStep = new Step(evalScenario.getFeature(), evalScenario, evalScenario.getIndex() + 1);
                try {
                    FeatureParser.updateStepFromText(evalStep, expression);
                    StepActions evalActions = new StepActions(evalContext);
                    Result evalResult = Engine.executeStep(evalStep, evalActions);
                    result = evalResult.isFailed() ? "[error] " + evalResult.getError().getMessage() : "[done]";
                }
                catch (Exception e) {
                    result = "[error] " + e.getMessage();
                }
                ctx.write(this.response(req).body("result", result).body("variablesReference", 0));
                break;
            }
            case "restart": {
                ScenarioContext context = this.FRAMES.get(this.focusedFrameId);
                if (context != null && context.hotReload()) {
                    this.output("[debug] hot reload successful");
                } else {
                    this.output("[debug] hot reload requested, but no steps edited");
                }
                ctx.write(this.response(req));
                break;
            }
            case "disconnect": {
                boolean restart = req.getArgument("restart", Boolean.class);
                if (restart) {
                    this.start();
                } else {
                    this.exit();
                }
                ctx.write(this.response(req));
                break;
            }
            default: {
                logger.warn("unknown command: {}", (Object)req);
                ctx.write(this.response(req));
            }
        }
        ctx.writeAndFlush(Unpooled.EMPTY_BUFFER);
    }

    @Override
    public ExecutionHook create() {
        return new DebugThread(Thread.currentThread(), this);
    }

    private void start() {
        RunnerOptions options;
        logger.debug("command line: {}", (Object)this.launchCommand);
        if (this.singleFeature) {
            options = new RunnerOptions();
            options.addFeature(this.launchCommand);
        } else {
            options = RunnerOptions.parseCommandLine(this.launchCommand);
        }
        if (this.runnerThread != null) {
            this.runnerThread.interrupt();
        }
        this.runnerThread = new Thread(() -> {
            Runner.path(options.getFeatures()).hookFactory(this).tags(options.getTags()).scenarioName(options.getName()).parallel(options.getThreads());
            this.exit();
        });
        this.runnerThread.start();
    }

    protected void stopEvent(long threadId, String reason, String description) {
        this.channel.eventLoop().execute(() -> {
            DapMessage message = this.event("stopped").body("reason", reason).body("threadId", threadId);
            if (description != null) {
                message.body("description", description);
            }
            this.channel.writeAndFlush(message);
        });
    }

    protected void continueEvent(long threadId) {
        this.channel.eventLoop().execute(() -> {
            DapMessage message = this.event("continued").body("threadId", threadId);
            this.channel.writeAndFlush(message);
        });
    }

    private void exit() {
        this.channel.eventLoop().execute(() -> this.channel.writeAndFlush(this.event("exited").body("exitCode", 0)));
        this.server.stop();
        System.exit(0);
    }

    protected long nextFrameId() {
        return ++this.nextFrameId;
    }

    protected void output(String text) {
        this.channel.eventLoop().execute(() -> this.channel.writeAndFlush(this.event("output").body("output", text)));
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.channel = ctx.channel();
    }
}

