/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.debug;

import com.intuit.karate.JsonUtils;
import java.util.HashMap;
import java.util.Map;

public class DapMessage {
    public final int seq;
    public final Type type;
    public final String command;
    public final String event;
    private Map<String, Object> arguments;
    private Integer requestSeq;
    private Boolean success;
    private String message;
    private Map<String, Object> body;

    public DapMessage body(String key, Object value) {
        if (this.body == null) {
            this.body = new HashMap<String, Object>();
        }
        this.body.put(key, value);
        return this;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public Number getThreadId() {
        return this.getArgument("threadId", Number.class);
    }

    public <T> T getArgument(String key, Class<T> clazz) {
        if (this.arguments == null) {
            return null;
        }
        return (T)this.arguments.get(key);
    }

    public static Type parse(String s) {
        switch (s) {
            case "request": {
                return Type.REQUEST;
            }
            case "response": {
                return Type.RESPONSE;
            }
        }
        return Type.EVENT;
    }

    public static DapMessage event(int seq, String name) {
        return new DapMessage(seq, Type.EVENT, null, name);
    }

    public static DapMessage response(int seq, DapMessage req) {
        DapMessage dm = new DapMessage(seq, Type.RESPONSE, req.command, null);
        dm.requestSeq = req.seq;
        dm.success = true;
        return dm;
    }

    private DapMessage(int seq, Type type, String command, String event) {
        this.seq = seq;
        this.type = type;
        this.command = command;
        this.event = event;
    }

    public DapMessage(Map<String, Object> map) {
        this.seq = (Integer)map.get("seq");
        this.type = DapMessage.parse((String)map.get("type"));
        this.command = (String)map.get("command");
        this.arguments = (Map)map.get("arguments");
        this.requestSeq = (Integer)map.get("request_seq");
        this.success = (Boolean)map.get("success");
        this.message = (String)map.get("message");
        this.event = (String)map.get("event");
        this.body = (Map)map.get("body");
    }

    public String toJson() {
        return JsonUtils.toJson(this.toMap());
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("seq", this.seq);
        map.put("type", this.type.toString().toLowerCase());
        if (this.command != null) {
            map.put("command", this.command);
        }
        if (this.arguments != null) {
            map.put("arguments", this.arguments);
        }
        if (this.requestSeq != null) {
            map.put("request_seq", this.requestSeq);
        }
        if (this.success != null) {
            map.put("success", this.success);
        }
        if (this.message != null) {
            map.put("message", this.message);
        }
        if (this.event != null) {
            map.put("event", this.event);
        }
        if (this.body != null) {
            map.put("body", this.body);
        }
        return map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[seq: ").append(this.seq);
        sb.append(", type: ").append((Object)this.type);
        if (this.command != null) {
            sb.append(", command: ").append(this.command);
        }
        if (this.arguments != null) {
            sb.append(", arguments: ").append(this.arguments);
        }
        if (this.requestSeq != null) {
            sb.append(", request_seq: ").append(this.requestSeq);
        }
        if (this.success != null) {
            sb.append(", success: ").append(this.success);
        }
        if (this.message != null) {
            sb.append(", message: ").append(this.message);
        }
        if (this.event != null) {
            sb.append(", event: ").append(this.event);
        }
        if (this.body != null) {
            sb.append(", body: ").append(this.body);
        }
        sb.append("]");
        return sb.toString();
    }

    public static enum Type {
        REQUEST,
        RESPONSE,
        EVENT;

    }
}

