/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.AssertionResult;
import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.PerfContext;
import com.intuit.karate.Script;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.MatchType;
import com.intuit.karate.core.PerfEvent;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.exception.KarateAbortException;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpRequestBuilder;
import com.intuit.karate.http.HttpResponse;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.MultiValuedMap;
import com.intuit.karate.netty.FeatureServer;
import com.intuit.karate.netty.WebSocketClient;
import com.intuit.karate.netty.WebSocketOptions;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ScriptBridge
implements PerfContext {
    private static final Object GLOBALS_LOCK = new Object();
    private static final Map<String, Object> GLOBALS = new HashMap<String, Object>();
    public final ScenarioContext context;
    private static final ThreadLocal<ScenarioContext> CURRENT_CONTEXT = new ThreadLocal();

    public ScriptBridge(ScenarioContext context) {
        this.context = context;
        CURRENT_CONTEXT.set(context);
    }

    public ScenarioContext getContext() {
        return this.context;
    }

    public void configure(String key, Object o) {
        this.context.configure(key, new ScriptValue(o));
    }

    public Object read(String fileName) {
        return this.context.read.apply(fileName);
    }

    public String readAsString(String fileName) {
        return FileUtils.readFileAsString(fileName, this.context);
    }

    public String pretty(Object o) {
        ScriptValue sv = new ScriptValue(o);
        return sv.getAsPrettyString();
    }

    public String prettyXml(Object o) {
        ScriptValue sv = new ScriptValue(o);
        if (sv.isXml()) {
            Node node = sv.getValue(Node.class);
            return XmlUtils.toString(node, true);
        }
        if (sv.isMapLike()) {
            Document doc = XmlUtils.fromMap(sv.getAsMap());
            return XmlUtils.toString(doc, true);
        }
        String xml = sv.getAsString();
        Document doc = XmlUtils.toXmlDoc(xml);
        return XmlUtils.toString(doc, true);
    }

    public void set(String name, Object o) {
        this.context.vars.put(name, o);
    }

    public void setXml(String name, String xml) {
        this.context.vars.put(name, XmlUtils.toXmlDoc(xml));
    }

    public void set(String name, String path, Object value) {
        Script.setValueByPath(name, path, new ScriptValue(value), this.context);
    }

    public void set(Map<String, Object> map) {
        map.forEach((k, v) -> this.set((String)k, v));
    }

    public void remove(String name, String path) {
        Script.removeValueByPath(name, path, this.context);
    }

    public Object get(String exp) {
        ScriptValue sv;
        try {
            sv = Script.evalKarateExpression(exp, this.context);
        }
        catch (Exception e) {
            this.context.logger.trace("karate.get failed for expression: '{}': {}", exp, e.getMessage());
            return null;
        }
        if (sv != null) {
            return sv.getAfterConvertingFromJsonOrXmlIfNeeded();
        }
        return null;
    }

    public Object get(String exp, Object defaultValue) {
        Object result = this.get(exp);
        return result == null ? defaultValue : result;
    }

    public int sizeOf(List list) {
        return list.size();
    }

    public int sizeOf(Map map) {
        return map.size();
    }

    public List keysOf(Map map) {
        return new ArrayList(map.keySet());
    }

    public List valuesOf(List list) {
        return list;
    }

    public List valuesOf(Map map) {
        return new ArrayList(map.values());
    }

    public Map<String, Object> match(Object actual, Object expected) {
        AssertionResult result = Script.matchNestedObject('.', "$", MatchType.EQUALS, actual, null, actual, expected, this.context);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("pass", result.pass);
        map.put("message", result.message);
        return map;
    }

    public void forEach(Map<String, Object> map, ScriptObjectMirror som) {
        if (map == null) {
            return;
        }
        if (!som.isFunction()) {
            throw new RuntimeException("not a JS function: " + som);
        }
        AtomicInteger i = new AtomicInteger();
        map.forEach((k, v) -> som.call((Object)som, new Object[]{k, v, i.getAndIncrement()}));
    }

    public void forEach(List list, ScriptObjectMirror som) {
        if (list == null) {
            return;
        }
        if (!som.isFunction()) {
            throw new RuntimeException("not a JS function: " + som);
        }
        for (int i = 0; i < list.size(); ++i) {
            som.call((Object)som, new Object[]{list.get(i), i});
        }
    }

    public Object map(List list, ScriptObjectMirror som) {
        if (list == null) {
            return new ArrayList();
        }
        if (!som.isFunction()) {
            throw new RuntimeException("not a JS function: " + som);
        }
        ArrayList<Object> res = new ArrayList<Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object y = som.call((Object)som, new Object[]{list.get(i), i});
            res.add(y);
        }
        return res;
    }

    public Object filter(List list, ScriptObjectMirror som) {
        if (list == null) {
            return new ArrayList();
        }
        if (!som.isFunction()) {
            throw new RuntimeException("not a JS function: " + som);
        }
        ArrayList res = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            String exp;
            ScriptValue sv;
            Object x = list.get(i);
            Object y = som.call((Object)som, new Object[]{x, i});
            if (y instanceof Boolean) {
                if (!((Boolean)y).booleanValue()) continue;
                res.add(x);
                continue;
            }
            if (!(y instanceof Number) || (sv = Script.evalJsExpression(exp = y + " == 0", null)).isBooleanTrue()) continue;
            res.add(x);
        }
        return res;
    }

    public Object filterKeys(Map<String, Object> map, Map<String, Object> filter) {
        if (map == null) {
            return new LinkedHashMap();
        }
        if (filter == null) {
            return map;
        }
        LinkedHashMap out = new LinkedHashMap(filter.size());
        filter.keySet().forEach(k -> {
            if (map.containsKey(k)) {
                out.put(k, map.get(k));
            }
        });
        return out;
    }

    public Object filterKeys(Map<String, Object> map, List keys) {
        return this.filterKeys(map, keys.toArray());
    }

    public Object filterKeys(Map map, Object ... keys) {
        if (map == null) {
            return new LinkedHashMap();
        }
        LinkedHashMap out = new LinkedHashMap(keys.length);
        for (Object key : keys) {
            if (!map.containsKey(key)) continue;
            out.put(key, map.get(key));
        }
        return out;
    }

    public Object repeat(int n, ScriptObjectMirror som) {
        if (!som.isFunction()) {
            throw new RuntimeException("not a JS function: " + som);
        }
        ArrayList<Object> res = new ArrayList<Object>();
        for (int i = 0; i < n; ++i) {
            Object o = som.call((Object)som, new Object[]{i});
            res.add(o);
        }
        return res;
    }

    public Object mapWithKey(List list, String key) {
        if (list == null) {
            return new ArrayList();
        }
        ArrayList res = new ArrayList(list.size());
        for (Object o : list) {
            LinkedHashMap map = new LinkedHashMap();
            map.put(key, o);
            res.add(map);
        }
        return res;
    }

    public Object merge(Map ... maps) {
        LinkedHashMap out = new LinkedHashMap();
        if (maps == null) {
            return out;
        }
        for (Map map : maps) {
            if (map == null) continue;
            out.putAll(map);
        }
        return out;
    }

    public Object append(Object ... items) {
        ArrayList<Object> out = new ArrayList<Object>();
        if (items == null) {
            return out;
        }
        for (Object item : items) {
            if (item == null) continue;
            if (item instanceof ScriptObjectMirror) {
                ScriptObjectMirror som = (ScriptObjectMirror)item;
                if (som.isArray()) {
                    out.addAll(som.values());
                    continue;
                }
                out.add(som);
                continue;
            }
            if (item instanceof Collection) {
                out.addAll((Collection)item);
                continue;
            }
            out.add(item);
        }
        return out;
    }

    public List appendTo(String name, Object ... values) {
        ScriptValue sv = (ScriptValue)this.context.vars.get(name);
        if (sv == null || !sv.isListLike()) {
            return Collections.EMPTY_LIST;
        }
        List list = this.appendTo(sv.getAsList(), values);
        this.context.vars.put(name, list);
        return list;
    }

    public List appendTo(List list, Object ... values) {
        for (Object o : values) {
            if (o instanceof Collection) {
                list.addAll((Collection)o);
                continue;
            }
            list.add(o);
        }
        return list;
    }

    public Object jsonPath(Object o, String exp) {
        DocumentContext doc = o instanceof DocumentContext ? (DocumentContext)o : JsonPath.parse((Object)o);
        return doc.read(exp, new Predicate[0]);
    }

    public Object lowerCase(Object o) {
        ScriptValue sv = new ScriptValue(o);
        return sv.toLowerCase();
    }

    public Object xmlPath(Object o, String path) {
        if (!(o instanceof Node)) {
            if (o instanceof Map) {
                o = XmlUtils.fromMap((Map)o);
            } else {
                throw new RuntimeException("not XML or cannot convert: " + o);
            }
        }
        ScriptValue sv = Script.evalXmlPathOnXmlNode((Node)o, path);
        return sv.getValue();
    }

    public Object toBean(Object o, String className) {
        ScriptValue sv = new ScriptValue(o);
        DocumentContext doc = Script.toJsonDoc(sv, this.context);
        return JsonUtils.fromJson(doc.jsonString(), className);
    }

    public Object toMap(Object o) {
        if (o instanceof Map) {
            Map src = (Map)o;
            return new LinkedHashMap(src);
        }
        return o;
    }

    public Object toList(Object o) {
        if (o instanceof List) {
            List src = (List)o;
            return new ArrayList(src);
        }
        return o;
    }

    public Object toJson(Object o) {
        return this.toJson(o, false);
    }

    public Object toJson(Object o, boolean removeNulls) {
        Object result = JsonUtils.toJsonDoc(o).read("$", new Predicate[0]);
        if (removeNulls) {
            JsonUtils.removeKeysWithNullValues(result);
        }
        return result;
    }

    public Object call(String fileName) {
        return this.call(fileName, null);
    }

    public Object call(String fileName, Object arg) {
        ScriptValue sv = FileUtils.readFile(fileName, this.context);
        switch (sv.getType()) {
            case FEATURE: {
                Feature feature = sv.getValue(Feature.class);
                return Script.evalFeatureCall(feature, arg, this.context, false, CURRENT_CONTEXT.get()).getValue();
            }
            case JS_FUNCTION: {
                ScriptObjectMirror som = sv.getValue(ScriptObjectMirror.class);
                return Script.evalJsFunctionCall(som, arg, this.context).getValue();
            }
        }
        this.context.logger.warn("not a js function or feature file: {} - {}", fileName, sv);
        return null;
    }

    public Object callSingle(String fileName) {
        return this.callSingle(fileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callSingle(String fileName, Object arg) {
        if (GLOBALS.containsKey(fileName)) {
            this.context.logger.trace("callSingle cache hit: {}", fileName);
            return GLOBALS.get(fileName);
        }
        long startTime = System.currentTimeMillis();
        this.context.logger.trace("callSingle waiting for lock: {}", fileName);
        Object object = GLOBALS_LOCK;
        synchronized (object) {
            if (GLOBALS.containsKey(fileName)) {
                long endTime = System.currentTimeMillis() - startTime;
                this.context.logger.warn("this thread waited {} milliseconds for callSingle lock: {}", endTime, fileName);
                return GLOBALS.get(fileName);
            }
            this.context.logger.info(">> lock acquired, begin callSingle: {}", fileName);
            Object result = this.call(fileName, arg);
            GLOBALS.put(fileName, result);
            this.context.logger.info("<< lock released, cached callSingle: {}", fileName);
            return result;
        }
    }

    public HttpRequest getPrevRequest() {
        return this.context.getPrevRequest();
    }

    public String exec(String command) {
        Runtime runtime = Runtime.getRuntime();
        try {
            InputStream is = runtime.exec(command).getInputStream();
            return FileUtils.toString(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Object eval(String exp) {
        ScriptValue sv = Script.evalJsExpression(exp, this.context);
        return sv.getValue();
    }

    public List<String> getTags() {
        return this.context.tags;
    }

    public Map<String, List<String>> getTagValues() {
        return this.context.tagValues;
    }

    public Map<String, Object> getInfo() {
        DocumentContext doc = JsonUtils.toJsonDoc(this.context.scenarioInfo);
        return (Map)doc.read("$", new Predicate[0]);
    }

    public void proceed() {
        this.proceed(null);
    }

    public void proceed(String requestUrlBase) {
        HttpRequestBuilder request = new HttpRequestBuilder();
        String urlBase = requestUrlBase == null ? this.getAsString("requestUrlBase") : requestUrlBase;
        String uri = this.getAsString("requestUri");
        String url = uri == null ? urlBase : urlBase + uri;
        request.setUrl(url);
        request.setMethod(this.getAsString("requestMethod"));
        request.setHeaders(this.getValue("requestHeaders").getValue(MultiValuedMap.class));
        request.removeHeaderIgnoreCase("Content-Length");
        request.setBody(this.getValue("request"));
        HttpResponse response = this.context.getHttpClient().invoke(request, this.context);
        this.context.setPrevResponse(response);
        this.context.updateResponseVars();
    }

    public void abort() {
        throw new KarateAbortException(null);
    }

    public void embed(Object o, String contentType) {
        ScriptValue sv = new ScriptValue(o);
        if (contentType == null) {
            contentType = HttpUtils.getContentType(sv);
        }
        this.context.embed(sv.getAsByteArray(), contentType);
    }

    public File write(Object o, String path) {
        ScriptValue sv = new ScriptValue(o);
        path = FileUtils.getBuildDir() + File.separator + path;
        File file = new File(path);
        FileUtils.writeToFile(file, sv.getAsByteArray());
        return file;
    }

    public WebSocketClient webSocket(String url) {
        return this.webSocket(url, null, null);
    }

    public WebSocketClient webSocket(String url, Function<String, Boolean> handler) {
        return this.webSocket(url, handler, null);
    }

    public WebSocketClient webSocket(String url, Function<String, Boolean> handler, Map<String, Object> map) {
        if (handler == null) {
            handler = t -> true;
        }
        WebSocketOptions options = new WebSocketOptions(url, map);
        options.setTextHandler(handler);
        return this.context.webSocket(options);
    }

    public WebSocketClient webSocketBinary(String url) {
        return this.webSocketBinary(url, null, null);
    }

    public WebSocketClient webSocketBinary(String url, Function<byte[], Boolean> handler) {
        return this.webSocketBinary(url, handler, null);
    }

    public WebSocketClient webSocketBinary(String url, Function<byte[], Boolean> handler, Map<String, Object> map) {
        if (handler == null) {
            handler = t -> true;
        }
        WebSocketOptions options = new WebSocketOptions(url, map);
        options.setBinaryHandler(handler);
        return this.context.webSocket(options);
    }

    public void signal(Object result) {
        this.context.signal(result);
    }

    public Object listen(long timeout, ScriptObjectMirror som) {
        if (!som.isFunction()) {
            throw new RuntimeException("not a JS function: " + som);
        }
        return this.context.listen(timeout, () -> Script.evalJsFunctionCall(som, null, this.context));
    }

    public Object listen(long timeout) {
        return this.context.listen(timeout, null);
    }

    private ScriptValue getValue(String name) {
        ScriptValue sv = (ScriptValue)this.context.vars.get(name);
        return sv == null ? ScriptValue.NULL : sv;
    }

    private String getAsString(String name) {
        return this.getValue(name).getAsString();
    }

    public boolean pathMatches(String path) {
        String uri = this.getAsString("requestUri");
        Map<String, String> map = HttpUtils.parseUriPattern(path, uri);
        this.set("pathParams", map);
        return map != null;
    }

    public boolean methodIs(String method) {
        String actual = this.getAsString("requestMethod");
        return actual.equalsIgnoreCase(method);
    }

    public Object paramValue(String name) {
        Map params = (Map)this.getValue("requestParams").getValue();
        if (params == null) {
            return null;
        }
        List list = (List)params.get(name);
        if (list == null) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return list;
    }

    public boolean headerContains(String name, String test) {
        Map headers = (Map)this.getValue("requestHeaders").getValue();
        if (headers == null) {
            return false;
        }
        List list = (List)headers.get(name);
        if (list == null) {
            return false;
        }
        for (String s : list) {
            if (s == null || !s.contains(test)) continue;
            return true;
        }
        return false;
    }

    public boolean typeContains(String test) {
        return this.headerContains("Content-Type", test);
    }

    public boolean acceptContains(String test) {
        return this.headerContains("Accept", test);
    }

    public Object bodyPath(String path) {
        ScriptValue sv = (ScriptValue)this.context.vars.get("request");
        if (sv == null || sv.isNull()) {
            return null;
        }
        if (path.startsWith("/")) {
            return this.xmlPath(sv.getValue(), path);
        }
        return this.jsonPath(sv.getValue(), path);
    }

    public FeatureServer start(String mock) {
        return this.start(Collections.singletonMap("mock", mock));
    }

    public FeatureServer start(Map<String, Object> config) {
        Integer port;
        String mock = (String)config.get("mock");
        if (mock == null) {
            throw new RuntimeException("'mock' is missing: " + config);
        }
        ScriptValue mockSv = FileUtils.readFile(mock, this.context);
        if (!mockSv.isFeature()) {
            throw new RuntimeException("'mock' is not a feature file: " + config + ", " + mockSv);
        }
        Feature feature = mockSv.getValue(Feature.class);
        String certFile = (String)config.get("cert");
        String keyFile = (String)config.get("key");
        Boolean ssl = (Boolean)config.get("ssl");
        if (ssl == null) {
            ssl = false;
        }
        if ((port = (Integer)config.get("port")) == null) {
            port = 0;
        }
        Map arg = (Map)config.get("arg");
        if (certFile != null && keyFile != null) {
            ScriptValue certSv = FileUtils.readFile(certFile, this.context);
            if (!certSv.isStream()) {
                throw new RuntimeException("'cert' is not valid: " + config + ", " + certSv);
            }
            ScriptValue keySv = FileUtils.readFile(keyFile, this.context);
            if (!keySv.isStream()) {
                throw new RuntimeException("'key' is not valid: " + config + ", " + keySv);
            }
            return new FeatureServer(feature, (int)port, (boolean)ssl, certSv.getAsStream(), keySv.getAsStream(), (Map<String, Object>)arg);
        }
        return new FeatureServer(feature, (int)port, (boolean)ssl, (Map<String, Object>)arg);
    }

    public String getEnv() {
        return this.context.featureContext.env;
    }

    public Map<String, Object> getOs() {
        String name = FileUtils.getOsName();
        String type = FileUtils.getOsType(name).toString().toLowerCase();
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("name", name);
        map.put("type", type);
        return map;
    }

    public Properties getProperties() {
        return System.getProperties();
    }

    public void stop() {
        FileUtils.waitForSocket(0);
    }

    public void log(Object ... objects) {
        if (this.context.isPrintEnabled()) {
            this.context.logger.info("{}", new LogWrapper(objects));
        }
    }

    @Override
    public void capturePerfEvent(String name, long startTime, long endTime) {
        PerfEvent event = new PerfEvent(startTime, endTime, name, 200);
        this.context.capturePerfEvent(event);
    }

    static class LogWrapper {
        private final Object[] objects;

        LogWrapper(Object ... objects) {
            this.objects = objects;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Object o : this.objects) {
                ScriptValue sv = new ScriptValue(o);
                sb.append(sv.getAsPrettyString()).append(' ');
            }
            return sb.toString();
        }
    }
}

