/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.cli;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Runner;
import com.intuit.karate.RunnerOptions;
import com.intuit.karate.StringUtils;
import com.intuit.karate.cli.CliExecutionHook;
import com.intuit.karate.debug.DapServer;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Main {
    private static final Pattern COMMAND_NAME = Pattern.compile("--name (.+?\\$)");

    public static void main(String[] args) {
        String command = args.length > 0 ? StringUtils.join(args, ' ') : System.getProperty("sun.java.command");
        System.out.println("command: " + command);
        boolean isIntellij = command.contains("org.jetbrains");
        RunnerOptions ro = RunnerOptions.parseCommandLine(command);
        String targetDir = FileUtils.getBuildDir() + File.separator + "surefire-reports";
        int debugPort = ro.getDebugPort();
        if (debugPort != -1) {
            DapServer server = new DapServer(debugPort);
            server.waitSync();
            return;
        }
        CliExecutionHook hook = new CliExecutionHook(true, targetDir, isIntellij);
        Runner.path(ro.getFeatures()).tags(ro.getTags()).scenarioName(ro.getName()).hook(hook).parallel(ro.getThreads());
    }

    public static StringUtils.Pair parseCommandLine(String commandLine, String cwd) {
        String name;
        Matcher matcher = COMMAND_NAME.matcher(commandLine);
        if (matcher.find()) {
            name = matcher.group(1);
            commandLine = matcher.replaceFirst("");
        } else {
            name = null;
        }
        List<String> args = Arrays.asList(commandLine.split("\\s+"));
        Iterator<String> iterator = args.iterator();
        String path = null;
        while (iterator.hasNext()) {
            String arg = iterator.next();
            if (arg.equals("--plugin") || arg.equals("--glue")) {
                iterator.next();
            }
            if (arg.startsWith("--") || arg.startsWith("com.") || arg.startsWith("cucumber.") || arg.startsWith("org.")) continue;
            path = arg;
        }
        if (path == null) {
            return null;
        }
        if (cwd == null) {
            cwd = new File("").getAbsoluteFile().getPath();
        }
        if ((path = path.substring((cwd = cwd.replace('\\', '/')).length() + 1)).startsWith("src/test/java")) {
            path = "classpath:" + path.substring("src/test/java".length() + 1);
        } else if (path.startsWith("src/test/resources")) {
            path = "classpath:" + path.substring("src/test/resources".length() + 1);
        }
        return StringUtils.pair(path, name);
    }
}

