/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.FileUtils;
import com.intuit.karate.core.ScenarioContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class Resource {
    private final boolean file;
    private final Path path;
    private final int line;
    private final String relativePath;
    private final String packageQualifiedName;
    public static final Resource EMPTY = new Resource(Paths.get("", new String[0]), "", -1);
    private static final Map<String, byte[]> STREAM_CACHE = new HashMap<String, byte[]>();

    public Resource(File file, String relativePath) {
        this(file.toPath(), relativePath, -1);
    }

    public Resource(Path path, String relativePath, int line) {
        this.path = path;
        this.line = line;
        this.file = !path.toUri().getScheme().equals("jar");
        this.relativePath = relativePath == null ? FileUtils.toRelativeClassPath(path, Thread.currentThread().getContextClassLoader()) : relativePath;
        this.packageQualifiedName = FileUtils.toPackageQualifiedName(this.relativePath);
    }

    public Resource(URL url) {
        this(FileUtils.urlToPath(url, null));
    }

    public Resource(Path path) {
        this(path, null, -1);
    }

    public Resource(ScenarioContext sc, String relativePath) {
        String strippedPath = FileUtils.removePrefix(relativePath);
        URL url = sc.getResource(strippedPath);
        this.path = url != null ? FileUtils.urlToPath(url, strippedPath) : new File(strippedPath).toPath();
        this.line = -1;
        this.file = !this.path.toUri().getScheme().equals("jar");
        this.relativePath = relativePath;
        this.packageQualifiedName = FileUtils.toPackageQualifiedName(relativePath);
    }

    public String getFileNameWithoutExtension() {
        return FileUtils.removeFileExtension(this.path.getFileName().toString());
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getPackageQualifiedName() {
        return this.packageQualifiedName;
    }

    public Path getPath() {
        return this.path;
    }

    public int getLine() {
        return this.line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getStream() {
        try {
            if (this.file) {
                return new FileInputStream(this.path.toFile());
            }
            byte[] bytes = STREAM_CACHE.get(this.relativePath);
            if (bytes != null) {
                return new ByteArrayInputStream(bytes);
            }
            Map<String, byte[]> map = STREAM_CACHE;
            synchronized (map) {
                bytes = STREAM_CACHE.get(this.relativePath);
                if (bytes != null) {
                    return new ByteArrayInputStream(bytes);
                }
                InputStream tempStream = Files.newInputStream(this.path, new OpenOption[0]);
                bytes = FileUtils.toBytes(tempStream);
                STREAM_CACHE.put(this.relativePath, bytes);
                return new ByteArrayInputStream(bytes);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getAsString() {
        return FileUtils.toString(this.getStream());
    }

    public String toString() {
        return this.relativePath;
    }
}

