/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.netty;

import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureParser;
import com.intuit.karate.netty.FeatureServerInitializer;
import io.netty.karate.bootstrap.ServerBootstrap;
import io.netty.karate.channel.Channel;
import io.netty.karate.channel.EventLoopGroup;
import io.netty.karate.channel.nio.NioEventLoopGroup;
import io.netty.karate.channel.socket.nio.NioServerSocketChannel;
import io.netty.karate.handler.logging.LogLevel;
import io.netty.karate.handler.logging.LoggingHandler;
import io.netty.karate.handler.ssl.SslContext;
import io.netty.karate.handler.ssl.SslContextBuilder;
import io.netty.karate.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureServer {
    private static final Logger logger = LoggerFactory.getLogger(FeatureServer.class);
    private final Channel channel;
    private final String host;
    private final int port;
    private final boolean ssl;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;

    public static FeatureServer start(File featureFile, int port, boolean ssl, Map<String, Object> arg) {
        return new FeatureServer(featureFile, port, ssl, arg);
    }

    public static FeatureServer start(File featureFile, int port, File certFile, File privateKeyFile, Map<String, Object> arg) {
        return new FeatureServer(featureFile, port, certFile, privateKeyFile, arg);
    }

    public int getPort() {
        return this.port;
    }

    public void waitSync() {
        try {
            this.channel.closeFuture().sync();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        logger.info("stop: shutting down");
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        logger.info("stop: shutdown complete");
    }

    private static SslContext getSslContext() {
        try {
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            return SslContextBuilder.forServer(ssc.certificate(), ssc.privateKey()).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static SslContext getSslContext(File certFile, File keyFile) {
        try {
            return SslContextBuilder.forServer(certFile, keyFile).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static SslContext getSslContext(InputStream certStream, InputStream keyStream) {
        try {
            return SslContextBuilder.forServer(certStream, keyStream).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public FeatureServer(Feature feature, int port, InputStream certStream, InputStream keyStream, Map<String, Object> arg) {
        this(feature, port, FeatureServer.getSslContext(certStream, keyStream), arg);
    }

    private FeatureServer(File file, int port, File certificate, File privateKey, Map<String, Object> arg) {
        this(FeatureServer.toFeature(file), port, FeatureServer.getSslContext(certificate, privateKey), arg);
    }

    public FeatureServer(Feature feature, int port, boolean ssl, Map<String, Object> arg) {
        this(feature, port, ssl ? FeatureServer.getSslContext() : null, arg);
    }

    private FeatureServer(File file, int port, boolean ssl, Map<String, Object> arg) {
        this(FeatureServer.toFeature(file), port, ssl ? FeatureServer.getSslContext() : null, arg);
    }

    private static Feature toFeature(File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            file = new File(file.getAbsolutePath());
        }
        return FeatureParser.parse(file);
    }

    private FeatureServer(Feature feature, int requestedPort, SslContext sslCtx, Map<String, Object> arg) {
        this.ssl = sslCtx != null;
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
        FeatureServerInitializer initializer = new FeatureServerInitializer(sslCtx, feature, arg, () -> this.stop());
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler(new LoggingHandler(this.getClass().getName(), LogLevel.TRACE))).childHandler(initializer);
            this.channel = b.bind(requestedPort).sync().channel();
            InetSocketAddress isa = (InetSocketAddress)this.channel.localAddress();
            this.host = "127.0.0.1";
            this.port = isa.getPort();
            logger.info("server started - {}://{}:{}", new Object[]{this.ssl ? "https" : "http", this.host, this.port});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

