/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.core.Engine;
import com.intuit.karate.http.MultiValuedMap;
import java.util.List;

public class HttpRequest {
    private long startTime;
    private long endTime;
    private double responseTime;
    private String urlBase;
    private String uri;
    private String method;
    private MultiValuedMap headers = new MultiValuedMap();
    private MultiValuedMap params;
    private byte[] body;
    private long startTimeNanos;

    public long getStartTime() {
        return this.startTime;
    }

    public void startTimer() {
        this.startTime = System.currentTimeMillis();
        this.startTimeNanos = System.nanoTime();
    }

    public long getEndTime() {
        return this.endTime;
    }

    public double getResponseTime() {
        return this.responseTime;
    }

    public String getResponseTimeFormatted() {
        return String.format("%.2f", this.responseTime);
    }

    public void stopTimer() {
        this.responseTime = Engine.nanosToMillis(System.nanoTime() - this.startTimeNanos);
        this.endTime = this.startTime + Math.round(this.responseTime);
    }

    public String getUrlBase() {
        return this.urlBase;
    }

    public void setUrlBase(String urlBase) {
        this.urlBase = urlBase;
    }

    public void addHeader(String key, String value) {
        this.headers.add(key, value);
    }

    public void putHeader(String key, List<String> values) {
        this.headers.put(key, values);
    }

    public void setParams(MultiValuedMap params) {
        this.params = params;
    }

    public MultiValuedMap getParams() {
        return this.params;
    }

    public void putParam(String key, List<String> values) {
        if (this.params == null) {
            this.params = new MultiValuedMap();
        }
        this.params.put(key, values);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public MultiValuedMap getHeaders() {
        return this.headers;
    }

    public void setHeaders(MultiValuedMap headers) {
        this.headers = headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }
}

