/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.Config;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.core.ExecutionHook;
import com.intuit.karate.core.PerfEvent;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.exception.KarateException;
import com.intuit.karate.http.Cookie;
import com.intuit.karate.http.HttpRequestBuilder;
import com.intuit.karate.http.HttpResponse;
import com.intuit.karate.http.MultiPartItem;
import com.intuit.karate.http.MultiValuedMap;
import com.jayway.jsonpath.DocumentContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public abstract class HttpClient<T> {
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String KARATE_HTTP_PROPERTIES = "karate-http.properties";
    protected HttpRequestBuilder request;

    public abstract void configure(Config var1, ScenarioContext var2);

    protected abstract T getEntity(List<MultiPartItem> var1, String var2);

    protected abstract T getEntity(MultiValuedMap var1, String var2);

    protected abstract T getEntity(InputStream var1, String var2);

    protected abstract T getEntity(String var1, String var2);

    protected abstract void buildUrl(String var1);

    protected abstract void buildPath(String var1);

    protected abstract void buildParam(String var1, Object ... var2);

    protected abstract void buildHeader(String var1, Object var2, boolean var3);

    protected abstract void buildCookie(Cookie var1);

    protected abstract HttpResponse makeHttpRequest(T var1, ScenarioContext var2);

    protected abstract String getRequestUri();

    private T getEntityInternal(ScriptValue body, String mediaType) {
        if (body.isJsonLike()) {
            if (mediaType == null) {
                mediaType = APPLICATION_JSON;
            }
            DocumentContext json = body.getAsJsonDocument();
            return this.getEntity(json.jsonString(), mediaType);
        }
        if (body.isXml()) {
            Node node = body.getValue(Node.class);
            if (mediaType == null) {
                mediaType = APPLICATION_XML;
            }
            return this.getEntity(XmlUtils.toString(node), mediaType);
        }
        if (body.isStream()) {
            InputStream is = body.getValue(InputStream.class);
            if (mediaType == null) {
                mediaType = APPLICATION_OCTET_STREAM;
            }
            return this.getEntity(is, mediaType);
        }
        if (body.isByteArray()) {
            byte[] bytes = body.getValue(byte[].class);
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            if (mediaType == null) {
                mediaType = APPLICATION_OCTET_STREAM;
            }
            return this.getEntity(is, mediaType);
        }
        if (mediaType == null) {
            mediaType = TEXT_PLAIN;
        }
        return this.getEntity(body.getAsString(), mediaType);
    }

    /*
     * WARNING - void declaration
     */
    private T buildRequestInternal(HttpRequestBuilder request, ScenarioContext context) {
        Config config;
        Map<String, Object> map;
        String method = request.getMethod();
        if (method == null) {
            String msg = "'method' is required to make an http call";
            context.logger.error(msg, new Object[0]);
            throw new RuntimeException(msg);
        }
        method = method.toUpperCase();
        request.setMethod(method);
        this.request = request;
        boolean methodRequiresBody = "POST".equals(method) || "PUT".equals(method) || "PATCH".equals(method) || "DELETE".equals(method);
        String url = request.getUrl();
        if (url == null) {
            String msg = "url not set, please refer to the keyword documentation for 'url'";
            context.logger.error(msg, new Object[0]);
            throw new RuntimeException(msg);
        }
        this.buildUrl(url);
        if (request.getPaths() != null) {
            for (String string : request.getPaths()) {
                this.buildPath(string);
            }
        }
        if (request.getParams() != null) {
            for (Map.Entry entry : request.getParams().entrySet()) {
                this.buildParam((String)entry.getKey(), ((List)entry.getValue()).toArray());
            }
        }
        if (request.getFormFields() != null && !methodRequiresBody) {
            for (Map.Entry entry : request.getFormFields().entrySet()) {
                this.buildParam((String)entry.getKey(), ((List)entry.getValue()).toArray());
            }
        }
        if (request.getHeaders() != null) {
            for (Map.Entry entry : request.getHeaders().entrySet()) {
                for (Object object : (List)entry.getValue()) {
                    this.buildHeader((String)entry.getKey(), object, false);
                }
            }
        }
        if ((map = (config = context.getConfig()).getHeaders().evalAsMap(context)) != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.buildHeader(entry.getKey(), entry.getValue(), true);
            }
        }
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies().values()) {
                this.buildCookie(cookie);
            }
        }
        Map<String, Object> configCookies = config.getCookies().evalAsMap(context);
        for (Cookie cookie : Cookie.toCookies(configCookies)) {
            this.buildCookie(cookie);
        }
        if (methodRequiresBody) {
            void var9_26;
            String string = request.getContentType();
            if (map != null && map.containsKey("Content-Type")) {
                String string2 = (String)map.get("Content-Type");
            }
            if (request.getMultiPartItems() != null) {
                void var9_28;
                if (var9_26 == null) {
                    String string3 = MULTIPART_FORM_DATA;
                }
                return this.getEntity(request.getMultiPartItems(), (String)var9_28);
            }
            if (request.getFormFields() != null) {
                void var9_30;
                if (var9_26 == null) {
                    String string4 = APPLICATION_FORM_URLENCODED;
                }
                return this.getEntity(request.getFormFields(), (String)var9_30);
            }
            ScriptValue body = request.getBody();
            if (body == null || body.isNull()) {
                if ("DELETE".equals(method)) {
                    return null;
                }
                String msg = "request body is required for a " + method + ", please use the 'request' keyword";
                throw new RuntimeException(msg);
            }
            return this.getEntityInternal(body, (String)var9_26);
        }
        return null;
    }

    public HttpResponse invoke(HttpRequestBuilder request, ScenarioContext context) {
        T body = this.buildRequestInternal(request, context);
        String perfEventName = null;
        if (context.executionHooks != null && perfEventName == null) {
            for (ExecutionHook h : context.executionHooks) {
                perfEventName = h.getPerfEventName(request, context);
            }
        }
        try {
            HttpResponse response = this.makeHttpRequest(body, context);
            context.updateConfigCookies(response.getCookies());
            if (perfEventName != null) {
                PerfEvent pe = new PerfEvent(response.getStartTime(), response.getEndTime(), perfEventName, response.getStatus());
                context.capturePerfEvent(pe);
            }
            return response;
        }
        catch (Exception e) {
            long startTime = context.getPrevRequest() == null ? System.currentTimeMillis() : context.getPrevRequest().getStartTime();
            long endTime = System.currentTimeMillis();
            long responseTime = endTime - startTime;
            String message = "http call failed after " + responseTime + " milliseconds for URL: " + this.getRequestUri();
            if (perfEventName != null) {
                PerfEvent pe = new PerfEvent(startTime, endTime, perfEventName, 0);
                context.capturePerfEvent(pe);
            }
            context.logger.error(e.getMessage() + ", " + message, new Object[0]);
            throw new KarateException(message, e);
        }
    }

    public static HttpClient construct(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (HttpClient)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static HttpClient construct(Config config, ScenarioContext context) {
        if (config.getClientInstance() != null) {
            return config.getClientInstance();
        }
        try {
            String className;
            if (config.getClientClass() != null) {
                className = config.getClientClass();
            } else {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(KARATE_HTTP_PROPERTIES);
                if (is == null) {
                    String msg = "karate-http.properties not found";
                    throw new RuntimeException(msg);
                }
                Properties props = new Properties();
                props.load(is);
                className = props.getProperty("client.class");
            }
            HttpClient client = HttpClient.construct(className);
            client.configure(config, context);
            return client;
        }
        catch (Exception e) {
            String msg = "failed to construct class by name: " + e.getMessage() + ", aborting";
            throw new RuntimeException(msg);
        }
    }
}

