/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.formats.selenium;

import com.intuit.karate.formats.selenium.TestBase;
import com.intuit.karate.formats.selenium.TestCase;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestSuite
extends TestBase {
    final int timeOut;
    final boolean parallel;
    final List<TestCase> tests;

    public TestSuite(Map<String, Object> suiteJson, DocumentContext doc) {
        super(suiteJson);
        this.tests = new ArrayList<TestCase>();
        this.timeOut = (Integer)suiteJson.get("timeout");
        this.parallel = (Boolean)suiteJson.get("parallel");
        List testIds = (List)suiteJson.get("tests");
        for (String testId : testIds) {
            String jsonpath = "$.tests[?(@.id == '" + testId.trim() + "')]";
            List testCases = (List)doc.read(jsonpath, new Predicate[0]);
            this.tests.add(new TestCase((Map)testCases.get(0)));
            doc.delete(jsonpath, new Predicate[0]);
        }
    }

    public TestSuite(List<TestCase> tests) {
        super("default-test-suite", "no-name");
        this.timeOut = 0;
        this.tests = tests;
        this.parallel = false;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public List<TestCase> getTests() {
        return this.tests;
    }

    public String convert(String url, HashMap<String, String> variables) {
        StringBuilder sb = new StringBuilder("@ignore\nFeature: ").append(this.getIdentifierName()).append("\n\turl = ").append(url).append("\n\twith parameters\n\t\t").append("session.id").append(", ").append("session.url");
        for (TestCase test : this.tests) {
            sb.append("\n").append(test.convert(url, variables));
        }
        return sb.toString();
    }
}

