/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.formats.postman;

import com.intuit.karate.StringUtils;
import java.util.Map;

public class RequestBuilder {
    private String url;
    private String method;
    private String headers;
    private String body;
    private final String REQUEST_TEMPLATE = "Given url %s%s%sWhen method %s" + System.lineSeparator();

    public RequestBuilder addUrl(String url) {
        if (url == null) {
            throw new IllegalArgumentException("Url is null");
        }
        this.url = "'" + url + "'" + System.lineSeparator();
        return this;
    }

    public RequestBuilder addMethod(String method) {
        if (this.url == null) {
            throw new IllegalArgumentException("Method is null");
        }
        this.method = method + System.lineSeparator();
        return this;
    }

    public RequestBuilder addHeaders(Map<String, String> headers) {
        this.headers = "";
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.headers = this.headers + "And header " + entry.getKey() + " = '" + entry.getValue() + "'" + System.lineSeparator();
        }
        return this;
    }

    public RequestBuilder addBody(String body) {
        this.body = body != null ? "And request " + body + System.lineSeparator() : "";
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public String getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }

    public String build() {
        if ("POST".equals(this.method) && StringUtils.isBlank(this.body)) {
            throw new IllegalArgumentException("Body can't be null if method is POST");
        }
        return String.format(this.REQUEST_TEMPLATE, this.url, this.headers, this.body, this.method);
    }
}

