/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.firefox;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Http;
import com.intuit.karate.Logger;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.WebDriver;
import com.intuit.karate.shell.CommandThread;
import java.util.Map;

public class GeckoWebDriver
extends WebDriver {
    public GeckoWebDriver(DriverOptions options, CommandThread command, Http http, String sessionId, String windowId) {
        super(options, command, http, sessionId, windowId);
    }

    public static GeckoWebDriver start(ScenarioContext context, Map<String, Object> map, Logger logger) {
        DriverOptions options = new DriverOptions(context, map, logger, 4444, "geckodriver");
        options.arg("--port=" + options.port);
        CommandThread command = options.startProcess();
        String urlBase = "http://" + options.host + ":" + options.port;
        Http http = Http.forUrl(options.driverLogger, urlBase);
        String sessionId = http.path("session").post("{ desiredCapabilities: { browserName: 'Firefox' } }").jsonPath("get[0] response..sessionId").asString();
        options.driverLogger.debug("init session id: {}", sessionId);
        http.url(urlBase + "/session/" + sessionId);
        String windowId = http.path("window").get().jsonPath("$.value").asString();
        options.driverLogger.debug("init window id: {}", windowId);
        GeckoWebDriver driver = new GeckoWebDriver(options, command, http, sessionId, windowId);
        driver.activate();
        return driver;
    }

    @Override
    public void activate() {
        if (!this.options.headless) {
            try {
                switch (FileUtils.getOsType()) {
                    case MACOSX: {
                        Runtime.getRuntime().exec(new String[]{"osascript", "-e", "tell app \"Firefox\" to activate"});
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("native window switch failed: {}", e.getMessage());
            }
        }
    }
}

