/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.chrome;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Http;
import com.intuit.karate.Logger;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.driver.DevToolsDriver;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.shell.CommandThread;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Chrome
extends DevToolsDriver {
    public static final String DEFAULT_PATH_MAC = "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome";
    public static final String DEFAULT_PATH_WIN = "C:\\Program Files (x86)\\Google\\Chrome\\Application\\chrome.exe";

    public Chrome(DriverOptions options, CommandThread command, String webSocketUrl) {
        super(options, command, webSocketUrl);
    }

    public static Chrome start(ScenarioContext context, Map<String, Object> map, Logger logger) {
        DriverOptions options = new DriverOptions(context, map, logger, 9222, FileUtils.isOsWindows() ? DEFAULT_PATH_WIN : DEFAULT_PATH_MAC);
        options.arg("--remote-debugging-port=" + options.port);
        options.arg("--no-first-run");
        options.arg("--user-data-dir=" + options.workingDirPath);
        options.arg("--disable-popup-blocking");
        if (options.headless) {
            options.arg("--headless");
        }
        CommandThread command = options.startProcess();
        Http http = Http.forUrl(options.driverLogger, "http://" + options.host + ":" + options.port);
        String webSocketUrl = http.path("json").get().jsonPath("get[0] $[?(@.type=='page')].webSocketDebuggerUrl").asString();
        Chrome chrome = new Chrome(options, command, webSocketUrl);
        chrome.activate();
        chrome.enablePageEvents();
        if (!options.headless) {
            chrome.initWindowIdAndState();
        }
        return chrome;
    }

    public static Chrome start(String chromeExecutablePath, boolean headless) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("executable", chromeExecutablePath);
        options.put("headless", headless);
        return Chrome.start(null, options, null);
    }

    public static Chrome start(Map<String, Object> options) {
        if (options == null) {
            options = new HashMap<String, Object>();
        }
        return Chrome.start(null, options, null);
    }

    public static Chrome start() {
        return Chrome.start(null);
    }

    public static Chrome startHeadless() {
        return Chrome.start(Collections.singletonMap("headless", true));
    }

    @Override
    public List<String> getWindowHandles() {
        return null;
    }
}

