/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.ScriptValue;
import com.intuit.karate.driver.DevToolsDriver;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class DevToolsMessage {
    private final DevToolsDriver driver;
    private Integer id;
    private final String method;
    private Map<String, Object> params;
    private ScriptValue result;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isMethod(String method) {
        return method.equals(this.method);
    }

    public String getFrameUrl() {
        if (this.params == null) {
            return null;
        }
        Map frame = (Map)this.params.get("frame");
        if (frame == null) {
            return null;
        }
        return (String)frame.get("url");
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public ScriptValue getResult() {
        return this.result;
    }

    public void setResult(ScriptValue result) {
        this.result = result;
    }

    private static Map<String, Object> toMap(List<Map<String, Object>> list) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (Map<String, Object> map : list) {
            String key = (String)map.get("name");
            Map valMap = (Map)map.get("value");
            res.put(key, valMap == null ? null : (Object)valMap.get("value"));
        }
        return res;
    }

    public boolean isResultError() {
        if (this.result == null || !this.result.isMapLike()) {
            return false;
        }
        String error = (String)this.result.getAsMap().get("subtype");
        return "error".equals(error);
    }

    public ScriptValue getResult(String key) {
        if (this.result == null || !this.result.isMapLike()) {
            return null;
        }
        return new ScriptValue(this.result.getAsMap().get(key));
    }

    public ScriptValue getParam(String key) {
        if (this.params == null) {
            return ScriptValue.NULL;
        }
        return new ScriptValue(this.params.get(key));
    }

    public DevToolsMessage(DevToolsDriver driver, String method) {
        this.driver = driver;
        this.id = driver.getNextId();
        this.method = method;
    }

    public DevToolsMessage(DevToolsDriver driver, Map<String, Object> map) {
        this.driver = driver;
        this.id = (Integer)map.get("id");
        this.method = (String)map.get("method");
        this.params = (Map)map.get("params");
        Map temp = (Map)map.get("result");
        if (temp != null && temp.containsKey("result")) {
            Object inner = temp.get("result");
            if (inner instanceof List) {
                this.result = new ScriptValue(DevToolsMessage.toMap((List)inner));
            } else {
                Map innerMap = (Map)inner;
                String type = (String)innerMap.get("type");
                String subtype = (String)innerMap.get("subtype");
                this.result = "object".equals(type) || "error".equals(subtype) ? new ScriptValue(innerMap) : new ScriptValue(innerMap.get("value"));
            }
        } else {
            this.result = new ScriptValue(temp);
        }
    }

    public DevToolsMessage param(String key, Object value) {
        if (this.params == null) {
            this.params = new LinkedHashMap<String, Object>();
        }
        this.params.put(key, value);
        return this;
    }

    public DevToolsMessage params(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("id", this.id);
        map.put("method", this.method);
        if (this.params != null) {
            map.put("params", this.params);
        }
        if (this.result != null) {
            map.put("result", this.result);
        }
        return map;
    }

    public DevToolsMessage send() {
        return this.send(null);
    }

    public DevToolsMessage send(Predicate<DevToolsMessage> condition) {
        return this.driver.sendAndWait(this, condition);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[id: ").append(this.id);
        if (this.method != null) {
            sb.append(", method: ").append(this.method);
        }
        if (this.params != null) {
            sb.append(", params: ").append(this.params);
        }
        if (this.result != null) {
            sb.append(", result: ").append(this.result);
        }
        sb.append("]");
        return sb.toString();
    }
}

