/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.Logger;
import com.intuit.karate.core.ExecutionContext;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureContext;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.core.ScenarioExecutionUnit;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.Tags;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class FeatureExecutionUnit
implements Runnable {
    public final ExecutionContext exec;
    private final boolean parallelScenarios;
    private CountDownLatch latch;
    private List<ScenarioExecutionUnit> units;
    private List<ScenarioResult> results;
    private Runnable next;
    private ScenarioContext lastContextExecuted;

    public FeatureExecutionUnit(ExecutionContext exec) {
        this.exec = exec;
        this.parallelScenarios = exec.scenarioExecutor != null;
    }

    public List<ScenarioExecutionUnit> getScenarioExecutionUnits() {
        return this.units;
    }

    public void init(Logger logger) {
        this.units = this.exec.featureContext.feature.getScenarioExecutionUnits(this.exec, logger);
        int count = this.units.size();
        this.results = new ArrayList<ScenarioResult>(count);
        this.latch = new CountDownLatch(count);
    }

    public void setNext(Runnable next) {
        this.next = next;
    }

    @Override
    public void run() {
        if (this.units == null) {
            this.init(null);
        }
        for (ScenarioExecutionUnit unit : this.units) {
            if (this.isSelected(unit) && this.run(unit)) continue;
            this.latch.countDown();
        }
        try {
            this.latch.await();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.stop();
        if (this.next != null) {
            this.next.run();
        }
    }

    public void stop() {
        for (ScenarioResult sr : this.results) {
            this.exec.result.addResult(sr);
        }
        if (this.lastContextExecuted != null) {
            this.exec.result.setResultVars(this.lastContextExecuted.vars);
            this.lastContextExecuted.invokeAfterHookIfConfigured(true);
        }
    }

    public boolean isSelected(ScenarioExecutionUnit unit) {
        return FeatureExecutionUnit.isSelected(this.exec.featureContext, unit.scenario, unit.logger);
    }

    public static boolean isSelected(FeatureContext fc, Scenario scenario, Logger logger) {
        Feature feature = fc.feature;
        int callLine = feature.getCallLine();
        if (callLine != -1) {
            int sectionLine = scenario.getSection().getLine();
            int scenarioLine = scenario.getLine();
            if (callLine == sectionLine || callLine == scenarioLine) {
                logger.info("found scenario at line: {}", callLine);
                return true;
            }
            logger.trace("skipping scenario at line: {}, needed: {}", scenario.getLine(), callLine);
            return false;
        }
        String callName = feature.getCallName();
        if (callName != null) {
            if (scenario.getName().matches(callName)) {
                logger.info("found scenario at line: {} - {}", scenario.getLine(), callName);
                return true;
            }
            logger.trace("skipping scenario at line: {} - {}, needed: {}", scenario.getLine(), scenario.getName(), callName);
            return false;
        }
        Tags tags = scenario.getTagsEffective();
        String callTag = scenario.getFeature().getCallTag();
        if (callTag != null) {
            if (tags.contains(callTag)) {
                logger.info("scenario called at line: {} by tag: {}", scenario.getLine(), callTag);
                return true;
            }
            logger.trace("skipping scenario at line: {} with call by tag effective: {}", scenario.getLine(), callTag);
            return false;
        }
        if (tags.evaluate(fc.tagSelector)) {
            logger.trace("matched scenario at line: {} with tags effective: {}", scenario.getLine(), tags.getTags());
            return true;
        }
        logger.trace("skipping scenario at line: {} with tags effective: {}", scenario.getLine(), tags.getTags());
        return false;
    }

    public boolean run(ScenarioExecutionUnit unit) {
        boolean sequential;
        this.results.add(unit.result);
        if (unit.result.isFailed()) {
            return false;
        }
        Tags tags = unit.scenario.getTagsEffective();
        unit.setNext(() -> {
            this.latch.countDown();
            this.lastContextExecuted = unit.getContext();
        });
        boolean bl = sequential = !this.parallelScenarios || tags.valuesFor("parallel").isAnyOf("false");
        if (sequential) {
            unit.run();
        } else {
            this.exec.scenarioExecutor.submit(unit);
        }
        return true;
    }
}

