/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.CallContext;
import com.intuit.karate.FileUtils;
import com.intuit.karate.Resource;
import com.intuit.karate.Results;
import com.intuit.karate.RunnerOptions;
import com.intuit.karate.core.Engine;
import com.intuit.karate.core.ExecutionContext;
import com.intuit.karate.core.ExecutionHook;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureContext;
import com.intuit.karate.core.FeatureExecutionUnit;
import com.intuit.karate.core.FeatureParser;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.Tags;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Runner {
    private static final Logger logger = LoggerFactory.getLogger(Runner.class);

    public static Results parallel(Class<?> clazz, int threadCount) {
        return Runner.parallel(clazz, threadCount, null);
    }

    public static Results parallel(Class<?> clazz, int threadCount, String reportDir) {
        RunnerOptions options = RunnerOptions.fromAnnotationAndSystemProperties(clazz);
        return Runner.parallel(options.getTags(), options.getFeatures(), options.getName(), null, threadCount, reportDir);
    }

    public static Results parallel(List<String> tags, List<String> paths, int threadCount, String reportDir) {
        return Runner.parallel(tags, paths, null, null, threadCount, reportDir);
    }

    public static Results parallel(List<String> tags, List<String> paths, String scenarioName, Collection<ExecutionHook> hooks, int threadCount, String reportDir) {
        String tagSelector = tags == null ? null : Tags.fromKarateOptionsTags(tags);
        List<Resource> files = FileUtils.scanForFeatureFiles(paths, Thread.currentThread().getContextClassLoader());
        return Runner.parallel(tagSelector, files, scenarioName, hooks, threadCount, reportDir);
    }

    public static Results parallel(String tagSelector, List<Resource> resources, int threadCount, String reportDir) {
        return Runner.parallel(tagSelector, resources, null, null, threadCount, reportDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Results parallel(String tagSelector, List<Resource> resources, String scenarioName, Collection<ExecutionHook> hooks, int threadCount, String reportDir) {
        if (threadCount < 1) {
            threadCount = 1;
        }
        if (reportDir == null) {
            reportDir = FileUtils.getBuildDir() + File.separator + "surefire-reports";
            new File(reportDir).mkdirs();
        }
        String finalReportDir = reportDir;
        Results results = Results.startTimer(threadCount);
        ExecutorService featureExecutor = Executors.newFixedThreadPool(threadCount);
        ExecutorService scenarioExecutor = Executors.newWorkStealingPool(threadCount);
        int executedFeatureCount = 0;
        try {
            int count = resources.size();
            CountDownLatch latch = new CountDownLatch(count);
            ArrayList<FeatureResult> featureResults = new ArrayList<FeatureResult>(count);
            for (int i = 0; i < count; ++i) {
                Resource resource = resources.get(i);
                int index = i + 1;
                Feature feature = FeatureParser.parse(resource);
                feature.setCallName(scenarioName);
                feature.setCallLine(resource.getLine());
                FeatureContext featureContext = new FeatureContext(null, feature, tagSelector);
                CallContext callContext = CallContext.forAsync(feature, hooks, null, false);
                ExecutionContext execContext = new ExecutionContext(results.getStartTime(), featureContext, callContext, reportDir, r -> featureExecutor.submit((Runnable)r), scenarioExecutor);
                featureResults.add(execContext.result);
                FeatureExecutionUnit unit = new FeatureExecutionUnit(execContext);
                unit.setNext(() -> {
                    FeatureResult result = execContext.result;
                    if (result.getScenarioCount() > 0) {
                        File file = Engine.saveResultJson(finalReportDir, result, null);
                        if (result.getScenarioCount() < 500) {
                            Engine.saveResultXml(finalReportDir, result, null);
                        }
                        String status = result.isFailed() ? "fail" : "pass";
                        logger.info("<<{}>> feature {} of {}: {}", new Object[]{status, index, count, feature.getRelativePath()});
                        result.printStats(file.getPath());
                    } else {
                        results.addToSkipCount(1);
                        if (logger.isTraceEnabled()) {
                            logger.trace("<<skip>> feature {} of {}: {}", new Object[]{index, count, feature.getRelativePath()});
                        }
                    }
                    latch.countDown();
                });
                featureExecutor.submit(unit);
            }
            latch.await();
            results.stopTimer();
            for (FeatureResult result : featureResults) {
                int scenarioCount = result.getScenarioCount();
                results.addToScenarioCount(scenarioCount);
                if (scenarioCount != 0) {
                    ++executedFeatureCount;
                }
                results.addToFailCount(result.getFailedCount());
                results.addToTimeTaken(result.getDurationMillis());
                if (result.isFailed()) {
                    results.addToFailedList(result.getPackageQualifiedName(), result.getErrorMessages());
                }
                results.addScenarioResults(result.getScenarioResults());
            }
        }
        catch (Exception e) {
            logger.error("karate parallel runner failed: ", (Object)e.getMessage());
            results.setFailureReason(e);
        }
        finally {
            featureExecutor.shutdownNow();
            scenarioExecutor.shutdownNow();
        }
        results.setFeatureCount(executedFeatureCount);
        results.printStats(threadCount);
        Engine.saveStatsJson(reportDir, results, null);
        Engine.saveTimelineHtml(reportDir, results, null);
        results.setReportDir(reportDir);
        return results;
    }

    public static Map<String, Object> runFeature(Feature feature, Map<String, Object> vars, boolean evalKarateConfig) {
        CallContext callContext = new CallContext(vars, evalKarateConfig, new ExecutionHook[0]);
        FeatureResult result = Engine.executeFeatureSync(null, feature, null, callContext);
        if (result.isFailed()) {
            throw result.getErrorsCombined();
        }
        return result.getResultAsPrimitiveMap();
    }

    public static Map<String, Object> runFeature(File file, Map<String, Object> vars, boolean evalKarateConfig) {
        Feature feature = FeatureParser.parse(file);
        return Runner.runFeature(feature, vars, evalKarateConfig);
    }

    public static Map<String, Object> runFeature(Class relativeTo, String path, Map<String, Object> vars, boolean evalKarateConfig) {
        File file = FileUtils.getFileRelativeTo(relativeTo, path);
        return Runner.runFeature(file, vars, evalKarateConfig);
    }

    public static Map<String, Object> runFeature(String path, Map<String, Object> vars, boolean evalKarateConfig) {
        Feature feature = FeatureParser.parse(path);
        return Runner.runFeature(feature, vars, evalKarateConfig);
    }

    public static void callAsync(String path, Map<String, Object> arg, ExecutionHook hook, Consumer<Runnable> system, Runnable next) {
        Feature feature = FileUtils.parseFeatureAndCallTag(path);
        FeatureContext featureContext = new FeatureContext(null, feature, null);
        CallContext callContext = CallContext.forAsync(feature, Collections.singletonList(hook), arg, true);
        ExecutionContext executionContext = new ExecutionContext(System.currentTimeMillis(), featureContext, callContext, null, system, null);
        FeatureExecutionUnit exec = new FeatureExecutionUnit(executionContext);
        exec.setNext(next);
        system.accept(exec);
    }
}

