/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.AssertionResult;
import com.intuit.karate.AssignType;
import com.intuit.karate.CallContext;
import com.intuit.karate.Http;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.Logger;
import com.intuit.karate.Script;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.ScriptValueMap;
import com.intuit.karate.core.FeatureContext;
import com.intuit.karate.core.MatchType;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.exception.KarateException;
import com.intuit.karate.http.DummyHttpClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONValue;

public class Match {
    protected final ScenarioContext context;
    private ScriptValue prevValue = ScriptValue.NULL;

    public static Match withHttp(Logger logger) {
        if (logger == null) {
            logger = new Logger();
        }
        return new Match(logger, null);
    }

    public Match(String exp) {
        this(null, exp);
    }

    public Match() {
        this(null, null);
    }

    public static Match init(Object o) {
        Match match = new Match(null, null);
        match.prevValue = new ScriptValue(o);
        return match;
    }

    private Match(Logger logger, String exp) {
        FeatureContext featureContext = FeatureContext.forEnv();
        String httpClass = logger == null ? DummyHttpClient.class.getName() : null;
        CallContext callContext = new CallContext(null, null, 0, null, -1, null, false, false, httpClass, null, false);
        this.context = new ScenarioContext(featureContext, callContext, null, logger);
        if (exp != null) {
            this.prevValue = Script.evalKarateExpression(exp, this.context);
            if (this.prevValue.isMapLike()) {
                this.putAll(this.prevValue.evalAsMap(this.context));
            }
        }
    }

    private void handleFailure(AssertionResult ar) {
        if (!ar.pass) {
            this.context.logger.error("{}", ar);
            throw new KarateException(ar.message);
        }
    }

    public Match text(String name, String exp) {
        this.prevValue = Script.assign(AssignType.TEXT, name, exp, this.context, false);
        return this;
    }

    public Match putAll(Map<String, Object> map) {
        if (map != null) {
            map.forEach((k, v) -> this.context.vars.put((String)k, v));
        }
        return this;
    }

    public Match eval(String exp) {
        this.prevValue = Script.evalKarateExpression(exp, this.context);
        return this;
    }

    public Match def(String name, String exp) {
        this.prevValue = Script.assign(AssignType.AUTO, name, exp, this.context, false);
        return this;
    }

    public Match def(String name, Object o) {
        this.prevValue = this.context.vars.put(name, o);
        return this;
    }

    public Match jsonPath(String exp) {
        this.prevValue = Script.evalKarateExpression(exp, this.context);
        return this;
    }

    public ScriptValue value() {
        return this.prevValue;
    }

    public boolean statusIs(Integer expected) {
        this.prevValue = Script.evalKarateExpression("responseStatus", this.context);
        return expected.equals(this.prevValue.getValue());
    }

    public boolean isBooleanTrue() {
        return this.prevValue.isBooleanTrue();
    }

    public String asString() {
        return this.prevValue.getAsString();
    }

    public <T> T asType(Class<T> clazz) {
        return this.prevValue.getValue(clazz);
    }

    public Map<String, Object> asMap(String exp) {
        this.eval(exp);
        return this.prevValue.getAsMap();
    }

    public Map<String, Object> asMap() {
        return this.prevValue == null ? null : this.prevValue.getAsMap();
    }

    public String asJson() {
        return JsonUtils.toJson(this.prevValue.getAsMap());
    }

    public Map<String, Object> allAsMap() {
        return this.context.vars.toPrimitiveMap();
    }

    public ScriptValueMap vars() {
        return this.context.vars;
    }

    public String allAsJson() {
        return JsonUtils.toJson(this.context.vars.toPrimitiveMap());
    }

    public List<Object> asList(String exp) {
        this.eval(exp);
        return this.prevValue.getAsList();
    }

    public List asList() {
        return this.prevValue.getAsList();
    }

    public Match equalsText(String exp) {
        return this.matchText(exp, MatchType.EQUALS);
    }

    private static String quote(String exp) {
        return exp == null ? "null" : "\"" + JSONValue.escape((String)exp) + "\"";
    }

    public Match matchText(String exp, MatchType matchType) {
        return this.match(Match.quote(exp), matchType);
    }

    private Match match(String exp, MatchType matchType) {
        AssertionResult result = Script.matchScriptValue(matchType, this.prevValue, "$", exp, this.context);
        this.handleFailure(result);
        return this;
    }

    public Match equals(String exp) {
        return this.match(exp, MatchType.EQUALS);
    }

    public Match contains(String exp) {
        return this.match(exp, MatchType.CONTAINS);
    }

    public Match equalsObject(Object o) {
        return this.match(o, MatchType.EQUALS);
    }

    public Match contains(Object o) {
        return this.match(o, MatchType.CONTAINS);
    }

    private Match match(Object o, MatchType matchType) {
        Script.matchNestedObject('.', "$", matchType, this.prevValue.getValue(), null, null, o, this.context);
        return this;
    }

    public Http http() {
        return new Http(this);
    }

    public Match url(String url) {
        this.context.url(Match.quote(url));
        return this;
    }

    public Match path(String ... paths) {
        ArrayList<String> list = new ArrayList<String>(paths.length);
        for (String p : paths) {
            list.add(Match.quote(p));
        }
        this.context.path(list);
        return this;
    }

    public Match httpGet() {
        this.context.method("get");
        return this;
    }

    public Match httpPost(ScriptValue body) {
        this.context.request(body);
        this.context.method("post");
        return this;
    }

    public Match httpPost(Object body) {
        this.context.request(new ScriptValue(body).getAsString());
        this.context.method("post");
        return this;
    }

    public Match httpDelete() {
        this.context.method("delete");
        return this;
    }

    public Match response() {
        this.jsonPath("response");
        return this;
    }

    public static Match equals(Object o, String exp) {
        return Match.match(o, exp, MatchType.EQUALS);
    }

    public static Match equalsText(Object o, String exp) {
        return Match.matchText(o, exp, MatchType.EQUALS);
    }

    public static Match contains(Object o, String exp) {
        return Match.match(o, exp, MatchType.CONTAINS);
    }

    public static Match containsText(Object o, String exp) {
        return Match.matchText(o, exp, MatchType.CONTAINS);
    }

    private static Match match(Object o, String exp, MatchType matchType) {
        Match m = new Match();
        m.prevValue = new ScriptValue(o);
        return m.match(exp, matchType);
    }

    private static Match matchText(Object o, String exp, MatchType matchType) {
        Match m = new Match();
        m.prevValue = new ScriptValue(o);
        return m.matchText(exp, matchType);
    }

    public Match config(String key, String value) {
        this.context.configure(key, value);
        return this;
    }
}

