/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.LogAppender;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class Logger {
    private static final String DEFAULT_PACKAGE = "com.intuit.karate";
    private final org.slf4j.Logger LOGGER;
    private final DateFormat dateFormatter = new SimpleDateFormat("HH:mm:ss.SSS");
    private LogAppender logAppender;

    public void setLogAppender(LogAppender logAppender) {
        this.logAppender = logAppender;
    }

    public LogAppender getLogAppender() {
        return this.logAppender;
    }

    public boolean isTraceEnabled() {
        return this.LOGGER.isTraceEnabled();
    }

    public Logger(Class clazz) {
        this.LOGGER = LoggerFactory.getLogger((Class)clazz);
    }

    public Logger(String name) {
        this.LOGGER = LoggerFactory.getLogger((String)name);
    }

    public Logger() {
        this.LOGGER = LoggerFactory.getLogger((String)DEFAULT_PACKAGE);
    }

    public void trace(String format, Object ... arguments) {
        if (this.LOGGER.isTraceEnabled()) {
            this.LOGGER.trace(format, arguments);
            this.formatAndAppend(format, arguments);
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug(format, arguments);
            this.formatAndAppend(format, arguments);
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.LOGGER.isInfoEnabled()) {
            this.LOGGER.info(format, arguments);
            this.formatAndAppend(format, arguments);
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.LOGGER.isWarnEnabled()) {
            this.LOGGER.warn(format, arguments);
            this.formatAndAppend(format, arguments);
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.LOGGER.isErrorEnabled()) {
            this.LOGGER.error(format, arguments);
            this.formatAndAppend(format, arguments);
        }
    }

    private String getFormattedDate() {
        Date now = new Date();
        String dateText = this.dateFormatter.format(now);
        return dateText;
    }

    private void formatAndAppend(String format, Object ... arguments) {
        if (this.logAppender == null) {
            return;
        }
        FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        this.append(tp.getMessage());
    }

    private void append(String message) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getFormattedDate()).append(' ').append(message).append('\n');
        this.logAppender.append(buf.toString());
    }
}

