/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Resource;
import com.intuit.karate.RunnerOptions;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Engine;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureParser;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.Tags;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IdeUtils {
    private static final Pattern COMMAND_NAME = Pattern.compile("--name (.+?\\$)");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSZ");
    private static final String TEAMCITY_PREFIX = "##teamcity";
    private static final String TEMPLATE_TEST_STARTED = "##teamcity[testStarted timestamp = '%s' locationHint = '%s' captureStandardOutput = 'true' name = '%s']";
    private static final String TEMPLATE_TEST_FAILED = "##teamcity[testFailed timestamp = '%s' details = '%s' message = '%s' name = '%s' %s]";
    private static final String TEMPLATE_SCENARIO_FAILED = "##teamcity[customProgressStatus timestamp='%s' type='testFailed']";
    private static final String TEMPLATE_TEST_PENDING = "##teamcity[testIgnored name = '%s' message = 'Skipped step' timestamp = '%s']";
    private static final String TEMPLATE_TEST_FINISHED = "##teamcity[testFinished timestamp = '%s' duration = '%s' name = '%s']";
    private static final String TEMPLATE_ENTER_THE_MATRIX = "##teamcity[enteredTheMatrix timestamp = '%s']";
    private static final String TEMPLATE_TEST_SUITE_STARTED = "##teamcity[testSuiteStarted timestamp = '%s' locationHint = 'file://%s' name = '%s']";
    private static final String TEMPLATE_TEST_SUITE_FINISHED = "##teamcity[testSuiteFinished timestamp = '%s' name = '%s']";
    private static final String TEMPLATE_SCENARIO_COUNTING_STARTED = "##teamcity[customProgressStatus testsCategory = 'Scenarios' count = '%s' timestamp = '%s']";
    private static final String TEMPLATE_SCENARIO_COUNTING_FINISHED = "##teamcity[customProgressStatus testsCategory = '' count = '0' timestamp = '%s']";
    private static final String TEMPLATE_SCENARIO_STARTED = "##teamcity[customProgressStatus type = 'testStarted' timestamp = '%s']";
    private static final String TEMPLATE_SCENARIO_FINISHED = "##teamcity[customProgressStatus type = 'testFinished' timestamp = '%s']";

    public static void exec(String[] args) {
        String command = System.getProperty("sun.java.command");
        System.out.println("command: " + command);
        boolean isIntellij = command.contains("org.jetbrains");
        RunnerOptions options = RunnerOptions.parseCommandLine(command);
        String name = options.getName();
        List<String> features = options.getFeatures();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        List<Resource> resources = FileUtils.scanForFeatureFiles(features, cl);
        String tagSelector = Tags.fromKarateOptionsTags(options.getTags());
        for (Resource resource : resources) {
            Feature feature = FeatureParser.parse(resource);
            feature.setCallName(name);
            feature.setCallLine(resource.getLine());
            FeatureResult result = Engine.executeFeatureSync(null, feature, tagSelector, null);
            if (isIntellij) {
                IdeUtils.log(result);
            }
            Engine.saveResultHtml(FileUtils.getBuildDir() + File.separator + "surefire-reports", result, null);
        }
    }

    public static StringUtils.Pair parseCommandLine(String commandLine, String cwd) {
        String name;
        Matcher matcher = COMMAND_NAME.matcher(commandLine);
        if (matcher.find()) {
            name = matcher.group(1);
            commandLine = matcher.replaceFirst("");
        } else {
            name = null;
        }
        List<String> args = Arrays.asList(commandLine.split("\\s+"));
        Iterator<String> iterator = args.iterator();
        String path = null;
        while (iterator.hasNext()) {
            String arg = iterator.next();
            if (arg.equals("--plugin") || arg.equals("--glue")) {
                iterator.next();
            }
            if (arg.startsWith("--") || arg.startsWith("com.") || arg.startsWith("cucumber.") || arg.startsWith("org.")) continue;
            path = arg;
        }
        if (path == null) {
            return null;
        }
        if (cwd == null) {
            cwd = new File("").getAbsoluteFile().getPath();
        }
        if ((path = path.substring((cwd = cwd.replace('\\', '/')).length() + 1)).startsWith("src/test/java")) {
            path = "classpath:" + path.substring("src/test/java".length() + 1);
        } else if (path.startsWith("src/test/resources")) {
            path = "classpath:" + path.substring("src/test/resources".length() + 1);
        }
        return StringUtils.pair(path, name);
    }

    private static String escape(String source) {
        if (source == null) {
            return "";
        }
        return source.replace("|", "||").replace("\n", "|n").replace("\r", "|r").replace("'", "|'").replace("[", "|[").replace("]", "|]");
    }

    private static String getCurrentTime() {
        return DATE_FORMAT.format(new Date());
    }

    private static void log(String s) {
        System.out.println(s);
    }

    private static StringUtils.Pair details(Throwable error) {
        String fullMessage = error.getMessage().replace("\r", "").replace("\t", "  ");
        String[] messageInfo = fullMessage.split("\n", 2);
        if (messageInfo.length == 2) {
            return StringUtils.pair(messageInfo[0].trim(), messageInfo[1].trim());
        }
        return StringUtils.pair(fullMessage, "");
    }

    private static void log(FeatureResult fr) {
        Feature f = fr.getFeature();
        String uri = fr.getDisplayUri();
        String featureName = "Feature: " + IdeUtils.escape(f.getName());
        IdeUtils.log(String.format(TEMPLATE_ENTER_THE_MATRIX, IdeUtils.getCurrentTime()));
        IdeUtils.log(String.format(TEMPLATE_SCENARIO_COUNTING_STARTED, 0, IdeUtils.getCurrentTime()));
        IdeUtils.log(String.format(TEMPLATE_TEST_SUITE_STARTED, IdeUtils.getCurrentTime(), uri + ":" + f.getLine(), featureName));
        for (ScenarioResult sr : fr.getScenarioResults()) {
            Scenario s = sr.getScenario();
            String scenarioName = s.getKeyword() + ": " + IdeUtils.escape(s.getName());
            IdeUtils.log(String.format(TEMPLATE_SCENARIO_STARTED, IdeUtils.getCurrentTime()));
            IdeUtils.log(String.format(TEMPLATE_TEST_STARTED, IdeUtils.getCurrentTime(), uri + ":" + s.getLine(), scenarioName));
            if (sr.isFailed()) {
                StringUtils.Pair error = IdeUtils.details(sr.getError());
                IdeUtils.log(String.format(TEMPLATE_TEST_FAILED, IdeUtils.getCurrentTime(), IdeUtils.escape(error.right), IdeUtils.escape(error.left), scenarioName, ""));
            }
            IdeUtils.log(String.format(TEMPLATE_TEST_FINISHED, IdeUtils.getCurrentTime(), sr.getDurationNanos() / 1000000L, scenarioName));
        }
        IdeUtils.log(String.format(TEMPLATE_TEST_SUITE_FINISHED, IdeUtils.getCurrentTime(), featureName));
        IdeUtils.log(String.format(TEMPLATE_SCENARIO_COUNTING_FINISHED, IdeUtils.getCurrentTime()));
    }
}

