/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.JsonUtils;
import com.intuit.karate.Resource;
import com.intuit.karate.Script;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.StringUtils;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureParser;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.exception.KarateFileNotFoundException;
import com.jayway.jsonpath.DocumentContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    public static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final String CLASSPATH = "classpath";
    public static final String CLASSPATH_COLON = "classpath:";
    private static final String DOT_FEATURE = ".feature";
    public static final String THIS_COLON = "this:";
    public static final String FILE_COLON = "file:";
    public static final String SRC_TEST_JAVA = "src/test/java";
    public static final String SRC_TEST_RESOURCES = "src/test/resources";
    private static final String UNKNOWN = "(unknown)";
    private static final Map<URI, FileSystem> FILE_SYSTEM_CACHE = new HashMap<URI, FileSystem>();

    private FileUtils() {
    }

    public static final boolean isClassPath(String text) {
        return text.startsWith(CLASSPATH_COLON);
    }

    public static final boolean isFilePath(String text) {
        return text.startsWith(FILE_COLON);
    }

    public static final boolean isThisPath(String text) {
        return text.startsWith(THIS_COLON);
    }

    public static final boolean isJsonFile(String text) {
        return text.endsWith(".json");
    }

    public static final boolean isJavaScriptFile(String text) {
        return text.endsWith(".js");
    }

    public static final boolean isYamlFile(String text) {
        return text.endsWith(".yaml") || text.endsWith(".yml");
    }

    public static final boolean isXmlFile(String text) {
        return text.endsWith(".xml");
    }

    public static final boolean isTextFile(String text) {
        return text.endsWith(".txt");
    }

    public static final boolean isCsvFile(String text) {
        return text.endsWith(".csv");
    }

    public static final boolean isGraphQlFile(String text) {
        return text.endsWith(".graphql") || text.endsWith(".gql");
    }

    public static final boolean isFeatureFile(String text) {
        return text.endsWith(DOT_FEATURE);
    }

    public static ScriptValue readFile(String text, ScenarioContext context) {
        StringUtils.Pair pair = FileUtils.parsePathAndTags(text);
        text = pair.left;
        if (FileUtils.isJsonFile(text) || FileUtils.isXmlFile(text) || FileUtils.isJavaScriptFile(text)) {
            String contents = FileUtils.readFileAsString(text, context);
            contents = StringUtils.fixJavaScriptFunction(contents);
            ScriptValue temp = Script.evalKarateExpression(contents, context);
            return new ScriptValue(temp.getValue(), text);
        }
        if (FileUtils.isTextFile(text) || FileUtils.isGraphQlFile(text)) {
            String contents = FileUtils.readFileAsString(text, context);
            return new ScriptValue(contents, text);
        }
        if (FileUtils.isFeatureFile(text)) {
            Resource fr = FileUtils.toResource(text, context);
            Feature feature = FeatureParser.parse(fr);
            feature.setCallTag(pair.right);
            return new ScriptValue(feature, text);
        }
        if (FileUtils.isCsvFile(text)) {
            String contents = FileUtils.readFileAsString(text, context);
            DocumentContext doc = JsonUtils.fromCsv(contents);
            return new ScriptValue(doc, text);
        }
        if (FileUtils.isYamlFile(text)) {
            String contents = FileUtils.readFileAsString(text, context);
            DocumentContext doc = JsonUtils.fromYaml(contents);
            return new ScriptValue(doc, text);
        }
        InputStream is = FileUtils.getFileStream(text, context);
        return new ScriptValue(is, text);
    }

    public static String removePrefix(String text) {
        if (text == null) {
            return null;
        }
        int pos = text.indexOf(58);
        return pos == -1 ? text : text.substring(pos + 1);
    }

    private static StringUtils.Pair parsePathAndTags(String text) {
        int pos = text.indexOf(64);
        if (pos == -1) {
            text = StringUtils.trimToEmpty(text);
            return new StringUtils.Pair(text, null);
        }
        String left = StringUtils.trimToEmpty(text.substring(0, pos));
        String right = StringUtils.trimToEmpty(text.substring(pos));
        return new StringUtils.Pair(left, right);
    }

    public static Feature parseFeatureAndCallTag(String path) {
        StringUtils.Pair pair = FileUtils.parsePathAndTags(path);
        Feature feature = FeatureParser.parse(pair.left);
        feature.setCallTag(pair.right);
        return feature;
    }

    private static Resource toResource(String path, ScenarioContext context) {
        if (FileUtils.isClassPath(path)) {
            ClassLoader cl = context.getClass().getClassLoader();
            return new Resource(FileUtils.fromRelativeClassPath(path, cl), path, -1);
        }
        if (FileUtils.isFilePath(path)) {
            String temp = FileUtils.removePrefix(path);
            return new Resource(new File(temp), path);
        }
        if (FileUtils.isThisPath(path)) {
            String temp = FileUtils.removePrefix(path);
            Path parentPath = context.featureContext.parentPath;
            Path childPath = parentPath.resolve(temp);
            return new Resource(childPath, path, -1);
        }
        try {
            Path parentPath = context.rootFeatureContext.parentPath;
            Path childPath = parentPath.resolve(path);
            return new Resource(childPath, path, -1);
        }
        catch (Exception e) {
            logger.error("feature relative path resolution failed: {}", (Object)e.getMessage());
            throw e;
        }
    }

    public static String readFileAsString(String path, ScenarioContext context) {
        try {
            InputStream is = FileUtils.getFileStream(path, context);
            return FileUtils.toString(is);
        }
        catch (Exception e) {
            String message = String.format("could not find or read file: %s", path);
            context.logger.trace("{}", message);
            throw new KarateFileNotFoundException(message);
        }
    }

    public static InputStream getFileStream(String path, ScenarioContext context) {
        Resource fr = FileUtils.toResource(path, context);
        return fr.getStream();
    }

    public static String toPackageQualifiedName(String path) {
        String packagePath;
        path = FileUtils.removePrefix(path);
        if ((path = path.replace('/', '.')).contains(":\\")) {
            path = FileUtils.removePrefix(path);
        }
        if (path.indexOf(92) != -1) {
            path = path.replace('\\', '.');
        }
        if ((packagePath = path.replace("..", "")).startsWith(".")) {
            packagePath = packagePath.substring(1);
        }
        if (packagePath.endsWith(DOT_FEATURE)) {
            packagePath = packagePath.substring(0, packagePath.length() - 8);
        }
        return packagePath;
    }

    public static String toString(File file) {
        try {
            return FileUtils.toString(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(InputStream is) {
        try {
            return FileUtils.toByteStream(is).toString(UTF8.name());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toPrettyString(String raw) {
        raw = StringUtils.trimToEmpty(raw);
        try {
            if (Script.isJson(raw)) {
                return JsonUtils.toPrettyJsonString(JsonUtils.toJsonDoc(raw));
            }
            if (Script.isXml(raw)) {
                return XmlUtils.toString(XmlUtils.toXmlDoc(raw), true);
            }
        }
        catch (Exception e) {
            logger.warn("parsing failed: {}", (Object)e.getMessage());
        }
        return raw;
    }

    public static byte[] toBytes(InputStream is) {
        return FileUtils.toByteStream(is).toByteArray();
    }

    private static ByteArrayOutputStream toByteStream(InputStream is) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = is.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, UTF8);
    }

    public static byte[] toBytes(String string) {
        if (string == null) {
            return null;
        }
        return string.getBytes(UTF8);
    }

    public static void copy(File src, File dest) {
        try {
            FileUtils.writeToFile(dest, FileUtils.toString(new FileInputStream(src)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeToFile(File file, byte[] data) {
        try {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(data);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeToFile(File file, String data) {
        FileUtils.writeToFile(file, data.getBytes(UTF8));
    }

    public static InputStream toInputStream(String text) {
        return new ByteArrayInputStream(text.getBytes(UTF8));
    }

    public static String removeFileExtension(String path) {
        int pos = path.lastIndexOf(46);
        if (pos == -1) {
            return path;
        }
        return path.substring(0, pos);
    }

    public static String replaceFileExtension(String path, String extension) {
        int pos = path.lastIndexOf(46);
        if (pos == -1) {
            return path + '.' + extension;
        }
        return path.substring(0, pos + 1) + extension;
    }

    public static String getKarateVersion() {
        InputStream stream = FileUtils.class.getResourceAsStream("/karate-meta.properties");
        if (stream == null) {
            return UNKNOWN;
        }
        Properties props = new Properties();
        try {
            props.load(stream);
            stream.close();
            return (String)props.get("karate.version");
        }
        catch (IOException e) {
            return UNKNOWN;
        }
    }

    public static void renameFileIfZeroBytes(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            logger.warn("file not found, previous write operation may have failed: {}", (Object)fileName);
        } else if (file.length() == 0L) {
            logger.warn("file size is zero bytes, previous write operation may have failed: {}", (Object)fileName);
            try {
                File dest = new File(fileName + ".fail");
                file.renameTo(dest);
                logger.warn("renamed zero length file to: {}", (Object)dest.getName());
            }
            catch (Exception e) {
                logger.warn("failed to rename zero length file: {}", (Object)e.getMessage());
            }
        }
    }

    public static String toStandardPath(String path) {
        if (path == null) {
            return null;
        }
        return (path = path.replace('\\', '/')).startsWith("/") ? path.substring(1) : path;
    }

    public static String toRelativeClassPath(Path path, ClassLoader cl) {
        if (FileUtils.isJarPath(path.toUri())) {
            return CLASSPATH_COLON + FileUtils.toStandardPath(path.toString());
        }
        for (URL url : FileUtils.getAllClassPathUrls(cl)) {
            Path rootPath = FileUtils.getPathFor(url, null);
            if (!path.startsWith(rootPath)) continue;
            Path relativePath = rootPath.relativize(path);
            return CLASSPATH_COLON + FileUtils.toStandardPath(relativePath.toString());
        }
        return null;
    }

    public static File getDirContaining(Class clazz) {
        Path path = FileUtils.getPathContaining(clazz);
        return path.toFile();
    }

    public static Path getPathContaining(Class clazz) {
        String relative = FileUtils.packageAsPath(clazz);
        URL url = clazz.getClassLoader().getResource(relative);
        return FileUtils.getPathFor(url, null);
    }

    private static String packageAsPath(Class clazz) {
        Package p = clazz.getPackage();
        String relative = "";
        if (p != null) {
            relative = p.getName().replace('.', '/');
        }
        return relative;
    }

    public static File getFileRelativeTo(Class clazz, String path) {
        Path dirPath = FileUtils.getPathContaining(clazz);
        File file = new File(dirPath + File.separator + path);
        if (file.exists()) {
            return file;
        }
        try {
            URL relativePath = clazz.getClassLoader().getResource(FileUtils.packageAsPath(clazz) + File.separator + path);
            return Paths.get(relativePath.toURI()).toFile();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Cannot resolve path '%s' relative to class '%s' ", path, clazz.getName()), e);
        }
    }

    public static String toRelativeClassPath(Class clazz) {
        Path dirPath = FileUtils.getPathContaining(clazz);
        return FileUtils.toRelativeClassPath(dirPath, clazz.getClassLoader());
    }

    public static Path fromRelativeClassPath(String relativePath, ClassLoader cl) {
        relativePath = FileUtils.removePrefix(relativePath);
        URL url = cl.getResource(relativePath);
        return FileUtils.getPathFor(url, relativePath);
    }

    public static Path fromRelativeClassPath(String relativePath, Path parentPath) {
        boolean classpath = FileUtils.isClassPath(relativePath);
        relativePath = FileUtils.removePrefix(relativePath);
        if (classpath) {
            return parentPath.resolve(relativePath);
        }
        return new File(relativePath).toPath();
    }

    public static List<Resource> scanForFeatureFilesOnClassPath(ClassLoader cl) {
        return FileUtils.scanForFeatureFiles(true, CLASSPATH_COLON, cl);
    }

    public static List<Resource> scanForFeatureFiles(List<String> paths, ClassLoader cl) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (String path : paths) {
            boolean classpath = FileUtils.isClassPath(path);
            list.addAll(FileUtils.scanForFeatureFiles(classpath, path, cl));
        }
        return list;
    }

    public static List<Resource> scanForFeatureFiles(List<String> paths, Class clazz) {
        if (clazz == null) {
            return FileUtils.scanForFeatureFiles(paths, Thread.currentThread().getContextClassLoader());
        }
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (String path : paths) {
            boolean classpath = FileUtils.isClassPath(path);
            if (!classpath) {
                if (!path.endsWith(DOT_FEATURE)) {
                    path = path + DOT_FEATURE;
                }
                path = FileUtils.toRelativeClassPath(clazz) + "/" + path;
            }
            list.addAll(FileUtils.scanForFeatureFiles(true, path, clazz.getClassLoader()));
        }
        return list;
    }

    public static boolean isJarPath(URI uri) {
        return uri.toString().contains("!/");
    }

    private static Path getPathFor(URL url, String relativePath) {
        try {
            URI uri = url.toURI();
            if (FileUtils.isJarPath(uri)) {
                FileSystem fs = FileUtils.getFileSystem(uri);
                Path path = fs.getRootDirectories().iterator().next();
                if (relativePath != null) {
                    return path.resolve(relativePath);
                }
                return path;
            }
            return Paths.get(uri);
        }
        catch (Exception e) {
            logger.trace("invalid path: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static List<URL> getAllClassPathUrls(ClassLoader classLoader) {
        try {
            ArrayList<URL> list = new ArrayList<URL>();
            Enumeration<URL> iterator = classLoader.getResources("");
            while (iterator.hasMoreElements()) {
                URL[] url = iterator.nextElement();
                list.add((URL)url);
            }
            if (classLoader instanceof URLClassLoader) {
                for (URL u : ((URLClassLoader)classLoader).getURLs()) {
                    URL url = new URL("jar:" + u + "!/");
                    list.add(url);
                }
            } else {
                String classpath = System.getProperty("java.class.path");
                if (classpath != null && !classpath.isEmpty()) {
                    String[] classpathEntries;
                    for (String classpathEntry : classpathEntries = classpath.split(File.pathSeparator)) {
                        if (!classpathEntry.endsWith(".jar")) continue;
                        String entryWithForwardSlashes = classpathEntry.replaceAll("\\\\", "/");
                        boolean startsWithSlash = entryWithForwardSlashes.startsWith("/");
                        URL url = new URL("jar:file:" + (startsWithSlash ? "" : "/") + entryWithForwardSlashes + "!/");
                        list.add(url);
                    }
                }
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileSystem getFileSystem(URI uri) {
        FileSystem fs = FILE_SYSTEM_CACHE.get(uri);
        if (fs != null) {
            return fs;
        }
        Map<URI, FileSystem> map = FILE_SYSTEM_CACHE;
        synchronized (map) {
            fs = FILE_SYSTEM_CACHE.get(uri);
            if (fs != null) {
                return fs;
            }
            try {
                fs = FileSystems.getFileSystem(uri);
            }
            catch (Exception e) {
                try {
                    logger.trace("creating file system for URI: {} - {}", (Object)uri, (Object)e.getMessage());
                    fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
                }
                catch (IOException ioe) {
                    logger.error("file system creation failed for URI: {} - {}", (Object)uri, (Object)ioe.getMessage());
                    throw new RuntimeException(ioe);
                }
            }
            FILE_SYSTEM_CACHE.put(uri, fs);
            return fs;
        }
    }

    public static List<Resource> scanForFeatureFiles(boolean classpath, String searchPath, ClassLoader cl) {
        ArrayList<Resource> files = new ArrayList<Resource>();
        if (classpath) {
            searchPath = FileUtils.removePrefix(searchPath);
            for (URL url : FileUtils.getAllClassPathUrls(cl)) {
                FileUtils.collectFeatureFiles(url, searchPath, files);
            }
            return files;
        }
        FileUtils.collectFeatureFiles(null, searchPath, files);
        return files;
    }

    private static void collectFeatureFiles(URL url, String searchPath, List<Resource> files) {
        Stream<Path> stream;
        Path search;
        Path rootPath;
        boolean classpath = url != null;
        int colonPos = searchPath.lastIndexOf(58);
        int line = -1;
        if (colonPos > 1) {
            try {
                line = Integer.valueOf(searchPath.substring(colonPos + 1));
                searchPath = searchPath.substring(0, colonPos);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (classpath) {
            rootPath = FileUtils.getPathFor(url, null);
            if (rootPath == null) {
                return;
            }
            search = rootPath.resolve(searchPath);
        } else {
            rootPath = new File(".").getAbsoluteFile().toPath();
            search = Paths.get(searchPath, new String[0]);
        }
        try {
            stream = Files.walk(search, new FileVisitOption[0]);
        }
        catch (IOException e) {
            return;
        }
        Iterator paths = stream.iterator();
        while (paths.hasNext()) {
            Path path = (Path)paths.next();
            Path fileName = path.getFileName();
            if (fileName == null || !fileName.toString().endsWith(DOT_FEATURE)) continue;
            String relativePath = rootPath.relativize(path.toAbsolutePath()).toString();
            relativePath = relativePath.replaceAll("[.]{2,}", "");
            String prefix = classpath ? CLASSPATH_COLON : "";
            files.add(new Resource(path, prefix + FileUtils.toStandardPath(relativePath), line));
        }
    }

    public static String getBuildDir() {
        String temp = System.getProperty("karate.output.dir");
        if (temp != null) {
            return temp;
        }
        String command = System.getProperty("sun.java.command", "");
        return command.contains("org.gradle.") ? "build" : "target";
    }

    public static boolean isOsWindows() {
        return FileUtils.getOsType() == OsType.WINDOWS;
    }

    public static boolean isOsMacOsX() {
        return FileUtils.getOsType() == OsType.MACOSX;
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static OsType getOsType() {
        return FileUtils.getOsType(FileUtils.getOsName());
    }

    public static OsType getOsType(String name) {
        if ((name = name == null ? "unknown" : name.toLowerCase()).contains("win")) {
            return OsType.WINDOWS;
        }
        if (name.contains("mac")) {
            return OsType.MACOSX;
        }
        if (name.contains("nix") || name.contains("nux")) {
            return OsType.LINUX;
        }
        return OsType.UNKNOWN;
    }

    public static enum OsType {
        WINDOWS,
        MACOSX,
        LINUX,
        UNKNOWN;

    }
}

