/*
 * Decompiled with CFR 0.152.
 */
package io.netty.karate.handler.codec.serialization;

import io.netty.karate.buffer.ByteBuf;
import io.netty.karate.buffer.ByteBufOutputStream;
import io.netty.karate.channel.ChannelHandler;
import io.netty.karate.channel.ChannelHandlerContext;
import io.netty.karate.handler.codec.MessageToByteEncoder;
import io.netty.karate.handler.codec.serialization.CompactObjectOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

@ChannelHandler.Sharable
public class ObjectEncoder
extends MessageToByteEncoder<Serializable> {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, Serializable msg, ByteBuf out) throws Exception {
        int startIdx = out.writerIndex();
        ByteBufOutputStream bout = new ByteBufOutputStream(out);
        ObjectOutputStream oout = null;
        try {
            bout.write(LENGTH_PLACEHOLDER);
            oout = new CompactObjectOutputStream(bout);
            oout.writeObject(msg);
            oout.flush();
        }
        finally {
            if (oout != null) {
                oout.close();
            } else {
                bout.close();
            }
        }
        int endIdx = out.writerIndex();
        out.setInt(startIdx, endIdx - startIdx - 4);
    }
}

