/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.shell;

import com.intuit.karate.FileUtils;
import com.intuit.karate.LogAppender;
import com.intuit.karate.Logger;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileLogAppender
implements LogAppender {
    private final RandomAccessFile file;
    private final FileChannel channel;
    private final Logger logger;
    private int prevPos;
    private boolean closed;

    public FileLogAppender(String in, Logger logger) {
        this(in == null ? null : new File(in), logger);
    }

    public FileLogAppender(File in, Logger logger) {
        this.logger = logger;
        try {
            if (in == null) {
                in = File.createTempFile("karate", "tmp");
            } else if (!in.getParentFile().exists()) {
                in.getParentFile().mkdirs();
            }
            this.file = new RandomAccessFile(in, "rw");
            this.channel = this.file.getChannel();
            this.prevPos = (int)this.channel.position();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        logger.setLogAppender(this);
    }

    @Override
    public String collect() {
        try {
            int pos = (int)this.channel.position();
            ByteBuffer buf = ByteBuffer.allocate(pos - this.prevPos);
            this.channel.read(buf, this.prevPos);
            this.prevPos = pos;
            buf.flip();
            return FileUtils.toString(buf.array());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void append(String text) {
        if (this.closed) {
            return;
        }
        try {
            this.channel.write(ByteBuffer.wrap(text.getBytes(FileUtils.UTF8)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.file.close();
            this.closed = true;
        }
        catch (Exception e) {
            this.logger.warn("log appender close failed: {}", e.getMessage());
        }
    }
}

