/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.shell;

import com.intuit.karate.LogAppender;
import com.intuit.karate.Logger;
import com.intuit.karate.shell.FileLogAppender;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import org.slf4j.LoggerFactory;

public class CommandThread
extends Thread {
    protected static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(CommandThread.class);
    private final File workingDir;
    private final String uniqueName;
    private final Logger logger;
    private final String[] args;
    private final List argList;
    private Process process;
    private final boolean sharedAppender;
    private final LogAppender appender;
    private int exitCode = -1;

    public CommandThread(String ... args) {
        this((Logger)null, (String)null, (String)null, (File)null, args);
    }

    public CommandThread(File workingDir, String ... args) {
        this(null, null, null, workingDir, args);
    }

    public CommandThread(Logger logger, String uniqueName, String logFile, File workingDir, String ... args) {
        this.setDaemon(true);
        this.uniqueName = uniqueName == null ? System.currentTimeMillis() + "" : uniqueName;
        this.setName(this.uniqueName);
        this.logger = logger == null ? new Logger() : logger;
        this.workingDir = workingDir == null ? new File(".") : workingDir;
        this.args = args;
        this.workingDir.mkdirs();
        this.argList = Arrays.asList(args);
        if (logFile == null) {
            this.appender = LogAppender.NO_OP;
            this.sharedAppender = false;
        } else {
            LogAppender temp = this.logger.getLogAppender();
            this.sharedAppender = temp != null;
            this.appender = this.sharedAppender ? temp : new FileLogAppender(logFile, this.logger);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LogAppender getAppender() {
        return this.appender;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public int waitSync() {
        try {
            this.join();
            return this.exitCode;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        LOGGER.debug("closing command: {}", (Object)this.uniqueName);
        this.process.destroyForcibly();
    }

    @Override
    public void run() {
        try {
            String line;
            this.logger.debug("command: {}", this.argList);
            ProcessBuilder pb = new ProcessBuilder(this.args);
            this.logger.debug("env PATH: {}", pb.environment().get("PATH"));
            pb.directory(this.workingDir);
            pb.redirectErrorStream(true);
            this.process = pb.start();
            BufferedReader in = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            while ((line = in.readLine()) != null) {
                this.appender.append(line);
                this.logger.debug("{}", line);
            }
            this.exitCode = this.process.waitFor();
            if (!this.sharedAppender) {
                this.appender.close();
            }
            LOGGER.debug("command complete, exit code: {} - {}", (Object)this.exitCode, (Object)this.argList);
        }
        catch (Exception e) {
            LOGGER.error("command error: {} - {}", (Object)this.argList, (Object)e.getMessage());
        }
    }
}

