/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.netty;

import com.intuit.karate.netty.WebSocketClientInitializer;
import com.intuit.karate.netty.WebSocketListener;
import com.intuit.karate.netty.WebSocketOptions;
import io.netty.karate.bootstrap.Bootstrap;
import io.netty.karate.buffer.ByteBuf;
import io.netty.karate.buffer.Unpooled;
import io.netty.karate.channel.Channel;
import io.netty.karate.channel.EventLoopGroup;
import io.netty.karate.channel.nio.NioEventLoopGroup;
import io.netty.karate.channel.socket.nio.NioSocketChannel;
import io.netty.karate.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.karate.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.karate.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.karate.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClient
implements WebSocketListener {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketClient.class);
    private final Channel channel;
    private final EventLoopGroup group;
    private Function<String, Boolean> textHandler;
    private Function<byte[], Boolean> binaryHandler;
    private boolean waiting;
    private final Object LOCK = new Object();
    private Object signalResult;

    @Override
    public void onMessage(String text) {
        if (this.textHandler != null && this.textHandler.apply(text).booleanValue()) {
            this.signal(text);
        }
    }

    @Override
    public void onMessage(byte[] bytes) {
        if (this.binaryHandler != null && this.binaryHandler.apply(bytes).booleanValue()) {
            this.signal(bytes);
        }
    }

    public WebSocketClient(WebSocketOptions options) {
        this.textHandler = options.getTextHandler();
        this.binaryHandler = options.getBinaryHandler();
        this.group = new NioEventLoopGroup();
        try {
            WebSocketClientInitializer initializer = new WebSocketClientInitializer(options, this);
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).handler(initializer);
            this.channel = b.connect(options.getUri().getHost(), options.getPort()).sync().channel();
            initializer.getHandler().handshakeFuture().sync();
        }
        catch (Exception e) {
            logger.error("websocket server init failed: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void setBinaryHandler(Function<byte[], Boolean> binaryHandler) {
        this.binaryHandler = binaryHandler;
    }

    public void setTextHandler(Function<String, Boolean> textHandler) {
        this.textHandler = textHandler;
    }

    public void waitSync() {
        if (this.waiting) {
            return;
        }
        try {
            this.waiting = true;
            this.channel.closeFuture().sync();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.channel.writeAndFlush(new CloseWebSocketFrame());
        this.waitSync();
        this.group.shutdownGracefully();
    }

    public void ping() {
        PingWebSocketFrame frame = new PingWebSocketFrame(Unpooled.wrappedBuffer(new byte[]{8, 1, 8, 1}));
        this.channel.writeAndFlush(frame);
    }

    public void send(String msg) {
        TextWebSocketFrame frame = new TextWebSocketFrame(msg);
        this.channel.writeAndFlush(frame);
        if (logger.isTraceEnabled()) {
            logger.trace("sent: {}", (Object)msg);
        }
    }

    public void sendBytes(byte[] msg) {
        ByteBuf byteBuf = Unpooled.copiedBuffer(msg);
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(byteBuf);
        this.channel.writeAndFlush(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal(Object result) {
        logger.trace("signal called: {}", result);
        Object object = this.LOCK;
        synchronized (object) {
            this.signalResult = result;
            this.LOCK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object listen(long timeout) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.signalResult != null) {
                logger.debug("signal arrived early ! result: {}", this.signalResult);
                Object temp = this.signalResult;
                this.signalResult = null;
                return temp;
            }
            try {
                logger.trace("entered listen wait state");
                this.LOCK.wait(timeout);
                logger.trace("exit listen wait state, result: {}", this.signalResult);
            }
            catch (InterruptedException e) {
                logger.error("listen timed out: {}", (Object)e.getMessage());
            }
            Object temp = this.signalResult;
            this.signalResult = null;
            return temp;
        }
    }
}

