/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.netty;

import com.intuit.karate.StringUtils;
import com.intuit.karate.core.FeatureBackend;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpResponse;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.MultiValuedMap;
import io.netty.karate.buffer.ByteBuf;
import io.netty.karate.buffer.Unpooled;
import io.netty.karate.channel.ChannelFutureListener;
import io.netty.karate.channel.ChannelHandlerContext;
import io.netty.karate.channel.SimpleChannelInboundHandler;
import io.netty.karate.handler.codec.http.DefaultFullHttpResponse;
import io.netty.karate.handler.codec.http.FullHttpRequest;
import io.netty.karate.handler.codec.http.HttpHeaders;
import io.netty.karate.handler.codec.http.HttpResponseStatus;
import io.netty.karate.handler.codec.http.HttpVersion;
import io.netty.karate.handler.codec.http.QueryStringDecoder;
import io.netty.karate.util.CharsetUtil;
import java.util.List;

public class FeatureServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final FeatureBackend backend;
    private final Runnable stopFunction;
    private final boolean ssl;
    private static final String STOP_URI = "/__admin/stop";

    public FeatureServerHandler(FeatureBackend backend, boolean ssl, Runnable stopFunction) {
        this.backend = backend;
        this.ssl = ssl;
        this.stopFunction = stopFunction;
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) {
        DefaultFullHttpResponse nettyResponse;
        long startTime = System.currentTimeMillis();
        this.backend.getContext().logger.debug("handling method: {}, uri: {}", msg.method(), msg.uri());
        if (msg.uri().startsWith(STOP_URI)) {
            this.backend.getContext().logger.info("stop uri invoked, shutting down", new Object[0]);
            ByteBuf responseBuf = Unpooled.copiedBuffer("stopped", CharsetUtil.UTF_8);
            nettyResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, responseBuf);
            this.stopFunction.run();
        } else {
            StringUtils.Pair url = HttpUtils.parseUriIntoUrlBaseAndPath(msg.uri());
            HttpRequest request = new HttpRequest();
            if (url.left == null) {
                String requestScheme = this.ssl ? "https" : "http";
                String host = msg.headers().get("Host");
                request.setUrlBase(requestScheme + "://" + host);
            } else {
                request.setUrlBase(url.left);
            }
            request.setUri(url.right);
            request.setMethod(msg.method().name());
            msg.headers().forEach(h -> request.addHeader((String)h.getKey(), (String)h.getValue()));
            QueryStringDecoder decoder = new QueryStringDecoder(url.right);
            decoder.parameters().forEach((k, v) -> request.putParam((String)k, (List<String>)v));
            FullHttpRequest httpContent = msg;
            ByteBuf content = httpContent.content();
            if (content.isReadable()) {
                byte[] bytes = new byte[content.readableBytes()];
                content.readBytes(bytes);
                request.setBody(bytes);
            }
            HttpResponse response = this.backend.buildResponse(request, startTime);
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.valueOf(response.getStatus());
            byte[] responseBody = response.getBody();
            if (responseBody != null) {
                ByteBuf responseBuf = Unpooled.copiedBuffer(responseBody);
                nettyResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, httpResponseStatus, responseBuf);
            } else {
                nettyResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, httpResponseStatus);
            }
            MultiValuedMap karateHeaders = response.getHeaders();
            if (karateHeaders != null) {
                HttpHeaders nettyHeaders = nettyResponse.headers();
                karateHeaders.forEach((k, v) -> nettyHeaders.add((String)k, (Iterable<?>)v));
            }
        }
        ctx.write(nettyResponse);
        ctx.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause.getMessage() == null) {
            cause.printStackTrace();
        } else {
            this.backend.getContext().logger.error("error, closing connection: {}", cause.getMessage());
        }
        ctx.close();
    }
}

