/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.netty;

import com.intuit.karate.netty.FeatureServerInitializer;
import io.netty.karate.bootstrap.ServerBootstrap;
import io.netty.karate.channel.Channel;
import io.netty.karate.channel.EventLoopGroup;
import io.netty.karate.channel.nio.NioEventLoopGroup;
import io.netty.karate.channel.socket.nio.NioServerSocketChannel;
import io.netty.karate.handler.logging.LogLevel;
import io.netty.karate.handler.logging.LoggingHandler;
import io.netty.karate.handler.ssl.SslContext;
import io.netty.karate.handler.ssl.SslContextBuilder;
import io.netty.karate.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureServer {
    private static final Logger logger = LoggerFactory.getLogger(FeatureServer.class);
    private final Channel channel;
    private final String host;
    private final int port;
    private final boolean ssl;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;

    public static FeatureServer start(File featureFile, int port, boolean ssl, Map<String, Object> vars) {
        return new FeatureServer(featureFile, port, ssl, vars);
    }

    public static FeatureServer start(File featureFile, int port, File certFile, File privateKeyFile, Map<String, Object> vars) {
        return new FeatureServer(featureFile, port, certFile, privateKeyFile, vars);
    }

    public int getPort() {
        return this.port;
    }

    public void waitSync() {
        try {
            this.channel.closeFuture().sync();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        logger.info("stop: shutting down");
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        logger.info("stop: shutdown complete");
    }

    private static SslContext getSelfSignedSslContext() {
        try {
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            return SslContextBuilder.forServer(ssc.certificate(), ssc.privateKey()).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static SslContext getSslContextFromFiles(File sslCert, File sslPrivateKey) {
        try {
            return SslContextBuilder.forServer(sslCert, sslPrivateKey).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private FeatureServer(File featureFile, int port, File certificate, File privateKey, Map<String, Object> vars) {
        this(featureFile, port, FeatureServer.getSslContextFromFiles(certificate, privateKey), vars);
    }

    private FeatureServer(File featureFile, int port, boolean ssl, Map<String, Object> vars) {
        this(featureFile, port, ssl ? FeatureServer.getSelfSignedSslContext() : null, vars);
    }

    private FeatureServer(File featureFile, int requestedPort, SslContext sslCtx, Map<String, Object> vars) {
        this.ssl = sslCtx != null;
        File parent = featureFile.getParentFile();
        if (parent == null) {
            featureFile = new File(featureFile.getAbsolutePath());
        }
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
        FeatureServerInitializer initializer = new FeatureServerInitializer(sslCtx, featureFile, vars, () -> this.stop());
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler(new LoggingHandler(this.getClass().getName(), LogLevel.TRACE))).childHandler(initializer);
            this.channel = b.bind(requestedPort).sync().channel();
            InetSocketAddress isa = (InetSocketAddress)this.channel.localAddress();
            this.host = "127.0.0.1";
            this.port = isa.getPort();
            logger.info("server started - {}://{}:{}", new Object[]{this.ssl ? "https" : "http", this.host, this.port});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

