/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.formats.postman;

import com.intuit.karate.formats.postman.PostmanItem;
import com.intuit.karate.formats.postman.PostmanRequest;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostmanUtils {
    private static final Logger logger = LoggerFactory.getLogger(PostmanUtils.class);

    private PostmanUtils() {
    }

    public static String toKarateFeature(List<PostmanItem> items) {
        return PostmanUtils.toKarateFeature(UUID.randomUUID().toString(), items);
    }

    public static String toKarateFeature(String collectionName, List<PostmanItem> items) {
        StringBuilder sb = new StringBuilder("Feature: ").append(collectionName);
        sb.append(System.lineSeparator()).append(System.lineSeparator());
        for (PostmanItem item : items) {
            sb.append(item.convert());
        }
        return sb.toString();
    }

    public static List<PostmanItem> readPostmanJson(String json) {
        DocumentContext doc = JsonPath.parse((String)json);
        List list = (List)doc.read("$.item", new Predicate[0]);
        return PostmanUtils.readPostmanItems(null, list);
    }

    private static List<PostmanItem> readPostmanItems(PostmanItem parent, List<Map<String, Object>> list) {
        ArrayList<PostmanItem> requests = new ArrayList<PostmanItem>(list.size());
        for (Map<String, Object> map : list) {
            logger.debug("map: {}", map);
            PostmanItem item = PostmanUtils.readPostmanItem(parent, map);
            requests.add(item);
        }
        return requests;
    }

    private static PostmanItem readPostmanItem(PostmanItem parent, Map<String, Object> itemMap) {
        PostmanItem item = new PostmanItem();
        String name = (String)itemMap.get("name");
        item.setName(name);
        item.setParent(Optional.ofNullable(parent));
        Map requestInfo = (Map)itemMap.get("request");
        if (requestInfo != null) {
            item.setRequest(PostmanUtils.readPostmanRequest(requestInfo));
        } else {
            List<PostmanItem> subItems = PostmanUtils.readPostmanItems(item, (List)itemMap.get("item"));
            item.setItems(Optional.of(subItems));
        }
        return item;
    }

    private static PostmanRequest readPostmanRequest(Map<String, Object> requestInfo) {
        String url = PostmanUtils.getUrl(requestInfo.get("url"));
        String method = (String)requestInfo.get("method");
        List headersList = (List)requestInfo.get("header");
        HashMap<String, String> headers = new HashMap<String, String>();
        if (headersList != null) {
            for (Map header : headersList) {
                headers.put((String)header.get("key"), (String)header.get("value"));
            }
        }
        Map bodyInfo = (Map)requestInfo.get("body");
        String body = null;
        if (bodyInfo.containsKey("raw")) {
            body = ((String)bodyInfo.get("raw")).replace(System.lineSeparator(), "");
        } else if (bodyInfo.containsKey("formdata")) {
            body = ((List)bodyInfo.get("formdata")).toString().replace(System.lineSeparator(), "");
        }
        PostmanRequest request = new PostmanRequest();
        request.setUrl(url);
        request.setMethod(method);
        request.setHeaders(headers);
        request.setBody(body);
        return request;
    }

    private static String getUrl(Object url) {
        return url instanceof String ? (String)url : (String)((Map)url).get("raw");
    }
}

