/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.windows;

import com.intuit.karate.Http;
import com.intuit.karate.Json;
import com.intuit.karate.Logger;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.WebDriver;
import com.intuit.karate.shell.CommandThread;
import java.util.Collections;
import java.util.Map;

public class WinAppDriver
extends WebDriver {
    public WinAppDriver(DriverOptions options, CommandThread command, Http http, String sessionId, String windowId) {
        super(options, command, http, sessionId, windowId);
    }

    public static WinAppDriver start(ScenarioContext context, Map<String, Object> map, Logger logger) {
        DriverOptions options = new DriverOptions(context, map, logger, 4727, "C:/Program Files (x86)/Windows Application Driver/WinAppDriver");
        options.arg(options.port + "");
        CommandThread command = options.startProcess();
        String urlBase = "http://" + options.host + ":" + options.port;
        Http http = Http.forUrl(options.driverLogger, urlBase);
        Map<String, Object> capabilities = options.newMapWithSelectedKeys(map, "app", "appArguments", "appTopLevelWindow", "appWorkingDir");
        String sessionId = http.path("session").post(Collections.singletonMap("desiredCapabilities", capabilities)).jsonPath("get[0] response..sessionId").asString();
        options.driverLogger.debug("init session id: {}", sessionId);
        http.url(urlBase + "/session/" + sessionId);
        String windowId = http.path("window").get().jsonPath("$.value").asString();
        options.driverLogger.debug("init window id: {}", windowId);
        WinAppDriver driver = new WinAppDriver(options, command, http, sessionId, windowId);
        return driver;
    }

    @Override
    public void activate() {
    }

    private String getElementSelector(String id) {
        Json json = new Json();
        if (id.startsWith("/")) {
            json.set("using", "xpath").set("value", id);
        } else if (id.startsWith("@")) {
            json.set("using", "accessibility id").set("value", id.substring(1));
        } else if (id.startsWith("#")) {
            json.set("using", "id").set("value", id.substring(1));
        } else {
            json.set("using", "name").set("value", id);
        }
        return json.toString();
    }

    @Override
    protected String getElementId(String id) {
        String body = this.getElementSelector(id);
        return this.http.path("element").post(body).jsonPath("get[0] $..ELEMENT").asString();
    }

    @Override
    public void click(String selector) {
        String id = this.getElementId(selector);
        this.http.path("element", id, "click").post("{}");
    }

    @Override
    protected String getJsonForInput(String text) {
        return new Json().set("value[0]", text).toString();
    }
}

