/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.edge;

import com.intuit.karate.Http;
import com.intuit.karate.Json;
import com.intuit.karate.Logger;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.WebDriver;
import com.intuit.karate.shell.CommandThread;
import java.util.Map;

public class MicrosoftWebDriver
extends WebDriver {
    public MicrosoftWebDriver(DriverOptions options, CommandThread command, Http http, String sessionId, String windowId) {
        super(options, command, http, sessionId, windowId);
    }

    public static MicrosoftWebDriver start(ScenarioContext context, Map<String, Object> map, Logger logger) {
        DriverOptions options = new DriverOptions(context, map, logger, 17556, "MicrosoftWebDriver");
        options.arg("--port=" + options.port);
        CommandThread command = options.startProcess();
        String urlBase = "http://" + options.host + ":" + options.port;
        Http http = Http.forUrl(options.driverLogger, urlBase);
        String sessionId = http.path("session").post("{ desiredCapabilities: { browserName: 'Edge' } }").jsonPath("get[0] response..sessionId").asString();
        options.driverLogger.debug("init session id: {}", sessionId);
        http.url(urlBase + "/session/" + sessionId);
        String windowId = http.path("window").get().jsonPath("$.value").asString();
        options.driverLogger.debug("init window id: {}", windowId);
        MicrosoftWebDriver driver = new MicrosoftWebDriver(options, command, http, sessionId, windowId);
        driver.activate();
        return driver;
    }

    @Override
    protected String getJsonForInput(String text) {
        return new Json().set("keysToSend[0]", text).toString();
    }

    @Override
    public void activate() {
        this.logger.warn("activate not implemented for mswebdriver", new Object[0]);
    }
}

