/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.edge;

import com.intuit.karate.Http;
import com.intuit.karate.Logger;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.driver.DevToolsDriver;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.shell.CommandThread;
import java.util.List;
import java.util.Map;

public class EdgeDevToolsDriver
extends DevToolsDriver {
    public EdgeDevToolsDriver(DriverOptions options, CommandThread command, String webSocketUrl) {
        super(options, command, webSocketUrl);
    }

    public static EdgeDevToolsDriver start(ScenarioContext context, Map<String, Object> map, Logger logger) {
        DriverOptions options = new DriverOptions(context, map, logger, 9222, "MicrosoftEdge");
        options.arg("--devtools-server-port");
        options.arg(options.port + "");
        options.arg("about:blank");
        CommandThread command = options.startProcess();
        Http http = Http.forUrl(options.driverLogger, "http://" + options.host + ":" + options.port);
        String webSocketUrl = http.path("json", "list").get().jsonPath("get[0] $[?(@.type=='Page')].webSocketDebuggerUrl").asString();
        EdgeDevToolsDriver edge = new EdgeDevToolsDriver(options, command, webSocketUrl);
        edge.enablePageEvents();
        return edge;
    }

    @Override
    public void activate() {
    }

    @Override
    public void setLocation(String url) {
        this.method("Page.navigate").param("url", url).send();
        this.waitUntil("document.readyState == 'complete'");
        this.currentUrl = url;
    }

    @Override
    public void input(String id, String value) {
        this.evaluate(this.options.elementSelector(id) + ".value = \"" + value + "\"", null);
    }

    @Override
    public void close() {
    }

    @Override
    public List<String> getWindowHandles() {
        return null;
    }

    @Override
    public void quit() {
        this.close();
        if (this.command != null) {
            this.command.close();
        }
    }
}

