/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.Http;
import com.intuit.karate.Json;
import com.intuit.karate.Logger;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.driver.Driver;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.shell.CommandThread;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class WebDriver
implements Driver {
    protected final DriverOptions options;
    protected final Logger logger;
    protected final CommandThread command;
    protected final Http http;
    private final String sessionId;
    private final String windowId;
    protected boolean open = true;

    protected WebDriver(DriverOptions options, CommandThread command, Http http, String sessionId, String windowId) {
        this.options = options;
        this.logger = options.driverLogger;
        this.command = command;
        this.http = http;
        this.sessionId = sessionId;
        this.windowId = windowId;
    }

    private ScriptValue evalInternal(String expression) {
        Json json = new Json().set("script", expression).set("args", "[]");
        return this.http.path("execute", "sync").post(json).jsonPath("$.value").value();
    }

    protected String getJsonPathForElementId() {
        return "get[0] $..element-6066-11e4-a52e-4f735466cecf";
    }

    protected String getJsonForInput(String text) {
        return new Json().set("text", text).toString();
    }

    protected String getJsonForHandle(String text) {
        return new Json().set("handle", text).toString();
    }

    protected String getElementLocator(String id) {
        Json json = new Json();
        if (id.startsWith("^")) {
            json.set("using", "link text").set("value", id.substring(1));
        } else if (id.startsWith("*")) {
            json.set("using", "partial link text").set("value", id.substring(1));
        } else if (id.startsWith("/")) {
            json.set("using", "xpath").set("value", id);
        } else {
            json.set("using", "css selector").set("value", id);
        }
        return json.toString();
    }

    protected String getElementId(String id) {
        String body = this.getElementLocator(id);
        return this.http.path("element").post(body).jsonPath(this.getJsonPathForElementId()).asString();
    }

    @Override
    public void setLocation(String url) {
        Json json = new Json().set("url", url);
        this.http.path("url").post(json);
    }

    @Override
    public Map<String, Object> getDimensions() {
        Map<String, Object> map = this.http.path("window", "rect").get().asMap();
        Integer left = (Integer)map.remove("x");
        Integer top = (Integer)map.remove("y");
        map.put("left", left);
        map.put("top", top);
        return map;
    }

    @Override
    public void setDimensions(Map<String, Object> map) {
        Integer x = (Integer)map.remove("left");
        Integer y = (Integer)map.remove("top");
        map.put("x", x);
        map.put("y", y);
        Json json = new Json(map);
        this.http.path("window", "rect").post(json);
    }

    @Override
    public void refresh() {
        this.http.path("refresh").post("{}");
    }

    @Override
    public void reload() {
        this.refresh();
    }

    @Override
    public void back() {
        this.http.path("back").post("{}");
    }

    @Override
    public void forward() {
        this.http.path("forward").post("{}");
    }

    @Override
    public void maximize() {
        this.http.path("window", "maximize").post("{}");
    }

    @Override
    public void minimize() {
        this.http.path("window", "minimize").post("{}");
    }

    @Override
    public void fullscreen() {
        this.http.path("window", "fullscreen").post("{}");
    }

    @Override
    public void focus(String id) {
        this.evalInternal(this.options.elementSelector(id) + ".focus()");
    }

    @Override
    public void clear(String id) {
        this.http.path("element", id, "clear").post("{}");
    }

    @Override
    public void input(String name, String value) {
        this.input(name, value, false);
    }

    @Override
    public void input(String name, String value, boolean clear) {
        String id = this.getElementId(name);
        if (clear) {
            this.clear(id);
        }
        this.http.path("element", id, "value").post(this.getJsonForInput(value));
    }

    @Override
    public void click(String id) {
        this.click(id, false);
    }

    @Override
    public void click(String id, boolean ignored) {
        this.evalInternal(this.options.elementSelector(id) + ".click()");
    }

    @Override
    public void select(String id, String text) {
        this.evalInternal(this.options.optionSelector(id, text));
    }

    @Override
    public void select(String id, int index) {
        this.evalInternal(this.options.optionSelector(id, index));
    }

    @Override
    public void submit(String name) {
        this.click(name);
        this.waitUntil("document.readyState == 'complete'");
    }

    @Override
    public void close() {
        this.http.path("window").delete();
        this.open = false;
    }

    @Override
    public void quit() {
        if (this.open) {
            this.close();
        }
        this.http.delete();
        if (this.command != null) {
            this.command.close();
        }
    }

    @Override
    public String getLocation() {
        return this.http.path("url").get().jsonPath("$.value").asString();
    }

    @Override
    public String html(String locator) {
        return this.property(locator, "innerHTML");
    }

    @Override
    public String text(String locator) {
        String id = this.getElementId(locator);
        return this.http.path("element", id, "text").get().jsonPath("$.value").asString();
    }

    @Override
    public String value(String locator) {
        return this.property(locator, "value");
    }

    @Override
    public void value(String locator, String value) {
        this.evalInternal(this.options.elementSelector(locator) + ".value = '" + value + "'");
    }

    @Override
    public String attribute(String locator, String name) {
        String id = this.getElementId(locator);
        return this.http.path("element", id, "attribute", name).get().jsonPath("$.value").asString();
    }

    @Override
    public String property(String locator, String name) {
        String id = this.getElementId(locator);
        return this.http.path("element", id, "property", name).get().jsonPath("$.value").asString();
    }

    @Override
    public String css(String locator, String name) {
        String id = this.getElementId(locator);
        return this.http.path("element", id, "css", name).get().jsonPath("$.value").asString();
    }

    @Override
    public String name(String locator) {
        return this.property(locator, "tagName");
    }

    @Override
    public Map<String, Object> rect(String locator) {
        String id = this.getElementId(locator);
        return this.http.path("element", id, "rect").get().jsonPath("$.value").asMap();
    }

    @Override
    public boolean enabled(String locator) {
        String id = this.getElementId(locator);
        return this.http.path("element", id, "enabled").get().jsonPath("$.value").isBooleanTrue();
    }

    private String prefixReturn(String expression) {
        return expression.startsWith("return ") ? expression : "return " + expression;
    }

    @Override
    public void waitUntil(String expression) {
        ScriptValue sv;
        expression = this.prefixReturn(expression);
        int max = this.options.getRetryCount();
        int count = 0;
        do {
            this.options.sleep();
        } while (!(sv = this.evalInternal(expression)).isBooleanTrue() && count++ < max);
    }

    @Override
    public Object eval(String expression) {
        expression = this.prefixReturn(expression);
        return this.evalInternal(expression).getValue();
    }

    @Override
    public String getTitle() {
        return this.http.path("title").get().jsonPath("$.value").asString();
    }

    @Override
    public List<Map> getCookies() {
        return this.http.path("cookie").get().jsonPath("$.value").asList();
    }

    @Override
    public Map<String, Object> cookie(String name) {
        return this.http.path("cookie", name).get().jsonPath("$.value").asMap();
    }

    @Override
    public void setCookie(Map<String, Object> cookie) {
        this.http.path("cookie").post(Collections.singletonMap("cookie", cookie));
    }

    @Override
    public void deleteCookie(String name) {
        this.http.path("cookie", name).delete();
    }

    @Override
    public void clearCookies() {
        this.http.path("cookie").delete();
    }

    @Override
    public void dialog(boolean accept) {
        this.dialog(accept, null);
    }

    @Override
    public String getDialog() {
        return this.http.path("alert", "text").get().jsonPath("$.value").asString();
    }

    @Override
    public void dialog(boolean accept, String text) {
        if (text == null) {
            this.http.path("alert", accept ? "accept" : "dismiss").post("{}");
        } else {
            this.http.path("alert", "text").post(Collections.singletonMap("text", text));
            this.http.path("alert", "accept").post("{}");
        }
    }

    @Override
    public byte[] screenshot() {
        return this.screenshot(null);
    }

    @Override
    public byte[] screenshot(String locator) {
        String id = locator == null ? null : this.getElementId(locator);
        String temp = id == null ? this.http.path("screenshot").get().jsonPath("$.value").asString() : this.http.path("element", id, "screenshot").get().jsonPath("$.value").asString();
        return Base64.getDecoder().decode(temp);
    }

    @Override
    public void highlight(String id) {
        this.eval(this.options.highlighter(id));
    }

    protected String getWindowHandleKey() {
        return "handle";
    }

    @Override
    public List<String> getWindowHandles() {
        return this.http.path("window", "handles").get().jsonPath("$.value").asList();
    }

    @Override
    public void switchTo(String titleOrUrl) {
        if (titleOrUrl == null) {
            return;
        }
        List<String> list = this.getWindowHandles();
        for (String handle : list) {
            String url;
            this.http.path("window").post(this.getJsonForHandle(handle));
            String title = this.getTitle();
            if (titleOrUrl.equals(title)) {
                return;
            }
            String temp = this.options.removeProtocol(titleOrUrl);
            if (!temp.equals(url = this.options.removeProtocol(this.getLocation()))) continue;
            return;
        }
    }
}

