/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Logger;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.driver.Driver;
import com.intuit.karate.driver.android.AndroidDriver;
import com.intuit.karate.driver.chrome.Chrome;
import com.intuit.karate.driver.chrome.ChromeWebDriver;
import com.intuit.karate.driver.edge.EdgeDevToolsDriver;
import com.intuit.karate.driver.edge.MicrosoftWebDriver;
import com.intuit.karate.driver.firefox.GeckoWebDriver;
import com.intuit.karate.driver.ios.IosDriver;
import com.intuit.karate.driver.safari.SafariWebDriver;
import com.intuit.karate.driver.windows.WinAppDriver;
import com.intuit.karate.shell.CommandThread;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DriverOptions {
    public static final long DEFAULT_TIMEOUT = 30000L;
    private final ScenarioContext context;
    public final Map<String, Object> options;
    public final long timeout;
    public final boolean start;
    public final String executable;
    public final String type;
    public final int port;
    public final String host = "localhost";
    public final boolean headless;
    public final boolean showProcessLog;
    public final boolean showDriverLog;
    public final Logger logger;
    public final Logger processLogger;
    public final Logger driverLogger;
    public final String uniqueName;
    public final File workingDir;
    public final String workingDirPath;
    public final String processLogFile;
    public final int maxPayloadSize;
    public final List<String> args = new ArrayList<String>();

    private <T> T get(String key, T defaultValue) {
        Object temp = this.options.get(key);
        return (T)(temp == null ? defaultValue : temp);
    }

    public DriverOptions(ScenarioContext context, Map<String, Object> options, Logger logger, int defaultPort, String defaultExecutable) {
        this.context = context;
        this.options = options;
        this.logger = logger == null ? new Logger(this.getClass()) : logger;
        this.timeout = this.get("timeout", 30000L);
        this.type = this.get("type", null);
        this.port = this.get("port", defaultPort);
        this.start = this.get("start", true);
        this.executable = this.get("executable", defaultExecutable);
        this.headless = this.get("headless", false);
        this.showProcessLog = this.get("showProcessLog", false);
        this.uniqueName = this.type + "_" + System.currentTimeMillis();
        String packageName = this.getClass().getPackage().getName();
        this.processLogger = this.showProcessLog ? this.logger : new Logger(packageName + "." + this.uniqueName);
        this.showDriverLog = this.get("showDriverLog", false);
        Logger logger2 = this.driverLogger = this.showDriverLog ? this.logger : new Logger(packageName + "." + this.uniqueName);
        if (this.executable != null) {
            this.args.add(this.executable);
        }
        this.workingDir = new File(FileUtils.getBuildDir() + File.separator + this.uniqueName);
        this.workingDirPath = this.workingDir.getAbsolutePath();
        this.processLogFile = this.workingDir.getPath() + File.separator + this.type + ".log";
        this.maxPayloadSize = this.get("maxPayloadSize", 0x400000);
    }

    public void arg(String arg) {
        this.args.add(arg);
    }

    public CommandThread startProcess() {
        if (this.executable == null) {
            return null;
        }
        CommandThread command = new CommandThread(this.processLogger, this.uniqueName, this.processLogFile, this.workingDir, this.args.toArray(new String[0]));
        command.start();
        this.waitForPort("localhost", this.port);
        return command;
    }

    public static Driver start(ScenarioContext context, Map<String, Object> options, Logger logger) {
        String type = (String)options.get("type");
        if (type == null) {
            logger.warn("type was null, defaulting to 'chrome'", new Object[0]);
            type = "chrome";
        }
        switch (type) {
            case "chrome": {
                return Chrome.start(context, options, logger);
            }
            case "msedge": {
                return EdgeDevToolsDriver.start(context, options, logger);
            }
            case "chromedriver": {
                return ChromeWebDriver.start(context, options, logger);
            }
            case "geckodriver": {
                return GeckoWebDriver.start(context, options, logger);
            }
            case "safaridriver": {
                return SafariWebDriver.start(context, options, logger);
            }
            case "mswebdriver": {
                return MicrosoftWebDriver.start(context, options, logger);
            }
            case "winappdriver": {
                return WinAppDriver.start(context, options, logger);
            }
            case "android": {
                return AndroidDriver.start(context, options, logger);
            }
            case "ios": {
                return IosDriver.start(context, options, logger);
            }
        }
        logger.warn("unknown driver type: {}, defaulting to 'chrome'", type);
        return Chrome.start(context, options, logger);
    }

    public String elementSelector(String id) {
        if (id.startsWith("^")) {
            id = "//a[text()='" + id.substring(1) + "']";
        } else if (id.startsWith("*")) {
            id = "//a[contains(text(),'" + id.substring(1) + "')]";
        }
        if (id.startsWith("/")) {
            return "document.evaluate(\"" + id + "\", document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue";
        }
        return "document.querySelector(\"" + id + "\")";
    }

    public int getRetryInterval() {
        if (this.context == null) {
            return 3000;
        }
        return this.context.getConfig().getRetryInterval();
    }

    public int getRetryCount() {
        if (this.context == null) {
            return 3;
        }
        return this.context.getConfig().getRetryCount();
    }

    public String wrapInFunctionInvoke(String text) {
        return "(function(){ " + text + " })()";
    }

    public String highlighter(String id) {
        String e = this.elementSelector(id);
        String temp = "var e = " + e + "; var old = e.getAttribute('style'); e.setAttribute('style', 'background: yellow; border: 2px solid red;'); setTimeout(function(){ e.setAttribute('style', old) }, 3000);";
        return this.wrapInFunctionInvoke(temp);
    }

    public String optionSelector(String id, String text) {
        String condition;
        boolean textEquals = text.startsWith("^");
        boolean textContains = text.startsWith("*");
        if (textEquals || textContains) {
            text = text.substring(1);
            condition = textContains ? "e.options[i].text.indexOf(t) !== -1" : "e.options[i].text === t";
        } else {
            condition = "e.options[i].value === t";
        }
        String e = this.elementSelector(id);
        String temp = "var e = " + e + "; var t = \"" + text + "\"; for (var i = 0; i < e.options.length; ++i) if (" + condition + ") e.options[i].selected = true";
        return this.wrapInFunctionInvoke(temp);
    }

    public String optionSelector(String id, int index) {
        String e = this.elementSelector(id);
        String temp = "var e = " + e + "; var t = " + index + "; for (var i = 0; i < e.options.length; ++i) if (i === t) e.options[i].selected = true";
        return this.wrapInFunctionInvoke(temp);
    }

    public void sleep() {
        this.sleep(this.getRetryInterval());
    }

    public void sleep(int millis) {
        if (millis == 0) {
            return;
        }
        try {
            this.processLogger.debug("sleeping for millis: {}", millis);
            Thread.sleep(millis);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean waitForPort(String host, int port) {
        int attempts = 0;
        while (true) {
            InetSocketAddress address = new InetSocketAddress(host, port);
            try {
                this.processLogger.debug("poll attempt #{} for port to be ready - {}:{}", attempts, host, port);
                SocketChannel sock = SocketChannel.open(address);
                sock.close();
                return true;
            }
            catch (IOException e) {
                this.sleep(250);
                if (attempts++ < 19) continue;
                return false;
            }
            break;
        }
    }

    public Map<String, Object> newMapWithSelectedKeys(Map<String, Object> map, String ... keys) {
        HashMap<String, Object> out = new HashMap<String, Object>(keys.length);
        for (String key : keys) {
            Object o = map.get(key);
            if (o == null) continue;
            out.put(key, o);
        }
        return out;
    }

    public String removeProtocol(String url) {
        int pos = url.indexOf("://");
        return pos == -1 ? url : url.substring(pos + 3);
    }
}

