/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.JsonUtils;
import com.intuit.karate.Logger;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.driver.DevToolsMessage;
import com.intuit.karate.driver.Driver;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.WaitState;
import com.intuit.karate.netty.WebSocketClient;
import com.intuit.karate.netty.WebSocketOptions;
import com.intuit.karate.shell.CommandThread;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public abstract class DevToolsDriver
implements Driver {
    protected final Logger logger;
    protected final DriverOptions options;
    protected final CommandThread command;
    protected final WebSocketClient client;
    private final WaitState waitState;
    protected final String pageId;
    private Integer windowId;
    private String windowState;
    protected String currentUrl;
    protected String currentDialogText;
    private int nextId;

    public int getNextId() {
        return ++this.nextId;
    }

    protected DevToolsDriver(DriverOptions options, CommandThread command, String webSocketUrl) {
        this.options = options;
        this.logger = options.driverLogger;
        this.command = command;
        this.waitState = new WaitState(options);
        int pos = webSocketUrl.lastIndexOf(47);
        this.pageId = webSocketUrl.substring(pos + 1);
        this.logger.debug("page id: {}", this.pageId);
        WebSocketOptions wsOptions = new WebSocketOptions(webSocketUrl);
        wsOptions.setMaxPayloadSize(options.maxPayloadSize);
        wsOptions.setTextConsumer(text -> {
            this.logger.debug("<< {}", text);
            Map map = (Map)JsonUtils.toJsonDoc(text).read("$", new com.jayway.jsonpath.Predicate[0]);
            DevToolsMessage dtm = new DevToolsMessage(this, map);
            this.receive(dtm);
        });
        this.client = new WebSocketClient(wsOptions);
    }

    public int waitSync() {
        return this.command.waitSync();
    }

    public DevToolsMessage method(String method) {
        return new DevToolsMessage(this, method);
    }

    public DevToolsMessage sendAndWait(String text) {
        Map map = (Map)JsonUtils.toJsonDoc(text).read("$", new com.jayway.jsonpath.Predicate[0]);
        DevToolsMessage dtm = new DevToolsMessage(this, map);
        if (dtm.getId() == null) {
            dtm.setId(this.getNextId());
        }
        return this.sendAndWait(dtm, null);
    }

    public DevToolsMessage sendAndWait(DevToolsMessage dtm, Predicate<DevToolsMessage> condition) {
        String json = JsonUtils.toJson(dtm.toMap());
        this.logger.debug(">> {}", json);
        this.client.send(json);
        return this.waitState.waitAfterSend(dtm, condition);
    }

    public void receive(DevToolsMessage dtm) {
        this.waitState.receive(dtm);
        if (dtm.isMethod("Page.javascriptDialogOpening")) {
            this.currentDialogText = dtm.getParam("message").getAsString();
        }
        if (dtm.isMethod("Page.frameNavigated") && dtm.getFrameUrl().startsWith("http")) {
            this.currentUrl = dtm.getFrameUrl();
        }
        if (dtm.isMethod("Page.windowOpen")) {
            this.currentUrl = dtm.getParam("url").getAsString();
        }
    }

    protected DevToolsMessage evaluate(String expression, Predicate<DevToolsMessage> condition) {
        DevToolsMessage dtm;
        int count = 0;
        do {
            if (count > 0) {
                this.logger.debug("evaluate attempt #{}", count + 1);
            }
            dtm = this.method("Runtime.evaluate").param("expression", expression).send(condition);
            condition = null;
        } while (dtm != null && dtm.isResultError() && count++ < 3);
        return dtm;
    }

    protected DevToolsMessage evaluateAndGetResult(String expression, Predicate<DevToolsMessage> condition) {
        DevToolsMessage dtm = this.evaluate(expression, condition);
        String objectId = dtm.getResult("objectId").getAsString();
        return this.method("Runtime.getProperties").param("objectId", objectId).param("accessorPropertiesOnly", true).send();
    }

    @Override
    public void activate() {
        this.method("Target.activateTarget").param("targetId", this.pageId).send();
    }

    protected void initWindowIdAndState() {
        DevToolsMessage dtm = this.method("Browser.getWindowForTarget").param("targetId", this.pageId).send();
        this.windowId = dtm.getResult("windowId").getValue(Integer.class);
        this.windowState = (String)dtm.getResult("bounds").getAsMap().get("windowState");
    }

    @Override
    public Map<String, Object> getDimensions() {
        DevToolsMessage dtm = this.method("Browser.getWindowForTarget").param("targetId", this.pageId).send();
        return dtm.getResult("bounds").getAsMap();
    }

    @Override
    public void setDimensions(Map<String, Object> map) {
        Map<String, Object> temp = this.getDimensions();
        temp.putAll(map);
        temp.remove("windowState");
        this.method("Browser.setWindowBounds").param("windowId", this.windowId).param("bounds", temp).send();
    }

    @Override
    public void close() {
        this.method("Page.close").send();
    }

    @Override
    public void quit() {
        if (!this.options.headless) {
            this.method("Browser.close").send(WaitState.CHROME_INSPECTOR_DETACHED);
        }
        if (this.command != null) {
            this.command.close();
        }
    }

    @Override
    public void setLocation(String url) {
        this.method("Page.navigate").param("url", url).send(WaitState.CHROME_DOM_CONTENT);
    }

    @Override
    public void refresh() {
        this.method("Page.reload").send(WaitState.CHROME_DOM_CONTENT);
    }

    @Override
    public void reload() {
        this.method("Page.reload").param("ignoreCache", true).send();
    }

    private void history(int delta) {
        DevToolsMessage dtm = this.method("Page.getNavigationHistory").send();
        int currentIndex = dtm.getResult("currentIndex").getValue(Integer.class);
        List list = dtm.getResult("entries").getValue(List.class);
        int targetIndex = currentIndex + delta;
        if (targetIndex < 0 || targetIndex == list.size()) {
            return;
        }
        Map entry = (Map)list.get(targetIndex);
        Integer id = (Integer)entry.get("id");
        this.method("Page.navigateToHistoryEntry").param("entryId", id).send(WaitState.CHROME_DOM_CONTENT);
    }

    @Override
    public void back() {
        this.history(-1);
    }

    @Override
    public void forward() {
        this.history(1);
    }

    private void setWindowState(String state) {
        if (!"normal".equals(this.windowState)) {
            this.method("Browser.setWindowBounds").param("windowId", this.windowId).param("bounds", Collections.singletonMap("windowState", "normal")).send();
            this.windowState = "normal";
        }
        if (!state.equals(this.windowState)) {
            this.method("Browser.setWindowBounds").param("windowId", this.windowId).param("bounds", Collections.singletonMap("windowState", state)).send();
            this.windowState = state;
        }
    }

    @Override
    public void maximize() {
        this.setWindowState("maximized");
    }

    @Override
    public void minimize() {
        this.setWindowState("minimized");
    }

    @Override
    public void fullscreen() {
        this.setWindowState("fullscreen");
    }

    @Override
    public void click(String id) {
        this.click(id, false);
    }

    @Override
    public void click(String id, boolean waitForDialog) {
        this.evaluate(this.options.elementSelector(id) + ".click()", waitForDialog ? WaitState.CHROME_DIALOG_OPENING : null);
    }

    @Override
    public void select(String id, String text) {
        this.evaluate(this.options.optionSelector(id, text), null);
    }

    @Override
    public void select(String id, int index) {
        this.evaluate(this.options.optionSelector(id, index), null);
    }

    @Override
    public void submit(String id) {
        DevToolsMessage dtm = this.evaluate(this.options.elementSelector(id) + ".click()", WaitState.CHROME_DOM_CONTENT);
    }

    @Override
    public void focus(String id) {
        this.evaluate(this.options.elementSelector(id) + ".focus()", null);
    }

    @Override
    public void clear(String id) {
        this.evaluate(this.options.elementSelector(id) + ".value = ''", null);
    }

    @Override
    public void input(String id, String value) {
        this.input(id, value, false);
    }

    @Override
    public void input(String id, String value, boolean clear) {
        if (clear) {
            this.clear(id);
        }
        this.focus(id);
        for (char c : value.toCharArray()) {
            this.method("Input.dispatchKeyEvent").param("type", "keyDown").param("text", c + "").send();
        }
    }

    @Override
    public String text(String id) {
        return this.property(id, "textContent");
    }

    @Override
    public String html(String id) {
        return this.property(id, "innerHTML");
    }

    @Override
    public String value(String id) {
        return this.property(id, "value");
    }

    @Override
    public void value(String id, String value) {
        this.evaluate(this.options.elementSelector(id) + ".value = '" + value + "'", null);
    }

    @Override
    public String attribute(String id, String name) {
        DevToolsMessage dtm = this.evaluate(this.options.elementSelector(id) + ".getAttribute('" + name + "')", null);
        return dtm.getResult().getAsString();
    }

    @Override
    public String property(String id, String name) {
        DevToolsMessage dtm = this.evaluate(this.options.elementSelector(id) + "['" + name + "']", null);
        return dtm.getResult().getAsString();
    }

    @Override
    public String css(String id, String name) {
        DevToolsMessage dtm = this.evaluate("getComputedStyle(" + this.options.elementSelector(id) + ")['" + name + "']", null);
        return dtm.getResult().getAsString();
    }

    @Override
    public String name(String id) {
        return this.property(id, "tagName");
    }

    @Override
    public Map<String, Object> rect(String id) {
        DevToolsMessage dtm = this.evaluateAndGetResult(this.options.elementSelector(id) + ".getBoundingClientRect()", null);
        return this.options.newMapWithSelectedKeys(dtm.getResult().getAsMap(), "x", "y", "width", "height");
    }

    @Override
    public boolean enabled(String id) {
        DevToolsMessage dtm = this.evaluate(this.options.elementSelector(id) + ".disabled", null);
        return !dtm.getResult().isBooleanTrue();
    }

    @Override
    public void waitUntil(String expression) {
        DevToolsMessage dtm;
        ScriptValue sv;
        int max = this.options.getRetryCount();
        int count = 0;
        do {
            this.options.sleep();
            this.logger.debug("poll try #{}", count + 1);
        } while (!(sv = (dtm = this.evaluate(expression, null)).getResult()).isBooleanTrue() && count++ < max);
    }

    @Override
    public Object eval(String expression) {
        return this.evaluate(expression, null).getResult().getValue();
    }

    @Override
    public String getTitle() {
        DevToolsMessage dtm = this.evaluate("document.title", null);
        return dtm.getResult().getAsString();
    }

    @Override
    public String getLocation() {
        return this.currentUrl;
    }

    @Override
    public List<Map> getCookies() {
        DevToolsMessage dtm = this.method("Network.getAllCookies").send();
        return dtm.getResult("cookies").getAsList();
    }

    @Override
    public Map<String, Object> cookie(String name) {
        List<Map> list = this.getCookies();
        if (list == null) {
            return null;
        }
        for (Map map : list) {
            if (map == null || !name.equals(map.get("name"))) continue;
            return map;
        }
        return null;
    }

    @Override
    public void setCookie(Map<String, Object> cookie) {
        if (cookie.get("url") == null && cookie.get("domain") == null) {
            cookie = new HashMap<String, Object>(cookie);
            cookie.put("url", this.currentUrl);
        }
        this.method("Network.setCookie").params(cookie).send();
    }

    @Override
    public void deleteCookie(String name) {
        this.method("Network.deleteCookies").param("name", name).param("url", this.currentUrl).send();
    }

    @Override
    public void clearCookies() {
        this.method("Network.clearBrowserCookies").send();
    }

    @Override
    public void dialog(boolean accept) {
        this.dialog(accept, null);
    }

    @Override
    public void dialog(boolean accept, String text) {
        DevToolsMessage temp = this.method("Page.handleJavaScriptDialog").param("accept", accept);
        if (text == null) {
            temp.send();
        } else {
            temp.param("promptText", text).send();
        }
    }

    @Override
    public String getDialog() {
        return this.currentDialogText;
    }

    public byte[] pdf(Map<String, Object> options) {
        DevToolsMessage dtm = this.method("Page.printToPDF").params(options).send();
        String temp = dtm.getResult("data").getAsString();
        return Base64.getDecoder().decode(temp);
    }

    @Override
    public byte[] screenshot() {
        return this.screenshot(null);
    }

    @Override
    public byte[] screenshot(String id) {
        DevToolsMessage dtm;
        if (id == null) {
            dtm = this.method("Page.captureScreenshot").send();
        } else {
            Map<String, Object> map = this.rect(id);
            map.put("scale", 1);
            dtm = this.method("Page.captureScreenshot").param("clip", map).send();
        }
        String temp = dtm.getResult("data").getAsString();
        return Base64.getDecoder().decode(temp);
    }

    public byte[] screenshot(boolean fullPage) {
        if (fullPage) {
            DevToolsMessage layout = this.method("Page.getLayoutMetrics").send();
            Map<String, Object> size = layout.getResult("contentSize").getAsMap();
            Map<String, Object> map = this.options.newMapWithSelectedKeys(size, "height", "width");
            map.put("x", 0);
            map.put("y", 0);
            map.put("scale", 1);
            DevToolsMessage dtm = this.method("Page.captureScreenshot").param("clip", map).send();
            String temp = dtm.getResult("data").getAsString();
            return Base64.getDecoder().decode(temp);
        }
        return this.screenshot();
    }

    @Override
    public void highlight(String id) {
        this.eval(this.options.highlighter(id));
    }

    @Override
    public void switchTo(String titleOrUrl) {
        if (titleOrUrl == null) {
            return;
        }
        titleOrUrl = this.options.removeProtocol(titleOrUrl);
        DevToolsMessage dtm = this.method("Target.getTargets").send();
        List targets = dtm.getResult("targetInfos").getAsList();
        String targetId = null;
        String targetUrl = null;
        for (Map map : targets) {
            String title = (String)map.get("title");
            String url = (String)map.get("url");
            String trimmed = this.options.removeProtocol(url);
            if (!titleOrUrl.equals(title) && !titleOrUrl.equals(trimmed)) continue;
            targetId = (String)map.get("targetId");
            targetUrl = url;
            break;
        }
        if (targetId != null) {
            this.method("Target.activateTarget").param("targetId", targetId).send();
            this.currentUrl = targetUrl;
        }
    }

    public void enableNetworkEvents() {
        this.method("Network.enable").send();
    }

    public void enablePageEvents() {
        this.method("Page.enable").send();
    }
}

