/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.cucumber;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Results;
import java.util.LinkedHashMap;
import java.util.Map;

public class KarateStats {
    private int featureCount;
    private int testCount;
    private int failCount;
    private double timeTakenMillis;
    private final long startTime;
    private long endTime;
    private Map<String, String> failedMap;
    private Throwable failureReason;
    private String reportDir;

    protected KarateStats(Results from) {
        this.featureCount = from.getFeatureCount();
        this.testCount = from.getScenarioCount();
        this.failCount = from.getFailCount();
        this.timeTakenMillis = from.getTimeTakenMillis();
        this.startTime = from.getStartTime();
        this.endTime = from.getEndTime();
        this.failedMap = from.getFailedMap();
        this.failureReason = from.getFailureReason();
        this.reportDir = from.getReportDir();
    }

    private KarateStats(long startTime) {
        this.startTime = startTime;
    }

    public void addToFailedList(String name, String errorMessage) {
        if (this.failedMap == null) {
            this.failedMap = new LinkedHashMap<String, String>();
        }
        this.failedMap.put(name, errorMessage);
    }

    public static KarateStats startTimer() {
        return new KarateStats(System.currentTimeMillis());
    }

    public String getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(String reportDir) {
        this.reportDir = reportDir;
    }

    public void setFailureReason(Throwable failureReason) {
        this.failureReason = failureReason;
    }

    public Throwable getFailureReason() {
        return this.failureReason;
    }

    public void addToTestCount(int count) {
        this.testCount += count;
    }

    public void addToFailCount(int count) {
        this.failCount += count;
    }

    public void addToTimeTaken(double time) {
        this.timeTakenMillis += time;
    }

    public void stopTimer() {
        this.endTime = System.currentTimeMillis();
    }

    public void printStats(int threadCount) {
        double elapsedTime = this.endTime - this.startTime;
        System.out.println("Karate version: " + FileUtils.getKarateVersion());
        System.out.println("====================================================");
        System.out.println(String.format("elapsed time: %.2f | total thread time: %.2f", elapsedTime / 1000.0, this.timeTakenMillis / 1000.0));
        double efficiency = this.timeTakenMillis / (elapsedTime * (double)threadCount);
        System.out.println(String.format("features: %5d | threads: %3d | efficiency: %.2f", this.featureCount, threadCount, efficiency));
        System.out.println(String.format("scenarios: %4d | passed: %4d | failed: %4d", this.testCount, this.testCount - this.failCount, this.failCount));
        System.out.println("====================================================");
        if (this.failedMap != null) {
            System.out.println("failed features:");
            this.failedMap.forEach((k, v) -> System.out.println(k + ": " + v));
        }
        if (this.failureReason != null) {
            if (this.failCount == 0) {
                this.failCount = 1;
            }
            System.out.println("*** runner exception stack trace ***");
            this.failureReason.printStackTrace();
        }
    }

    public void setFeatureCount(int featureCount) {
        this.featureCount = featureCount;
    }

    public int getFeatureCount() {
        return this.featureCount;
    }

    public int getTestCount() {
        return this.testCount;
    }

    public int getFailCount() {
        return this.failCount;
    }

    public double getTimeTakenMillis() {
        return this.timeTakenMillis;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Map<String, String> getFailedMap() {
        return this.failedMap;
    }
}

