/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.cucumber;

import com.intuit.karate.Resource;
import com.intuit.karate.Runner;
import com.intuit.karate.core.ExecutionHook;
import com.intuit.karate.core.Feature;
import com.intuit.karate.cucumber.KarateStats;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberRunner {
    private static final Logger logger = LoggerFactory.getLogger(CucumberRunner.class);

    public static KarateStats parallel(Class<?> clazz, int threadCount) {
        return CucumberRunner.parallel(clazz, threadCount, null);
    }

    public static KarateStats parallel(Class<?> clazz, int threadCount, String reportDir) {
        return new KarateStats(Runner.parallel(clazz, threadCount, reportDir));
    }

    public static KarateStats parallel(List<String> tags, List<String> paths, int threadCount, String reportDir) {
        return CucumberRunner.parallel(tags, paths, null, threadCount, reportDir);
    }

    public static KarateStats parallel(List<String> tags, List<String> paths, Collection<ExecutionHook> hooks, int threadCount, String reportDir) {
        return new KarateStats(Runner.parallel(tags, paths, null, hooks, threadCount, reportDir));
    }

    public static KarateStats parallel(String tagSelector, List<Resource> resources, int threadCount, String reportDir) {
        return CucumberRunner.parallel(tagSelector, resources, null, threadCount, reportDir);
    }

    public static KarateStats parallel(String tagSelector, List<Resource> resources, Collection<ExecutionHook> hooks, int threadCount, String reportDir) {
        return new KarateStats(Runner.parallel(tagSelector, resources, null, hooks, threadCount, reportDir));
    }

    public static Map<String, Object> runFeature(Feature feature, Map<String, Object> vars, boolean evalKarateConfig) {
        return Runner.runFeature(feature, vars, evalKarateConfig);
    }

    public static Map<String, Object> runFeature(File file, Map<String, Object> vars, boolean evalKarateConfig) {
        return Runner.runFeature(file, vars, evalKarateConfig);
    }

    public static Map<String, Object> runFeature(Class relativeTo, String path, Map<String, Object> vars, boolean evalKarateConfig) {
        return Runner.runFeature(relativeTo, path, vars, evalKarateConfig);
    }

    public static Map<String, Object> runFeature(String path, Map<String, Object> vars, boolean evalKarateConfig) {
        return Runner.runFeature(path, vars, evalKarateConfig);
    }

    public static Map<String, Object> runClasspathFeature(String feature, Map<String, Object> vars, boolean evalKarateConfig) {
        return Runner.runFeature("classpath:" + feature, vars, evalKarateConfig);
    }
}

