/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.StringUtils;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepResult;
import com.intuit.karate.core.Tags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScenarioResult {
    private List<StepResult> stepResults = new ArrayList<StepResult>();
    private final Scenario scenario;
    private StepResult failedStep;
    private String threadName;
    private long startTime;
    private long endTime;
    private long durationNanos;

    public void reset() {
        this.stepResults = new ArrayList<StepResult>();
        this.failedStep = null;
    }

    public StepResult getStepResult(int index) {
        if (this.stepResults.size() > index) {
            return this.stepResults.get(index);
        }
        return null;
    }

    public void setStepResult(int index, StepResult sr) {
        if (sr.getResult().isFailed()) {
            this.failedStep = sr;
        }
        if (this.stepResults.size() > index) {
            this.stepResults.set(index, sr);
        } else {
            for (int i = this.stepResults.size(); i < index; ++i) {
                this.stepResults.add(null);
            }
            this.stepResults.add(sr);
        }
    }

    public String getFailureMessageForDisplay() {
        if (this.failedStep == null) {
            return null;
        }
        Step step = this.failedStep.getStep();
        String featureName = this.scenario.getFeature().getResource().getRelativePath();
        return featureName + ":" + step.getLine() + " " + step.getText();
    }

    public void addError(String message, Throwable error) {
        Step step = new Step(this.scenario.getFeature(), this.scenario, -1);
        step.setLine(this.scenario.getLine());
        step.setPrefix("*");
        step.setText(message);
        StepResult sr = new StepResult(false, step, Result.failed(0L, error, step), null, null, null);
        this.addStepResult(sr);
    }

    public void addStepResult(StepResult stepResult) {
        this.stepResults.add(stepResult);
        Result result = stepResult.getResult();
        this.durationNanos += result.getDurationNanos();
        if (result.isFailed()) {
            this.failedStep = stepResult;
        }
    }

    private static void recurse(List<Map> list, StepResult stepResult, int depth) {
        if (stepResult.getCallResults() != null) {
            for (FeatureResult fr : stepResult.getCallResults()) {
                Step call = new Step(stepResult.getStep().getFeature(), stepResult.getStep().getScenario(), -1);
                call.setLine(stepResult.getStep().getLine());
                call.setPrefix(StringUtils.repeat('>', depth));
                call.setText(fr.getCallName());
                call.setDocString(fr.getCallArgPretty());
                StepResult callResult = new StepResult(stepResult.isHidden(), call, Result.passed(0L), null, null, null);
                list.add(callResult.toMap());
                for (StepResult sr : fr.getStepResults()) {
                    if (sr.isHidden()) continue;
                    Map<String, Object> map = sr.toMap();
                    String temp = (String)map.get("keyword");
                    map.put("keyword", StringUtils.repeat('>', depth + 1) + ' ' + temp);
                    list.add(map);
                    ScenarioResult.recurse(list, sr, depth + 1);
                }
            }
        }
    }

    private List<Map> getStepResults(boolean background) {
        ArrayList<Map> list = new ArrayList<Map>(this.stepResults.size());
        for (StepResult stepResult : this.stepResults) {
            if (stepResult.isHidden() || background != stepResult.getStep().isBackground()) continue;
            list.add(stepResult.toMap());
            ScenarioResult.recurse(list, stepResult, 0);
        }
        return list;
    }

    public Map<String, Object> backgroundToMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", "");
        map.put("steps", this.getStepResults(true));
        map.put("line", this.scenario.getFeature().getBackground().getLine());
        map.put("description", "");
        map.put("type", "background");
        map.put("keyword", "Background");
        return map;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.scenario.getName());
        map.put("steps", this.getStepResults(false));
        map.put("line", this.scenario.getLine());
        map.put("id", StringUtils.toIdString(this.scenario.getName()));
        map.put("description", this.scenario.getDescription());
        map.put("type", "scenario");
        map.put("keyword", this.scenario.getKeyword());
        if (this.scenario.getTags() != null) {
            map.put("tags", Tags.toResultList(this.scenario.getTags()));
        }
        return map;
    }

    public ScenarioResult(Scenario scenario, List<StepResult> stepResults) {
        this.scenario = scenario;
        if (stepResults != null) {
            this.stepResults.addAll(stepResults);
        }
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public List<StepResult> getStepResults() {
        return this.stepResults;
    }

    public boolean isFailed() {
        return this.failedStep != null;
    }

    public StepResult getFailedStep() {
        return this.failedStep;
    }

    public Throwable getError() {
        return this.failedStep == null ? null : this.failedStep.getResult().getError();
    }

    public long getDurationNanos() {
        return this.durationNanos;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }
}

