/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.LogAppender;
import com.intuit.karate.Logger;
import com.intuit.karate.StepActions;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Embed;
import com.intuit.karate.core.Engine;
import com.intuit.karate.core.ExecutionContext;
import com.intuit.karate.core.ExecutionHook;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.core.ScenarioInfo;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScenarioExecutionUnit
implements Runnable {
    public final Scenario scenario;
    private final ExecutionContext exec;
    public final ScenarioResult result;
    private final LogAppender appender;
    public final Logger logger;
    private boolean executed = false;
    private List<Step> steps;
    private StepActions actions;
    private boolean stopped = false;
    private StepResult lastStepResult;
    private Runnable next;
    private boolean last;
    private static final Map<String, Integer> FILE_HANDLE_COUNT = new HashMap<String, Integer>();

    public ScenarioExecutionUnit(Scenario scenario, List<StepResult> results, ExecutionContext exec, Logger logger) {
        this(scenario, results, exec, null, logger);
    }

    public ScenarioExecutionUnit(Scenario scenario, List<StepResult> results, ExecutionContext exec, ScenarioContext backgroundContext, Logger logger) {
        this.scenario = scenario;
        this.exec = exec;
        this.result = new ScenarioResult(scenario, results);
        if (logger == null) {
            logger = new Logger();
            if (scenario.getIndex() < 500) {
                if (exec.callContext.isCalled()) {
                    String featureName = exec.featureContext.packageQualifiedName;
                    Integer count = FILE_HANDLE_COUNT.get(featureName);
                    if (count == null) {
                        count = 0;
                    }
                    count = count + 1;
                    FILE_HANDLE_COUNT.put(featureName, count);
                    this.appender = count < 500 ? exec.getLogAppender(scenario.getUniqueId() + "_" + Thread.currentThread().getName(), logger) : LogAppender.NO_OP;
                } else {
                    this.appender = exec.getLogAppender(scenario.getUniqueId(), logger);
                }
            } else {
                this.appender = LogAppender.NO_OP;
            }
        } else {
            this.appender = LogAppender.NO_OP;
        }
        this.logger = logger;
        if (backgroundContext != null) {
            ScenarioInfo info = scenario.toInfo(exec.featureContext.feature.getPath());
            ScenarioContext context = backgroundContext.copy(info, logger);
            this.actions = new StepActions(context);
        }
    }

    public ScenarioContext getContext() {
        return this.actions == null ? null : this.actions.context;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public StepActions getActions() {
        return this.actions;
    }

    public void setActions(StepActions actions) {
        this.actions = actions;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setNext(Runnable next) {
        this.next = next;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public boolean isLast() {
        return this.last;
    }

    public void init() {
        boolean initFailed = false;
        if (this.actions == null) {
            try {
                this.actions = new StepActions(this.exec.featureContext, this.exec.callContext, this.scenario, this.logger);
            }
            catch (Exception e) {
                initFailed = true;
                this.result.addError("scenario init failed", e);
            }
        }
        ScenarioContext context = this.actions.context;
        if (!initFailed && context.executionHooks != null) {
            try {
                for (ExecutionHook h : context.executionHooks) {
                    h.beforeScenario(this.scenario, context);
                }
            }
            catch (Exception e) {
                initFailed = true;
                this.result.addError("beforeScenario hook failed", e);
            }
        }
        if (initFailed) {
            this.steps = Collections.EMPTY_LIST;
        } else if (this.scenario.isDynamic()) {
            this.steps = this.scenario.getBackgroundSteps();
        } else {
            this.steps = this.scenario.isBackgroundDone() ? this.scenario.getSteps() : this.scenario.getStepsIncludingBackground();
            if (this.scenario.isOutline()) {
                Map<String, Object> exampleData = this.scenario.getExampleData();
                context.vars.put("__row", exampleData);
                context.vars.put("__num", (Object)this.scenario.getExampleIndex());
                if (context.getConfig().isOutlineVariablesAuto()) {
                    exampleData.forEach((k, v) -> context.vars.put((String)k, v));
                }
            }
        }
        this.result.setThreadName(Thread.currentThread().getName());
        this.result.setStartTime(System.currentTimeMillis() - this.exec.startTime);
    }

    public void reset(ScenarioContext context) {
        this.setExecuted(false);
        this.result.reset();
        this.actions = new StepActions(context);
    }

    public StepResult execute(Step step) {
        boolean hidden;
        boolean bl = hidden = step.isPrefixStar() && !step.isPrint() && !this.actions.context.getConfig().isShowAllSteps();
        if (this.stopped) {
            return new StepResult(hidden, step, Result.skipped(), null, null, null);
        }
        Result execResult = Engine.executeStep(step, this.actions);
        List<FeatureResult> callResults = this.actions.context.getAndClearCallResults();
        Embed embed = this.actions.context.getAndClearEmbed();
        if (execResult.isAborted()) {
            this.actions.context.logger.debug("abort at {}", step.getDebugInfo());
        } else if (execResult.isFailed()) {
            this.actions.context.setScenarioError(execResult.getError());
        }
        String stepLog = StringUtils.trimToNull(this.appender.collect());
        boolean showLog = this.actions.context.getConfig().isShowLog();
        return new StepResult(hidden, step, execResult, showLog ? stepLog : null, embed, callResults);
    }

    public void stop() {
        this.result.setEndTime(System.currentTimeMillis() - this.exec.startTime);
        if (this.actions != null) {
            this.actions.context.logLastPerfEvent(this.result.getFailureMessageForDisplay());
            this.actions.context.invokeAfterHookIfConfigured(false);
            if (this.actions.context.executionHooks != null) {
                this.actions.context.executionHooks.forEach(h -> h.afterScenario(this.result, this.actions.context));
            }
            this.actions.context.stop();
        }
        if (this.lastStepResult != null) {
            String stepLog = StringUtils.trimToNull(this.appender.collect());
            this.lastStepResult.appendToStepLog(stepLog);
        }
        this.appender.close();
    }

    @Override
    public void run() {
        if (this.steps == null) {
            this.init();
        }
        for (Step step : this.steps) {
            this.lastStepResult = this.execute(step);
            this.result.addStepResult(this.lastStepResult);
            if (!this.lastStepResult.isStopped()) continue;
            this.stopped = true;
        }
        this.stop();
        if (this.next != null) {
            this.next.run();
        }
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public void setExecuted(boolean executed) {
        this.executed = executed;
    }
}

