/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.AssertionResult;
import com.intuit.karate.AssignType;
import com.intuit.karate.CallContext;
import com.intuit.karate.Config;
import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.Logger;
import com.intuit.karate.Script;
import com.intuit.karate.ScriptBindings;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.ScriptValueMap;
import com.intuit.karate.StringUtils;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.core.Embed;
import com.intuit.karate.core.ExecutionHook;
import com.intuit.karate.core.FeatureContext;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.MatchType;
import com.intuit.karate.core.PerfEvent;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioInfo;
import com.intuit.karate.core.Tags;
import com.intuit.karate.driver.Driver;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.exception.KarateException;
import com.intuit.karate.exception.KarateFileNotFoundException;
import com.intuit.karate.http.Cookie;
import com.intuit.karate.http.HttpClient;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpRequestBuilder;
import com.intuit.karate.http.HttpResponse;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.MultiPartItem;
import com.intuit.karate.netty.WebSocketClient;
import com.intuit.karate.netty.WebSocketOptions;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ScenarioContext {
    public final Logger logger;
    public final ScriptBindings bindings;
    public final int callDepth;
    public final boolean reuseParentContext;
    public final ScenarioContext parentContext;
    public final List<String> tags;
    public final Map<String, List<String>> tagValues;
    public final ScriptValueMap vars;
    public final FeatureContext rootFeatureContext;
    public final FeatureContext featureContext;
    public final Collection<ExecutionHook> executionHooks;
    public final boolean perfMode;
    public final ScenarioInfo scenarioInfo;
    public final Function<String, Object> read = s -> {
        ScriptValue sv = FileUtils.readFile(s, this);
        if (sv.isXml()) {
            return sv.getValue();
        }
        return sv.getAfterConvertingFromJsonOrXmlIfNeeded();
    };
    private Config config;
    private HttpClient client;
    private Driver driver;
    private HttpRequestBuilder request = new HttpRequestBuilder();
    private HttpRequest prevRequest;
    private HttpResponse prevResponse;
    private List<FeatureResult> callResults;
    private PerfEvent prevPerfEvent;
    protected Embed prevEmbed;
    private Function<CallContext, FeatureResult> callable;
    private final Object LOCK = new Object();
    private Object signalResult;
    private List<WebSocketClient> webSocketClients;

    public void logLastPerfEvent(String failureMessage) {
        if (this.prevPerfEvent != null && this.executionHooks != null) {
            if (failureMessage != null) {
                this.prevPerfEvent.setFailed(true);
                this.prevPerfEvent.setMessage(failureMessage);
            }
            this.executionHooks.forEach(h -> h.reportPerfEvent(this.prevPerfEvent));
        }
        this.prevPerfEvent = null;
    }

    public void capturePerfEvent(PerfEvent event) {
        this.logLastPerfEvent(null);
        this.prevPerfEvent = event;
    }

    public List<FeatureResult> getAndClearCallResults() {
        List<FeatureResult> temp = this.callResults;
        this.callResults = null;
        return temp;
    }

    public void addCallResult(FeatureResult callResult) {
        if (this.callResults == null) {
            this.callResults = new ArrayList<FeatureResult>();
        }
        this.callResults.add(callResult);
    }

    public void setScenarioError(Throwable error) {
        this.scenarioInfo.setErrorMessage(error.getMessage());
    }

    public void setPrevRequest(HttpRequest prevRequest) {
        this.prevRequest = prevRequest;
    }

    public void setPrevResponse(HttpResponse prevResponse) {
        this.prevResponse = prevResponse;
    }

    public HttpRequestBuilder getRequest() {
        return this.request;
    }

    public HttpRequest getPrevRequest() {
        return this.prevRequest;
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public int getCallDepth() {
        return this.callDepth;
    }

    public FeatureContext getFeatureContext() {
        return this.featureContext;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setCallable(Function<CallContext, FeatureResult> callable) {
        this.callable = callable;
    }

    public Function<CallContext, FeatureResult> getCallable() {
        return this.callable;
    }

    public void updateConfigCookies(Map<String, Cookie> cookies) {
        if (cookies == null) {
            return;
        }
        if (this.config.getCookies().isNull()) {
            this.config.setCookies(new ScriptValue(cookies));
        } else {
            Map<String, Object> map = this.config.getCookies().evalAsMap(this);
            map.putAll(cookies);
            this.config.setCookies(new ScriptValue(map));
        }
    }

    public boolean isPrintEnabled() {
        return this.config.isPrintEnabled();
    }

    public ScenarioContext(FeatureContext featureContext, CallContext call, Scenario scenario, Logger logger) {
        this.featureContext = featureContext;
        if (logger == null) {
            logger = new Logger();
        }
        this.logger = logger;
        this.callDepth = call.callDepth;
        this.reuseParentContext = call.reuseParentContext;
        this.executionHooks = call.executionHooks;
        this.perfMode = call.perfMode;
        if (scenario != null) {
            Tags tagsEffective = scenario.getTagsEffective();
            this.tags = tagsEffective.getTags();
            this.tagValues = tagsEffective.getTagValues();
            this.scenarioInfo = scenario.toInfo(featureContext.feature.getPath());
        } else {
            this.tags = null;
            this.tagValues = null;
            this.scenarioInfo = null;
        }
        if (this.reuseParentContext) {
            this.parentContext = call.context;
            this.vars = call.context.vars;
            this.config = call.context.config;
            this.rootFeatureContext = call.context.rootFeatureContext;
            this.driver = call.context.driver;
            this.webSocketClients = call.context.webSocketClients;
        } else if (call.context != null) {
            this.parentContext = call.context;
            this.vars = call.context.vars.copy(false);
            this.config = new Config(call.context.config);
            this.rootFeatureContext = call.context.rootFeatureContext;
        } else {
            this.parentContext = null;
            this.vars = new ScriptValueMap();
            this.config = new Config();
            this.config.setClientClass(call.httpClientClass);
            this.rootFeatureContext = featureContext;
        }
        this.client = HttpClient.construct(this.config, this);
        this.bindings = new ScriptBindings(this);
        if (call.context == null && call.evalKarateConfig) {
            try {
                Script.callAndUpdateConfigAndAlsoVarsIfMapReturned(false, ScriptBindings.READ_KARATE_CONFIG_BASE, null, this);
            }
            catch (Exception e) {
                if (e instanceof KarateFileNotFoundException) {
                    logger.trace("skipping 'classpath:karate-base.js': {}", e.getMessage());
                }
                throw new RuntimeException("evaluation of 'classpath:karate-base.js' failed", e);
            }
            String configDir = System.getProperty("karate.config.dir");
            String configScript = ScriptBindings.readKarateConfigForEnv(true, configDir, null);
            try {
                Script.callAndUpdateConfigAndAlsoVarsIfMapReturned(false, configScript, null, this);
            }
            catch (Exception e) {
                if (e instanceof KarateFileNotFoundException) {
                    logger.warn("skipping bootstrap configuration: {}", e.getMessage());
                }
                String message = "evaluation of 'karate-config.js' failed: " + e.getMessage();
                logger.error("{}", message);
                throw new RuntimeException(message, e);
            }
            if (featureContext.env != null) {
                configScript = ScriptBindings.readKarateConfigForEnv(false, configDir, featureContext.env);
                try {
                    Script.callAndUpdateConfigAndAlsoVarsIfMapReturned(false, configScript, null, this);
                }
                catch (Exception e) {
                    if (e instanceof KarateFileNotFoundException) {
                        logger.trace("skipping bootstrap configuration for env: {} - {}", featureContext.env, e.getMessage());
                    }
                    throw new RuntimeException("evaluation of 'karate-config-" + featureContext.env + ".js' failed", e);
                }
            }
        }
        if (call.callArg != null) {
            call.callArg.forEach((k, v) -> this.vars.put((String)k, v));
            this.vars.put("__arg", call.callArg);
            this.vars.put("__loop", (Object)call.loopIndex);
        } else if (call.context != null) {
            this.vars.put("__arg", ScriptValue.NULL);
            this.vars.put("__loop", (Object)-1);
        }
        logger.trace("karate context init - initial properties: {}", this.vars);
    }

    public ScenarioContext copy(ScenarioInfo info, Logger logger) {
        return new ScenarioContext(this, info, logger);
    }

    public ScenarioContext copy() {
        return new ScenarioContext(this, this.scenarioInfo, this.logger);
    }

    private ScenarioContext(ScenarioContext sc, ScenarioInfo info, Logger logger) {
        this.featureContext = sc.featureContext;
        this.logger = logger;
        this.callDepth = sc.callDepth;
        this.reuseParentContext = sc.reuseParentContext;
        this.parentContext = sc.parentContext;
        this.executionHooks = sc.executionHooks;
        this.perfMode = sc.perfMode;
        this.tags = sc.tags;
        this.tagValues = sc.tagValues;
        this.scenarioInfo = info;
        this.vars = sc.vars.copy(true);
        this.config = new Config(sc.config);
        this.rootFeatureContext = sc.rootFeatureContext;
        this.client = HttpClient.construct(this.config, this);
        this.bindings = new ScriptBindings(this);
        this.request = sc.request.copy();
        this.driver = sc.driver;
        this.prevRequest = sc.prevRequest;
        this.prevResponse = sc.prevResponse;
        this.prevPerfEvent = sc.prevPerfEvent;
        this.callResults = sc.callResults;
        this.webSocketClients = sc.webSocketClients;
        this.signalResult = sc.signalResult;
    }

    public void configure(Config config) {
        this.config = config;
        this.client = HttpClient.construct(config, this);
    }

    public void configure(String key, ScriptValue value) {
        if (this.config.configure(key = StringUtils.trimToEmpty(key), value)) {
            if (key.startsWith("httpClient")) {
                this.client = HttpClient.construct(this.config, this);
            } else {
                this.client.configure(this.config, this);
            }
        }
    }

    private List<String> evalList(List<String> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        try {
            for (String value : values) {
                ScriptValue temp = Script.evalKarateExpression(value, this);
                list.add(temp.getAsString());
            }
        }
        catch (Exception e) {
            String joined = StringUtils.join(values, ',');
            ScriptValue temp = Script.evalKarateExpression(joined, this);
            if (temp.isListLike()) {
                return temp.getAsList();
            }
            return Collections.singletonList(temp.getAsString());
        }
        return list;
    }

    private Map<String, Object> evalMapExpr(String expr) {
        ScriptValue value = Script.evalKarateExpression(expr, this);
        if (!value.isMapLike()) {
            throw new KarateException("cannot convert to map: " + expr);
        }
        return value.getAsMap();
    }

    private String getVarAsString(String name) {
        ScriptValue sv = (ScriptValue)this.vars.get(name);
        if (sv == null) {
            throw new RuntimeException("no variable found with name: " + name);
        }
        return sv.getAsString();
    }

    private static String asString(Map<String, Object> map, String key) {
        Object o = map.get(key);
        return o == null ? null : o.toString();
    }

    public void updateResponseVars() {
        this.vars.put("responseStatus", (Object)this.prevResponse.getStatus());
        this.vars.put("requestTimeStamp", (Object)this.prevResponse.getStartTime());
        this.vars.put("responseTime", (Object)this.prevResponse.getResponseTime());
        this.vars.put("responseCookies", this.prevResponse.getCookies());
        if (this.config.isLowerCaseResponseHeaders()) {
            Object temp = new ScriptValue(this.prevResponse.getHeaders()).toLowerCase();
            this.vars.put("responseHeaders", temp);
        } else {
            this.vars.put("responseHeaders", this.prevResponse.getHeaders());
        }
        byte[] responseBytes = this.prevResponse.getBody();
        this.bindings.putAdditionalVariable("responseBytes", responseBytes);
        String responseString = FileUtils.toString(responseBytes);
        Object responseBody = responseString;
        responseString = StringUtils.trimToEmpty(responseString);
        if (Script.isJson(responseString)) {
            try {
                responseBody = JsonUtils.toJsonDoc(responseString);
            }
            catch (Exception e) {
                this.logger.warn("json parsing failed, response data type set to string: {}", e.getMessage());
            }
        } else if (Script.isXml(responseString)) {
            try {
                responseBody = XmlUtils.toXmlDoc(responseString);
            }
            catch (Exception e) {
                this.logger.warn("xml parsing failed, response data type set to string: {}", e.getMessage());
            }
        }
        this.vars.put("response", responseBody);
    }

    public void invokeAfterHookIfConfigured(boolean afterFeature) {
        ScriptValue sv;
        if (this.callDepth > 0) {
            return;
        }
        ScriptValue scriptValue = sv = afterFeature ? this.config.getAfterFeature() : this.config.getAfterScenario();
        if (sv.isFunction()) {
            try {
                sv.invokeFunction(this, null);
            }
            catch (Exception e) {
                String prefix = afterFeature ? "afterFeature" : "afterScenario";
                this.logger.warn("{} hook failed: {}", prefix, e.getMessage());
            }
        }
    }

    public void configure(String key, String exp) {
        this.configure(key, Script.evalKarateExpression(exp, this));
    }

    public void url(String expression) {
        String temp = Script.evalKarateExpression(expression, this).getAsString();
        this.request.setUrl(temp);
    }

    public void path(List<String> paths) {
        for (String path : paths) {
            ScriptValue temp = Script.evalKarateExpression(path, this);
            if (temp.isListLike()) {
                List list = temp.getAsList();
                for (Object o : list) {
                    if (o == null) continue;
                    this.request.addPath(o.toString());
                }
                continue;
            }
            this.request.addPath(temp.getAsString());
        }
    }

    public void param(String name, List<String> values) {
        this.request.setParam(name, this.evalList(values));
    }

    public void params(String expr) {
        Map<String, Object> map = this.evalMapExpr(expr);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object temp = entry.getValue();
            if (temp == null) {
                this.request.removeParam(key);
                continue;
            }
            if (temp instanceof List) {
                this.request.setParam(key, (List)temp);
                continue;
            }
            this.request.setParam(key, temp.toString());
        }
    }

    public void cookie(String name, String value) {
        Cookie cookie;
        ScriptValue sv = Script.evalKarateExpression(value, this);
        if (sv.isMapLike()) {
            cookie = new Cookie((Map<String, String>)sv.getAsMap());
            cookie.put("name", name);
        } else {
            cookie = new Cookie(name, sv.getAsString());
        }
        this.request.setCookie(cookie);
    }

    public void cookies(String expr) {
        Map<String, Object> map = this.evalMapExpr(expr);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object temp = entry.getValue();
            if (temp == null) {
                this.request.removeCookie(key);
                continue;
            }
            this.request.setCookie(new Cookie(key, temp.toString()));
        }
    }

    public void header(String name, List<String> values) {
        this.request.setHeader(name, this.evalList(values));
    }

    public void headers(String expr) {
        Map<String, Object> map = this.evalMapExpr(expr);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object temp = entry.getValue();
            if (temp == null) {
                this.request.removeHeader(key);
                continue;
            }
            if (temp instanceof List) {
                this.request.setHeader(key, (List)temp);
                continue;
            }
            this.request.setHeader(key, temp.toString());
        }
    }

    public void formField(String name, List<String> values) {
        this.request.setFormField(name, this.evalList(values));
    }

    public void formFields(String expr) {
        Map<String, Object> map = this.evalMapExpr(expr);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object temp = entry.getValue();
            if (temp == null) {
                this.request.removeFormField(key);
                continue;
            }
            if (temp instanceof List) {
                this.request.setFormField(key, (List)temp);
                continue;
            }
            this.request.setFormField(key, temp.toString());
        }
    }

    public void request(ScriptValue body) {
        this.request.setBody(body);
    }

    public void request(String requestBody) {
        ScriptValue temp = Script.evalKarateExpression(requestBody, this);
        this.request(temp);
    }

    public void table(String name, List<Map<String, String>> table) {
        int pos = name.indexOf(61);
        if (pos != -1) {
            name = name.substring(0, pos);
        }
        List<Map<String, Object>> list = Script.evalTable(table, this);
        DocumentContext doc = JsonPath.parse(list);
        this.vars.put(name.trim(), doc);
    }

    public void replace(String name, List<Map<String, String>> table) {
        name = name.trim();
        String text = this.getVarAsString(name);
        String replaced = Script.replacePlaceholders(text, table, this);
        this.vars.put(name, replaced);
    }

    public void replace(String name, String token, String value) {
        name = name.trim();
        String text = this.getVarAsString(name);
        String replaced = Script.replacePlaceholderText(text, token, value, this);
        this.vars.put(name, replaced);
    }

    public void assign(AssignType assignType, String name, String exp) {
        Script.assign(assignType, name, exp, this, true);
    }

    public void assertTrue(String expression) {
        AssertionResult ar = Script.assertBoolean(expression, this);
        if (!ar.pass) {
            this.logger.error("{}", ar);
            throw new KarateException(ar.message);
        }
    }

    private void clientInvoke() {
        try {
            this.prevResponse = this.client.invoke(this.request, this);
            this.updateResponseVars();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.logger.error("http request failed: {}", message);
            throw new KarateException(message);
        }
    }

    private void clientInvokeWithRetries() {
        int maxRetries = this.config.getRetryCount();
        int sleep = this.config.getRetryInterval();
        int retryCount = 0;
        while (true) {
            ScriptValue sv;
            if (retryCount == maxRetries) {
                throw new KarateException("too many retry attempts: " + maxRetries);
            }
            if (retryCount > 0) {
                try {
                    this.logger.debug("sleeping before retry #{}", retryCount);
                    Thread.sleep(sleep);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.clientInvoke();
            try {
                sv = Script.evalKarateExpression(this.request.getRetryUntil(), this);
            }
            catch (Exception e) {
                this.logger.warn("retry condition evaluation failed: {}", e.getMessage());
                sv = ScriptValue.NULL;
            }
            if (sv.isBooleanTrue()) {
                if (retryCount <= 0) break;
                this.logger.debug("retry condition satisfied", new Object[0]);
                break;
            }
            this.logger.debug("retry condition not satisfied: {}", this.request.getRetryUntil());
            ++retryCount;
        }
    }

    public void method(String method) {
        if (!HttpUtils.HTTP_METHODS.contains(method.toUpperCase())) {
            method = Script.evalKarateExpression(method, this).getAsString();
        }
        this.request.setMethod(method);
        if (this.request.isRetry()) {
            this.clientInvokeWithRetries();
        } else {
            this.clientInvoke();
        }
        String prevUrl = this.request.getUrl();
        this.request = new HttpRequestBuilder();
        this.request.setUrl(prevUrl);
    }

    public void retry(String expression) {
        this.request.setRetryUntil(expression);
    }

    public void soapAction(String action) {
        if ((action = Script.evalKarateExpression(action, this).getAsString()) == null) {
            action = "";
        }
        this.request.setHeader("SOAPAction", action);
        this.request.setHeader("Content-Type", "text/xml");
        this.method("post");
    }

    public void multipartField(String name, String value) {
        ScriptValue sv = Script.evalKarateExpression(value, this);
        this.request.addMultiPartItem(name, sv);
    }

    public void multipartFields(String expr) {
        Map<String, Object> map = this.evalMapExpr(expr);
        map.forEach((k, v) -> {
            ScriptValue sv = new ScriptValue(v);
            this.request.addMultiPartItem((String)k, sv);
        });
    }

    public void multipartFile(String name, String value) {
        Object o;
        name = name.trim();
        ScriptValue sv = Script.evalKarateExpression(value, this);
        if (!sv.isMapLike()) {
            throw new RuntimeException("mutipart file value should be json");
        }
        Map<String, Object> map = sv.getAsMap();
        String read = ScenarioContext.asString(map, "read");
        ScriptValue fileValue = read == null ? ((o = map.get("value")) == null ? null : new ScriptValue(o)) : FileUtils.readFile(read, this);
        if (fileValue == null) {
            throw new RuntimeException("mutipart file json should have a value for 'read' or 'value'");
        }
        MultiPartItem item = new MultiPartItem(name, fileValue);
        String filename = ScenarioContext.asString(map, "filename");
        if (filename == null) {
            filename = name;
        }
        item.setFilename(filename);
        String contentType = ScenarioContext.asString(map, "contentType");
        if (contentType != null) {
            item.setContentType(contentType);
        }
        this.request.addMultiPartItem(item);
    }

    public void multipartFiles(String expr) {
        Map<String, Object> map = this.evalMapExpr(expr);
        map.forEach((k, v) -> {
            ScriptValue sv = new ScriptValue(v);
            this.multipartFile((String)k, sv.getAsString());
        });
    }

    public void print(List<String> exps) {
        if (this.isPrintEnabled()) {
            String prev = "";
            StringBuilder sb = new StringBuilder();
            sb.append("[print]");
            for (String exp : exps) {
                if (!prev.isEmpty()) {
                    exp = prev + StringUtils.trimToNull(exp);
                }
                if (exp == null) {
                    sb.append("null");
                    continue;
                }
                ScriptValue sv = Script.getIfVariableReference(exp, this);
                if (sv == null) {
                    try {
                        sv = Script.evalJsExpression(exp, this);
                        prev = "";
                    }
                    catch (Exception e) {
                        prev = exp + ", ";
                        continue;
                    }
                }
                sb.append(' ').append(sv.getAsPrettyString());
            }
            this.logger.info("{}", sb);
        }
    }

    public void status(int status) {
        if (status != this.prevResponse.getStatus()) {
            String rawResponse = ((ScriptValue)this.vars.get("response")).getAsString();
            String responseTime = ((ScriptValue)this.vars.get("responseTime")).getAsString();
            String message = "status code was: " + this.prevResponse.getStatus() + ", expected: " + status + ", response time: " + responseTime + ", url: " + this.prevResponse.getUri() + ", response: " + rawResponse;
            this.logger.error(message, new Object[0]);
            throw new KarateException(message);
        }
    }

    public void match(MatchType matchType, String name, String path, String expected) {
        AssertionResult ar = Script.matchNamed(matchType, name, path, expected, this);
        if (!ar.pass) {
            this.logger.error("{}", ar);
            throw new KarateException(ar.message);
        }
    }

    public void set(String name, String path, String value) {
        Script.setValueByPath(name, path, value, this);
    }

    public void set(String name, String path, List<Map<String, String>> table) {
        Script.setByPathTable(name, path, table, this);
    }

    public void remove(String name, String path) {
        Script.removeValueByPath(name, path, this);
    }

    public void call(boolean callonce, String name, String arg) {
        Script.callAndUpdateConfigAndAlsoVarsIfMapReturned(callonce, name, arg, this);
    }

    public void eval(String exp) {
        Script.evalJsExpression(exp, this);
    }

    public Embed getAndClearEmbed() {
        Embed temp = this.prevEmbed;
        this.prevEmbed = null;
        return temp;
    }

    public void embed(byte[] bytes, String contentType) {
        Embed embed = new Embed();
        embed.setBytes(bytes);
        embed.setMimeType(contentType);
        this.prevEmbed = embed;
    }

    public WebSocketClient webSocket(WebSocketOptions options) {
        WebSocketClient webSocketClient = new WebSocketClient(options);
        if (this.webSocketClients == null) {
            this.webSocketClients = new ArrayList<WebSocketClient>();
        }
        this.webSocketClients.add(webSocketClient);
        return webSocketClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal(Object result) {
        this.logger.trace("signal called: {}", result);
        Object object = this.LOCK;
        synchronized (object) {
            this.signalResult = result;
            this.LOCK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object listen(long timeout, Runnable runnable) {
        if (runnable != null) {
            this.logger.trace("submitting listen function", new Object[0]);
            new Thread(runnable).start();
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.signalResult != null) {
                this.logger.debug("signal arrived early ! result: {}", this.signalResult);
                Object temp = this.signalResult;
                this.signalResult = null;
                return temp;
            }
            try {
                this.logger.trace("entered listen wait state", new Object[0]);
                this.LOCK.wait(timeout);
                this.logger.trace("exit listen wait state, result: {}", this.signalResult);
            }
            catch (InterruptedException e) {
                this.logger.error("listen timed out: {}", e.getMessage());
            }
            Object temp = this.signalResult;
            this.signalResult = null;
            return temp;
        }
    }

    private void setDriver(Driver driver) {
        this.driver = driver;
        this.bindings.putAdditionalVariable("driver", driver);
    }

    public void driver(String expression) {
        ScriptValue sv = Script.evalKarateExpression(expression, this);
        if (this.driver == null) {
            Map<String, Object> options = this.config.getDriverOptions();
            if (options == null) {
                options = new HashMap<String, Object>();
            }
            if (sv.isMapLike()) {
                options.putAll(sv.getAsMap());
            }
            this.setDriver(DriverOptions.start(this, options, this.logger));
        }
        if (sv.isString()) {
            this.driver.setLocation(sv.getAsString());
        }
    }

    public void driverDot(String expression) {
        this.eval("driver." + expression);
    }

    public void stop() {
        if (this.reuseParentContext) {
            if (this.driver != null) {
                this.parentContext.setDriver(this.driver);
            }
            this.parentContext.webSocketClients = this.webSocketClients;
            return;
        }
        if (this.webSocketClients != null) {
            this.webSocketClients.forEach(WebSocketClient::close);
        }
        if (this.driver != null) {
            this.driver.quit();
            this.driver = null;
        }
    }
}

