/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Resource;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Background;
import com.intuit.karate.core.ExamplesTable;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureSection;
import com.intuit.karate.core.KarateLexer;
import com.intuit.karate.core.KarateParser;
import com.intuit.karate.core.KarateParserBaseListener;
import com.intuit.karate.core.ParserErrorListener;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioOutline;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.Table;
import com.intuit.karate.core.Tag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.antlr.karate.runtime.CharStream;
import org.antlr.karate.runtime.CharStreams;
import org.antlr.karate.runtime.CommonTokenStream;
import org.antlr.karate.runtime.tree.ParseTreeWalker;
import org.antlr.karate.runtime.tree.TerminalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureParser
extends KarateParserBaseListener {
    private static final Logger logger = LoggerFactory.getLogger(FeatureParser.class);
    private final ParserErrorListener errorListener = new ParserErrorListener();
    private final Feature feature;
    static final List<String> prefix = Arrays.asList("*", "Given", "When", "Then", "And", "But");
    private static final String TRIPLE_QUOTES = "\"\"\"";

    public static Feature parse(File file) {
        Resource resource = new Resource(file, file.getPath());
        return new FeatureParser((Resource)resource).feature;
    }

    public static Feature parse(Resource resource) {
        return new FeatureParser((Resource)resource).feature;
    }

    public static Feature parse(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Path file = FileUtils.fromRelativeClassPath(path, cl);
        Resource resource = new Resource(file, path, -1);
        return FeatureParser.parse(resource);
    }

    public static Feature parseText(Feature old, String text) {
        Feature feature = old == null ? new Feature(null) : new Feature(old.getResource());
        feature = new FeatureParser((Feature)feature, (InputStream)FileUtils.toInputStream((String)text)).feature;
        if (old != null) {
            feature.setCallTag(old.getCallTag());
        }
        feature.setLines(StringUtils.toStringLines(text));
        return feature;
    }

    public static boolean updateStepFromText(Step step, String text) {
        Step temp;
        Feature feature = new Feature(step.getFeature().getResource());
        String stepText = text;
        boolean hasPrefix = prefix.stream().anyMatch(prefixValue -> stepText.trim().startsWith((String)prefixValue));
        if (!hasPrefix) {
            return false;
        }
        text = "Feature:\nScenario:\n" + text;
        FeatureParser fp = new FeatureParser(feature, FileUtils.toInputStream(text));
        if (!fp.errorListener.isFail() && (temp = (feature = fp.feature).getStep(0, -1, 0)) != null) {
            step.setPrefix(temp.getPrefix());
            step.setText(temp.getText());
            step.setDocString(temp.getDocString());
            step.setTable(temp.getTable());
            return true;
        }
        return false;
    }

    private static InputStream toStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private FeatureParser(File file, String relativePath, ClassLoader cl) {
        this(new Feature(new Resource(file, relativePath)), FeatureParser.toStream(file));
    }

    private FeatureParser(Resource resource) {
        this(new Feature(resource), resource.getStream());
    }

    private FeatureParser(Feature feature, InputStream is) {
        CharStream stream;
        this.feature = feature;
        try {
            stream = CharStreams.fromStream(is, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KarateLexer lexer = new KarateLexer(stream);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        KarateParser parser = new KarateParser(tokens);
        parser.addErrorListener(this.errorListener);
        KarateParser.FeatureContext tree = parser.feature();
        if (logger.isTraceEnabled()) {
            logger.debug(tree.toStringTree(parser));
        }
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk(this, tree);
        if (this.errorListener.isFail()) {
            String errorMessage = this.errorListener.getMessage();
            logger.error("not a valid feature file: {} - {}", (Object)feature.getResource().getRelativePath(), (Object)errorMessage);
            throw new RuntimeException(errorMessage);
        }
    }

    private static int getActualLine(TerminalNode node) {
        int count = 0;
        for (char c : node.getText().toCharArray()) {
            if (c == '\n') {
                ++count;
                continue;
            }
            if (!Character.isWhitespace(c)) break;
        }
        return node.getSymbol().getLine() + count;
    }

    private static List<Tag> toTags(int line, List<TerminalNode> nodes) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (TerminalNode node : nodes) {
            String[] tokens;
            String text = node.getText();
            if (line == -1) {
                line = FeatureParser.getActualLine(node);
            }
            for (String t : tokens = text.trim().split("\\s+")) {
                tags.add(new Tag(line, t));
            }
        }
        return tags;
    }

    private static Table toTable(KarateParser.TableContext ctx) {
        List<TerminalNode> nodes = ctx.TABLE_ROW();
        int rowCount = nodes.size();
        if (rowCount < 1) {
            return null;
        }
        ArrayList<List<String>> rows = new ArrayList<List<String>>(rowCount);
        ArrayList<Integer> lineNumbers = new ArrayList<Integer>(rowCount);
        for (TerminalNode node : nodes) {
            List<String> tokens = StringUtils.split(node.getText().trim(), '|');
            int count = tokens.size();
            for (int i = 0; i < count; ++i) {
                tokens.set(i, tokens.get(i).trim());
            }
            rows.add(tokens);
            lineNumbers.add(FeatureParser.getActualLine(node));
        }
        return new Table(rows, lineNumbers);
    }

    private static int indexOfFirstText(String s) {
        int pos = 0;
        for (char c : s.toCharArray()) {
            if (!Character.isWhitespace(c)) {
                return pos;
            }
            ++pos;
        }
        return 0;
    }

    private static String fixDocString(String temp) {
        int quotePos = temp.indexOf(TRIPLE_QUOTES);
        int endPos = temp.lastIndexOf(TRIPLE_QUOTES);
        String raw = temp.substring(quotePos + 3, endPos).replaceAll("\r", "");
        List<String> lines = StringUtils.split(raw, '\n');
        StringBuilder sb = new StringBuilder();
        int marginPos = -1;
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String line = iterator.next();
            if (marginPos == -1) {
                marginPos = FeatureParser.indexOfFirstText(line);
            }
            if (marginPos < line.length()) {
                line = line.substring(marginPos);
            }
            if (iterator.hasNext()) {
                sb.append(line).append('\n');
                continue;
            }
            sb.append(line);
        }
        return sb.toString().trim();
    }

    private static List<Step> toSteps(Feature feature, Scenario scenario, List<KarateParser.StepContext> list) {
        ArrayList<Step> steps = new ArrayList<Step>(list.size());
        int index = 0;
        for (KarateParser.StepContext sc : list) {
            Step step = new Step(feature, scenario, index++);
            steps.add(step);
            int stepLine = sc.line().getStart().getLine();
            step.setLine(stepLine);
            step.setPrefix(sc.prefix().getText().trim());
            step.setText(sc.line().getText().trim());
            if (sc.docString() != null) {
                String raw = sc.docString().getText();
                step.setDocString(FeatureParser.fixDocString(raw));
                step.setEndLine(stepLine + StringUtils.countLineFeeds(raw));
                continue;
            }
            if (sc.table() != null) {
                Table table = FeatureParser.toTable(sc.table());
                step.setTable(table);
                step.setEndLine(stepLine + StringUtils.countLineFeeds(sc.table().getText()));
                continue;
            }
            step.setEndLine(stepLine);
        }
        return steps;
    }

    @Override
    public void enterFeatureHeader(KarateParser.FeatureHeaderContext ctx) {
        if (ctx.featureTags() != null) {
            this.feature.setTags(FeatureParser.toTags(ctx.featureTags().getStart().getLine(), ctx.featureTags().FEATURE_TAGS()));
        }
        if (ctx.FEATURE() != null) {
            this.feature.setLine(ctx.FEATURE().getSymbol().getLine());
            if (ctx.featureDescription() != null) {
                StringUtils.Pair pair = StringUtils.splitByFirstLineFeed(ctx.featureDescription().getText());
                this.feature.setName(pair.left);
                this.feature.setDescription(pair.right);
            }
        }
    }

    @Override
    public void enterBackground(KarateParser.BackgroundContext ctx) {
        Background background = new Background();
        this.feature.setBackground(background);
        background.setLine(FeatureParser.getActualLine(ctx.BACKGROUND()));
        List<Step> steps = FeatureParser.toSteps(this.feature, null, ctx.step());
        if (!steps.isEmpty()) {
            background.setSteps(steps);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("background steps: {}", steps);
        }
    }

    @Override
    public void enterScenario(KarateParser.ScenarioContext ctx) {
        FeatureSection section = new FeatureSection();
        Scenario scenario = new Scenario(this.feature, section, -1);
        section.setScenario(scenario);
        this.feature.addSection(section);
        scenario.setLine(FeatureParser.getActualLine(ctx.SCENARIO()));
        if (ctx.tags() != null) {
            scenario.setTags(FeatureParser.toTags(-1, ctx.tags().TAGS()));
        }
        if (ctx.scenarioDescription() != null) {
            StringUtils.Pair pair = StringUtils.splitByFirstLineFeed(ctx.scenarioDescription().getText());
            scenario.setName(pair.left);
            scenario.setDescription(pair.right);
        }
        List<Step> steps = FeatureParser.toSteps(this.feature, scenario, ctx.step());
        scenario.setSteps(steps);
        if (logger.isTraceEnabled()) {
            logger.trace("scenario steps: {}", steps);
        }
    }

    @Override
    public void enterScenarioOutline(KarateParser.ScenarioOutlineContext ctx) {
        FeatureSection section = new FeatureSection();
        ScenarioOutline outline = new ScenarioOutline(this.feature, section);
        section.setScenarioOutline(outline);
        this.feature.addSection(section);
        outline.setLine(FeatureParser.getActualLine(ctx.SCENARIO_OUTLINE()));
        if (ctx.tags() != null) {
            outline.setTags(FeatureParser.toTags(-1, ctx.tags().TAGS()));
        }
        if (ctx.scenarioDescription() != null) {
            outline.setDescription(ctx.scenarioDescription().getText());
            StringUtils.Pair pair = StringUtils.splitByFirstLineFeed(ctx.scenarioDescription().getText());
            outline.setName(pair.left);
            outline.setDescription(pair.right);
        }
        List<Step> steps = FeatureParser.toSteps(this.feature, null, ctx.step());
        outline.setSteps(steps);
        if (logger.isTraceEnabled()) {
            logger.trace("outline steps: {}", steps);
        }
        ArrayList<ExamplesTable> examples = new ArrayList<ExamplesTable>(ctx.examples().size());
        outline.setExamplesTables(examples);
        for (KarateParser.ExamplesContext ec : ctx.examples()) {
            Table table = FeatureParser.toTable(ec.table());
            ExamplesTable example = new ExamplesTable(outline, table);
            examples.add(example);
            if (ec.tags() != null) {
                example.setTags(FeatureParser.toTags(-1, ec.tags().TAGS()));
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("example rows: {}", table.getRows());
        }
    }
}

