/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.Actions;
import com.intuit.karate.CallContext;
import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.Results;
import com.intuit.karate.StepActions;
import com.intuit.karate.StringUtils;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.core.Action;
import com.intuit.karate.core.Embed;
import com.intuit.karate.core.ExecutionContext;
import com.intuit.karate.core.ExecutionHook;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureContext;
import com.intuit.karate.core.FeatureExecutionUnit;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.MethodMatch;
import com.intuit.karate.core.MethodPattern;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepResult;
import com.intuit.karate.exception.KarateAbortException;
import com.intuit.karate.exception.KarateException;
import cucumber.api.java.en.When;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Engine {
    private static final Collection<MethodPattern> PATTERNS;
    private static final double MILLION = 1000000.0;
    private static final double BILLION = 1.0E9;
    private static final String UNKNOWN = "-unknown-";

    private Engine() {
    }

    public static double nanosToSeconds(long nanos) {
        return (double)nanos / 1.0E9;
    }

    public static double nanosToMillis(long nanos) {
        return (double)nanos / 1000000.0;
    }

    public static FeatureResult executeFeatureSync(String env, Feature feature, String tagSelector, CallContext callContext) {
        FeatureContext featureContext = new FeatureContext(env, feature, tagSelector);
        if (callContext == null) {
            callContext = new CallContext(null, true, new ExecutionHook[0]);
        }
        ExecutionContext exec = new ExecutionContext(System.currentTimeMillis(), featureContext, callContext, null, null, null);
        FeatureExecutionUnit unit = new FeatureExecutionUnit(exec);
        unit.run();
        return exec.result;
    }

    public static String getFeatureName(Step step) {
        if (step.getScenario() == null) {
            return UNKNOWN;
        }
        return step.getScenario().getFeature().getPath().getFileName().toString();
    }

    public static Result executeStep(Step step, Actions actions) {
        String text = step.getText();
        List<MethodMatch> matches = Engine.findMethodsMatching(text);
        if (matches.isEmpty()) {
            KarateException e = new KarateException("no step-definition method match found for: " + text);
            return Result.failed(0L, e, step);
        }
        if (matches.size() > 1) {
            KarateException e = new KarateException("more than one step-definition method matched: " + text + " - " + matches);
            return Result.failed(0L, e, step);
        }
        MethodMatch match = matches.get(0);
        Object last = step.getDocString() != null ? step.getDocString() : (step.getTable() != null ? step.getTable().getRowsAsMaps() : null);
        Object[] args = match.convertArgs(last);
        long startTime = System.nanoTime();
        try {
            match.method.invoke((Object)actions, args);
            return Result.passed(Engine.getElapsedTime(startTime));
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof KarateAbortException) {
                return Result.aborted(Engine.getElapsedTime(startTime));
            }
            return Result.failed(Engine.getElapsedTime(startTime), e.getTargetException(), step);
        }
        catch (Exception e) {
            return Result.failed(Engine.getElapsedTime(startTime), e, step);
        }
    }

    public static File saveResultJson(String targetDir, FeatureResult result, String fileName) {
        List<Map<String, Object>> single = Collections.singletonList(result.toMap());
        String json = JsonUtils.toJson(single);
        if (fileName == null) {
            fileName = result.getPackageQualifiedName() + ".json";
        }
        File file = new File(targetDir + File.separator + fileName);
        FileUtils.writeToFile(file, json);
        return file;
    }

    private static String formatNanos(long nanos, DecimalFormat formatter) {
        return formatter.format(Engine.nanosToSeconds(nanos));
    }

    private static String formatMillis(double millis, DecimalFormat formatter) {
        return formatter.format(millis / 1000.0);
    }

    private static Throwable appendSteps(List<StepResult> steps, StringBuilder sb) {
        Throwable error = null;
        for (StepResult sr : steps) {
            int length = sb.length();
            sb.append(sr.getStep().getPrefix());
            sb.append(' ');
            sb.append(sr.getStep().getText());
            sb.append(' ');
            do {
                sb.append('.');
            } while (sb.length() - length < 75);
            sb.append(' ');
            sb.append(sr.getResult().getStatus());
            sb.append('\n');
            if (!sr.getResult().isFailed()) continue;
            sb.append("\nStack Trace:\n");
            StringWriter sw = new StringWriter();
            error = sr.getResult().getError();
            error.printStackTrace(new PrintWriter(sw));
            sb.append(sw.toString());
            sb.append('\n');
        }
        return error;
    }

    public static File saveResultXml(String targetDir, FeatureResult result, String fileName) {
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        formatter.applyPattern("0.######");
        Document doc = XmlUtils.newDocument();
        Element root = doc.createElement("testsuite");
        doc.appendChild(root);
        root.setAttribute("name", result.getDisplayUri());
        root.setAttribute("skipped", "0");
        String baseName = result.getPackageQualifiedName();
        int testCount = 0;
        int failureCount = 0;
        long totalDuration = 0L;
        Iterator<ScenarioResult> iterator = result.getScenarioResults().iterator();
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            Element stepsHolder;
            ScenarioResult sr = iterator.next();
            totalDuration += sr.getDurationNanos();
            if (sr.isFailed()) {
                ++failureCount;
            }
            Element testCase = doc.createElement("testcase");
            root.appendChild(testCase);
            testCase.setAttribute("classname", baseName);
            ++testCount;
            long duration = sr.getDurationNanos();
            Throwable error = Engine.appendSteps(sr.getStepResults(), sb);
            String name = sr.getScenario().getName();
            if (StringUtils.isBlank(name)) {
                name = testCount + "";
            }
            testCase.setAttribute("name", name);
            testCase.setAttribute("time", Engine.formatNanos(duration, formatter));
            if (error != null) {
                stepsHolder = doc.createElement("failure");
                stepsHolder.setAttribute("message", error.getMessage());
            } else {
                stepsHolder = doc.createElement("system-out");
            }
            testCase.appendChild(stepsHolder);
            stepsHolder.setTextContent(sb.toString());
        }
        root.setAttribute("tests", testCount + "");
        root.setAttribute("failures", failureCount + "");
        root.setAttribute("time", Engine.formatNanos(totalDuration, formatter));
        String xml = XmlUtils.toString(doc, true);
        if (fileName == null) {
            fileName = baseName + ".xml";
        }
        File file = new File(targetDir + File.separator + fileName);
        FileUtils.writeToFile(file, xml);
        return file;
    }

    public static String getClasspathResource(String name) {
        return FileUtils.toString(Engine.class.getClassLoader().getResourceAsStream(name));
    }

    private static void set(Document doc, String path, String value) {
        XmlUtils.setByPath((Node)doc, path, value);
    }

    private static void append(Document doc, String path, Node node) {
        Node temp = XmlUtils.getNodeByPath(doc, path, true);
        temp.appendChild(node);
    }

    private static Node div(Document doc, String clazz, String value) {
        return Engine.node(doc, "div", clazz, value);
    }

    private static Node div(Document doc, String clazz, Node ... childNodes) {
        Node parent = Engine.node(doc, "div", clazz);
        for (Node child : childNodes) {
            parent.appendChild(child);
        }
        return parent;
    }

    private static Node node(Document doc, String name, String clazz, String text) {
        return XmlUtils.createElement(doc, name, text, clazz == null ? null : Collections.singletonMap("class", clazz));
    }

    private static Node node(Document doc, String name, String clazz) {
        return Engine.node(doc, name, clazz, null);
    }

    private static void callHtml(Document doc, DecimalFormat formatter, FeatureResult featureResult, Node parent) {
        String extraClass = featureResult.isFailed() ? "failed" : "passed";
        Node stepRow = Engine.div(doc, "step-row", Engine.div(doc, "step-cell " + extraClass, featureResult.getCallName()), Engine.div(doc, "time-cell " + extraClass, Engine.formatMillis(featureResult.getDurationMillis(), formatter)));
        parent.appendChild(stepRow);
        String callArg = featureResult.getCallArgPretty();
        if (callArg != null) {
            parent.appendChild(Engine.node(doc, "div", "preformatted", callArg));
        }
    }

    private static void stepHtml(Document doc, DecimalFormat formatter, StepResult stepResult, Node parent) {
        List<FeatureResult> callResults;
        Embed embed;
        Step step = stepResult.getStep();
        Result result = stepResult.getResult();
        String extraClass = result.isFailed() ? "failed" : (result.isSkipped() ? "skipped" : "passed");
        Node stepRow = Engine.div(doc, "step-row", Engine.div(doc, "step-cell " + extraClass, step.getPrefix() + ' ' + step.getText()), Engine.div(doc, "time-cell " + extraClass, Engine.formatNanos(result.getDurationNanos(), formatter)));
        parent.appendChild(stepRow);
        if (step.getTable() != null) {
            Node table = Engine.node(doc, "table", null);
            parent.appendChild(table);
            for (List<String> row : step.getTable().getRows()) {
                Node tr = Engine.node(doc, "tr", null);
                table.appendChild(tr);
                for (String cell : row) {
                    tr.appendChild(Engine.node(doc, "td", null, cell));
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        if (step.getDocString() != null) {
            sb.append(step.getDocString());
        }
        if (stepResult.getStepLog() != null) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(stepResult.getStepLog());
        }
        if (result.isFailed()) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(result.getError().getMessage());
        }
        if (sb.length() > 0) {
            parent.appendChild(Engine.node(doc, "div", "preformatted", sb.toString()));
        }
        if ((embed = stepResult.getEmbed()) != null) {
            Node embedNode;
            String mimeType = embed.getMimeType().toLowerCase();
            if (mimeType.contains("image")) {
                embedNode = Engine.node(doc, "img", null);
                String src = "data:" + embed.getMimeType() + ";base64," + embed.getBase64();
                XmlUtils.addAttributes((Element)embedNode, Collections.singletonMap("src", src));
            } else if (mimeType.contains("html")) {
                Node html;
                try {
                    html = XmlUtils.toXmlDoc(embed.getAsString()).getDocumentElement();
                }
                catch (Exception e) {
                    html = Engine.div(doc, null, e.getMessage());
                }
                html = doc.importNode(html, true);
                embedNode = Engine.div(doc, null, html);
            } else {
                embedNode = Engine.div(doc, null, new Node[0]);
                embedNode.setTextContent(embed.getAsString());
            }
            parent.appendChild(Engine.div(doc, "embed", embedNode));
        }
        if ((callResults = stepResult.getCallResults()) != null) {
            for (FeatureResult callResult : callResults) {
                Engine.callHtml(doc, formatter, callResult, parent);
                Node calledStepsDiv = Engine.div(doc, "scenario-steps-nested", new Node[0]);
                parent.appendChild(calledStepsDiv);
                for (StepResult sr : callResult.getStepResults()) {
                    Engine.stepHtml(doc, formatter, sr, calledStepsDiv);
                }
            }
        }
    }

    public static File saveResultHtml(String targetDir, FeatureResult result, String fileName) {
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        formatter.applyPattern("0.######");
        String html = Engine.getClasspathResource("report-template.html");
        String img = Engine.getClasspathResource("karate-logo.svg");
        Document svg = XmlUtils.toXmlDoc(img);
        String js = Engine.getClasspathResource("report-template-js.txt");
        Document doc = XmlUtils.toXmlDoc(html);
        XmlUtils.setByPath(doc, "/html/body/img", svg);
        String baseName = result.getPackageQualifiedName();
        Engine.set(doc, "/html/head/title", baseName);
        Engine.set(doc, "/html/head/script", js);
        for (ScenarioResult sr : result.getScenarioResults()) {
            Node scenarioDiv = Engine.div(doc, "scenario", new Node[0]);
            Engine.append(doc, "/html/body/div", scenarioDiv);
            Node scenarioHeadingDiv = Engine.div(doc, "scenario-heading", Engine.node(doc, "span", "scenario-keyword", sr.getScenario().getKeyword() + ": " + sr.getScenario().getDisplayMeta()), Engine.node(doc, "span", "scenario-name", sr.getScenario().getName()));
            scenarioDiv.appendChild(scenarioHeadingDiv);
            for (StepResult stepResult : sr.getStepResults()) {
                Engine.stepHtml(doc, formatter, stepResult, scenarioDiv);
            }
        }
        if (fileName == null) {
            fileName = baseName + ".html";
        }
        File file = new File(targetDir + File.separator + fileName);
        String xml = "<!DOCTYPE html>\n" + XmlUtils.toString(doc, false);
        try {
            FileUtils.writeToFile(file, xml);
            System.out.println("HTML report: (paste into browser to view) | Karate version: " + FileUtils.getKarateVersion() + "\n" + file.toURI() + "\n---------------------------------------------------------\n");
        }
        catch (Exception e) {
            System.out.println("html report output failed: " + e.getMessage());
        }
        return file;
    }

    private static long getElapsedTime(long startTime) {
        return System.nanoTime() - startTime;
    }

    public static File saveStatsJson(String targetDir, Results results, String fileName) {
        String json = JsonUtils.toJson(results.toMap());
        if (fileName == null) {
            fileName = "results-json.txt";
        }
        File file = new File(targetDir + File.separator + fileName);
        FileUtils.writeToFile(file, json);
        return file;
    }

    public static File saveTimelineHtml(String targetDir, Results results, String fileName) {
        LinkedHashMap<String, Integer> groupsMap = new LinkedHashMap<String, Integer>();
        List<ScenarioResult> scenarioResults = results.getScenarioResults();
        ArrayList items = new ArrayList(scenarioResults.size());
        int id = 1;
        for (ScenarioResult sr : scenarioResults) {
            String threadName = sr.getThreadName();
            Integer groupId = (Integer)groupsMap.get(threadName);
            if (groupId == null) {
                groupId = groupsMap.size() + 1;
                groupsMap.put(threadName, groupId);
            }
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>(7);
            items.add(item);
            item.put("id", id++);
            item.put("group", groupId);
            Scenario s = sr.getScenario();
            String featureName = s.getFeature().getResource().getFileNameWithoutExtension();
            String content = featureName + s.getDisplayMeta();
            item.put("content", content);
            item.put("start", sr.getStartTime());
            item.put("end", sr.getEndTime());
            item.put("title", content + " " + sr.getStartTime() + "-" + sr.getEndTime());
        }
        ArrayList groups = new ArrayList(groupsMap.size());
        groupsMap.forEach((k, v) -> {
            LinkedHashMap<String, Object> group = new LinkedHashMap<String, Object>(2);
            groups.add(group);
            group.put("id", v);
            group.put("content", k);
        });
        StringBuilder sb = new StringBuilder();
        sb.append("\nvar groups = new vis.DataSet(").append(JsonUtils.toJson(groups)).append(");").append('\n');
        sb.append("var items = new vis.DataSet(").append(JsonUtils.toJson(items)).append(");").append('\n');
        sb.append("var container = document.getElementById('visualization');\nvar timeline = new vis.Timeline(container);\ntimeline.setOptions({ groupOrder: 'content' });\ntimeline.setGroups(groups);\ntimeline.setItems(items);\n");
        if (fileName == null) {
            fileName = File.separator + "timeline.html";
        }
        File htmlFile = new File(targetDir + fileName);
        String html = Engine.getClasspathResource("timeline-template.html");
        html = html.replaceFirst("//timeline//", sb.toString());
        FileUtils.writeToFile(htmlFile, html);
        return htmlFile;
    }

    private static List<MethodMatch> findMethodsMatching(String text) {
        ArrayList<MethodMatch> matches = new ArrayList<MethodMatch>(1);
        for (MethodPattern pattern : PATTERNS) {
            List<String> args = pattern.match(text);
            if (args == null) continue;
            matches.add(new MethodMatch(pattern.method, args));
        }
        return matches;
    }

    static {
        HashMap<String, MethodPattern> temp = new HashMap<String, MethodPattern>();
        ArrayList<MethodPattern> overwrite = new ArrayList<MethodPattern>();
        for (Method method : StepActions.class.getMethods()) {
            When when = method.getDeclaredAnnotation(When.class);
            if (when != null) {
                String regex = when.value();
                temp.put(regex, new MethodPattern(method, regex));
                continue;
            }
            Action action = method.getDeclaredAnnotation(Action.class);
            if (action == null) continue;
            String regex = action.value();
            overwrite.add(new MethodPattern(method, regex));
        }
        for (MethodPattern mp : overwrite) {
            temp.put(mp.regex, mp);
        }
        PATTERNS = temp.values();
    }
}

