/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.JsonUtils;
import com.intuit.karate.Match;
import com.intuit.karate.Script;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.StringUtils;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import java.util.Map;

public class Json {
    private final DocumentContext doc;
    private final boolean array;
    private final String prefix;

    private String prefix(String path) {
        return path.charAt(0) == '$' ? path : this.prefix + path;
    }

    public Json() {
        this("{}");
    }

    public Json(String json) {
        this(JsonUtils.toJsonDoc(json));
    }

    public Json(Map map) {
        this(JsonUtils.toJsonDoc(map));
    }

    public Json(Object o) {
        this(JsonUtils.toJsonDoc(o));
    }

    private Json(DocumentContext doc) {
        this.doc = doc;
        this.array = doc.json() instanceof List;
        this.prefix = this.array ? "$" : "$.";
    }

    public DocumentContext getDoc() {
        return this.doc;
    }

    public ScriptValue getValue() {
        return new ScriptValue(this.doc);
    }

    public Json set(String path, Object value) {
        JsonUtils.setValueByPath(this.doc, this.prefix(path), value);
        return this;
    }

    public Json set(String path, String value) {
        Object temp = value;
        String trimmed = StringUtils.trimToNull(value);
        if (Script.isJson(trimmed)) {
            temp = JsonUtils.toJsonDoc(trimmed).read("$", new Predicate[0]);
        }
        this.set(path, temp);
        return this;
    }

    public Match getMatcher(String path) {
        return Match.init(this.get(path));
    }

    public Json getJson(String path) {
        return new Json(this.get(path));
    }

    public Object get(String path) {
        return this.doc.read(this.prefix(path), new Predicate[0]);
    }

    public <T> T get(String path, Class<T> clazz) {
        return (T)this.doc.read(this.prefix(path), clazz, new Predicate[0]);
    }

    public String toString() {
        return this.doc.jsonString();
    }

    public boolean isArray() {
        return this.array;
    }

    public Map<String, Object> asMap() {
        return (Map)this.doc.read("$", new Predicate[0]);
    }

    public List<Map<String, Object>> asList() {
        return (List)this.doc.read("$", new Predicate[0]);
    }

    public Json equals(String exp) {
        Match.equals(this.doc.read("$", new Predicate[0]), exp);
        return this;
    }
}

