/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.FileUtils;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.StringUtils;
import com.intuit.karate.http.HttpClient;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public class Config {
    public static final int DEFAULT_RETRY_INTERVAL = 3000;
    public static final int DEFAULT_RETRY_COUNT = 3;
    private boolean sslEnabled = false;
    private String sslAlgorithm = "TLS";
    private String sslKeyStore;
    private String sslKeyStorePassword;
    private String sslKeyStoreType;
    private String sslTrustStore;
    private String sslTrustStorePassword;
    private String sslTrustStoreType;
    private boolean sslTrustAll = true;
    private boolean followRedirects = true;
    private int readTimeout = 30000;
    private int connectTimeout = 30000;
    private Charset charset = FileUtils.UTF8;
    private String proxyUri;
    private String proxyUsername;
    private String proxyPassword;
    private List<String> nonProxyHosts;
    private ScriptValue headers = ScriptValue.NULL;
    private ScriptValue cookies = ScriptValue.NULL;
    private ScriptValue responseHeaders = ScriptValue.NULL;
    private boolean lowerCaseResponseHeaders = false;
    private boolean corsEnabled = false;
    private boolean logPrettyRequest;
    private boolean logPrettyResponse;
    private boolean printEnabled = true;
    private boolean outlineVariablesAuto = true;
    private String clientClass;
    private HttpClient clientInstance;
    private Map<String, Object> userDefined;
    private Map<String, Object> driverOptions;
    private ScriptValue afterScenario = ScriptValue.NULL;
    private ScriptValue afterFeature = ScriptValue.NULL;
    private int retryInterval = 3000;
    private int retryCount = 3;
    private boolean showLog = true;
    private boolean showAllSteps = true;

    public Config() {
    }

    private static <T> T get(Map<String, Object> map, String key, T defaultValue) {
        Object o = map.get(key);
        return (T)(o == null ? defaultValue : o);
    }

    public boolean configure(String key, ScriptValue value) {
        switch (key = StringUtils.trimToEmpty(key)) {
            case "headers": {
                this.headers = value;
                return false;
            }
            case "cookies": {
                this.cookies = value;
                return false;
            }
            case "responseHeaders": {
                this.responseHeaders = value;
                return false;
            }
            case "lowerCaseResponseHeaders": {
                this.lowerCaseResponseHeaders = value.isBooleanTrue();
                return false;
            }
            case "cors": {
                this.corsEnabled = value.isBooleanTrue();
                return false;
            }
            case "logPrettyResponse": {
                this.logPrettyResponse = value.isBooleanTrue();
                return false;
            }
            case "logPrettyRequest": {
                this.logPrettyRequest = value.isBooleanTrue();
                return false;
            }
            case "printEnabled": {
                this.printEnabled = value.isBooleanTrue();
                return false;
            }
            case "afterScenario": {
                this.afterScenario = value;
                return false;
            }
            case "afterFeature": {
                this.afterFeature = value;
                return false;
            }
            case "report": {
                if (value.isMapLike()) {
                    Map<String, Object> map = value.getAsMap();
                    this.showLog = Config.get(map, "showLog", this.showLog);
                    this.showAllSteps = Config.get(map, "showAllSteps", this.showAllSteps);
                } else if (value.isBooleanTrue()) {
                    this.showLog = true;
                    this.showAllSteps = true;
                } else {
                    this.showLog = false;
                    this.showAllSteps = false;
                }
                return false;
            }
            case "driver": {
                this.driverOptions = value.getAsMap();
                return false;
            }
            case "retry": {
                if (value.isMapLike()) {
                    Map<String, Object> map = value.getAsMap();
                    this.retryInterval = Config.get(map, "interval", this.retryInterval);
                    this.retryCount = Config.get(map, "count", this.retryCount);
                }
                return false;
            }
            case "outlineVariablesAuto": {
                this.outlineVariablesAuto = value.isBooleanTrue();
                return false;
            }
            case "httpClientClass": {
                this.clientClass = value.getAsString();
                return true;
            }
            case "httpClientInstance": {
                this.clientInstance = value.getValue(HttpClient.class);
                return true;
            }
            case "charset": {
                this.charset = value.isNull() ? null : Charset.forName(value.getAsString());
                return true;
            }
            case "ssl": {
                if (value.isString()) {
                    this.sslEnabled = true;
                    this.sslAlgorithm = value.getAsString();
                } else if (value.isMapLike()) {
                    this.sslEnabled = true;
                    Map<String, Object> map = value.getAsMap();
                    this.sslKeyStore = (String)map.get("keyStore");
                    this.sslKeyStorePassword = (String)map.get("keyStorePassword");
                    this.sslKeyStoreType = (String)map.get("keyStoreType");
                    this.sslTrustStore = (String)map.get("trustStore");
                    this.sslTrustStorePassword = (String)map.get("trustStorePassword");
                    this.sslTrustStoreType = (String)map.get("trustStoreType");
                    Boolean trustAll = (Boolean)map.get("trustAll");
                    if (trustAll != null) {
                        this.sslTrustAll = trustAll;
                    }
                    this.sslAlgorithm = (String)map.get("algorithm");
                } else {
                    this.sslEnabled = value.isBooleanTrue();
                }
                return true;
            }
            case "followRedirects": {
                this.followRedirects = value.isBooleanTrue();
                return true;
            }
            case "connectTimeout": {
                this.connectTimeout = value.getAsInt();
                return true;
            }
            case "readTimeout": {
                this.readTimeout = value.getAsInt();
                return true;
            }
            case "proxy": {
                if (value == null) {
                    this.proxyUri = null;
                } else if (value.isString()) {
                    this.proxyUri = value.getAsString();
                } else {
                    Map<String, Object> map = value.getAsMap();
                    this.proxyUri = (String)map.get("uri");
                    this.proxyUsername = (String)map.get("username");
                    this.proxyPassword = (String)map.get("password");
                    ScriptObjectMirror temp = (ScriptObjectMirror)map.get("nonProxyHosts");
                    if (temp != null) {
                        this.nonProxyHosts = (List)temp.values();
                    }
                }
                return true;
            }
            case "userDefined": {
                this.userDefined = value.getAsMap();
                return true;
            }
        }
        throw new RuntimeException("unexpected 'configure' key: '" + key + "'");
    }

    public Config(Config parent) {
        this.sslEnabled = parent.sslEnabled;
        this.sslAlgorithm = parent.sslAlgorithm;
        this.sslTrustStore = parent.sslTrustStore;
        this.sslTrustStorePassword = parent.sslTrustStorePassword;
        this.sslTrustStoreType = parent.sslTrustStoreType;
        this.sslKeyStore = parent.sslKeyStore;
        this.sslKeyStorePassword = parent.sslKeyStorePassword;
        this.sslKeyStoreType = parent.sslKeyStoreType;
        this.sslTrustAll = parent.sslTrustAll;
        this.followRedirects = parent.followRedirects;
        this.readTimeout = parent.readTimeout;
        this.connectTimeout = parent.connectTimeout;
        this.charset = parent.charset;
        this.proxyUri = parent.proxyUri;
        this.proxyUsername = parent.proxyUsername;
        this.proxyPassword = parent.proxyPassword;
        this.nonProxyHosts = parent.nonProxyHosts;
        this.headers = parent.headers;
        this.cookies = parent.cookies;
        this.responseHeaders = parent.responseHeaders;
        this.lowerCaseResponseHeaders = parent.lowerCaseResponseHeaders;
        this.corsEnabled = parent.corsEnabled;
        this.logPrettyRequest = parent.logPrettyRequest;
        this.logPrettyResponse = parent.logPrettyResponse;
        this.printEnabled = parent.printEnabled;
        this.clientClass = parent.clientClass;
        this.clientInstance = parent.clientInstance;
        this.userDefined = parent.userDefined;
        this.driverOptions = parent.driverOptions;
        this.afterScenario = parent.afterScenario;
        this.afterFeature = parent.afterFeature;
        this.showLog = parent.showLog;
        this.showAllSteps = parent.showAllSteps;
        this.retryInterval = parent.retryInterval;
        this.retryCount = parent.retryCount;
        this.outlineVariablesAuto = parent.outlineVariablesAuto;
    }

    public void setCookies(ScriptValue cookies) {
        this.cookies = cookies;
    }

    public void setClientClass(String clientClass) {
        this.clientClass = clientClass;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public String getSslAlgorithm() {
        return this.sslAlgorithm;
    }

    public String getSslKeyStore() {
        return this.sslKeyStore;
    }

    public String getSslKeyStorePassword() {
        return this.sslKeyStorePassword;
    }

    public String getSslKeyStoreType() {
        return this.sslKeyStoreType;
    }

    public String getSslTrustStore() {
        return this.sslTrustStore;
    }

    public String getSslTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    public String getSslTrustStoreType() {
        return this.sslTrustStoreType;
    }

    public boolean isSslTrustAll() {
        return this.sslTrustAll;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getProxyUri() {
        return this.proxyUri;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public List<String> getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public ScriptValue getHeaders() {
        return this.headers;
    }

    public ScriptValue getCookies() {
        return this.cookies;
    }

    public ScriptValue getResponseHeaders() {
        return this.responseHeaders;
    }

    public boolean isLowerCaseResponseHeaders() {
        return this.lowerCaseResponseHeaders;
    }

    public boolean isCorsEnabled() {
        return this.corsEnabled;
    }

    public boolean isLogPrettyRequest() {
        return this.logPrettyRequest;
    }

    public boolean isLogPrettyResponse() {
        return this.logPrettyResponse;
    }

    public boolean isPrintEnabled() {
        return this.printEnabled;
    }

    public String getClientClass() {
        return this.clientClass;
    }

    public Map<String, Object> getUserDefined() {
        return this.userDefined;
    }

    public Map<String, Object> getDriverOptions() {
        return this.driverOptions;
    }

    public HttpClient getClientInstance() {
        return this.clientInstance;
    }

    public void setClientInstance(HttpClient clientInstance) {
        this.clientInstance = clientInstance;
    }

    public ScriptValue getAfterScenario() {
        return this.afterScenario;
    }

    public void setAfterScenario(ScriptValue afterScenario) {
        this.afterScenario = afterScenario;
    }

    public ScriptValue getAfterFeature() {
        return this.afterFeature;
    }

    public void setAfterFeature(ScriptValue afterFeature) {
        this.afterFeature = afterFeature;
    }

    public boolean isShowLog() {
        return this.showLog;
    }

    public void setShowLog(boolean showLog) {
        this.showLog = showLog;
    }

    public boolean isShowAllSteps() {
        return this.showAllSteps;
    }

    public void setShowAllSteps(boolean showAllSteps) {
        this.showAllSteps = showAllSteps;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public boolean isOutlineVariablesAuto() {
        return this.outlineVariablesAuto;
    }
}

