/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.ui;

import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.Tooltip;

public abstract class TooltipCell<S, T>
extends TableCell<S, T> {
    private Tooltip customTooltip;

    protected abstract String getCellText(T var1);

    protected abstract String getTooltipText(T var1);

    private void initTooltipMouseEvents() {
        this.setOnMouseEntered(e -> {
            if (this.customTooltip != null) {
                Point2D p = this.localToScreen(this.getLayoutBounds().getMaxX(), this.getLayoutBounds().getMaxY());
                this.customTooltip.show((Node)this, p.getX(), p.getY());
            }
        });
        this.setOnMouseExited(e -> {
            if (this.customTooltip != null) {
                this.customTooltip.hide();
            }
        });
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (!empty) {
            this.setText(this.getCellText(item));
            this.customTooltip = new Tooltip(this.getTooltipText(item));
            this.initTooltipMouseEvents();
        }
    }
}

